/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public enum Difficulty {
    PEACEFUL(0, "peaceful"),
    EASY(1, "easy"),
    NORMAL(2, "normal"),
    HARD(3, "hard");

    private static final Difficulty[] BY_ID;
    private final int id;
    private final String key;

    static {
        BY_ID = (Difficulty[])Arrays.stream(Difficulty.values()).sorted(Comparator.comparingInt(Difficulty::getId)).toArray(Difficulty[]::new);
    }

    private Difficulty(int p_19026_, String p_19027_) {
        this.id = p_19026_;
        this.key = p_19027_;
    }

    public int getId() {
        return this.id;
    }

    public Component getDisplayName() {
        return new TranslatableComponent("options.difficulty." + this.key);
    }

    public static Difficulty byId(int pId) {
        return BY_ID[pId % BY_ID.length];
    }

    @Nullable
    public static Difficulty byName(String pName) {
        Difficulty[] difficultyArray = Difficulty.values();
        int n = difficultyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Difficulty difficulty = difficultyArray[n2];
            if (difficulty.key.equals(pName)) {
                return difficulty;
            }
            ++n2;
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }
}

