/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import javax.annotation.concurrent.Immutable;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;

@Immutable
public class DifficultyInstance {
    private static final float DIFFICULTY_TIME_GLOBAL_OFFSET = -72000.0f;
    private static final float MAX_DIFFICULTY_TIME_GLOBAL = 1440000.0f;
    private static final float MAX_DIFFICULTY_TIME_LOCAL = 3600000.0f;
    private final Difficulty base;
    private final float effectiveDifficulty;

    public DifficultyInstance(Difficulty pBase, long pLevelTime, long p_19046_, float pChunkInhabitedTime) {
        this.base = pBase;
        this.effectiveDifficulty = this.calculateDifficulty(pBase, pLevelTime, p_19046_, pChunkInhabitedTime);
    }

    public Difficulty getDifficulty() {
        return this.base;
    }

    public float getEffectiveDifficulty() {
        return this.effectiveDifficulty;
    }

    public boolean isHard() {
        return this.effectiveDifficulty >= (float)Difficulty.HARD.ordinal();
    }

    public boolean isHarderThan(float pDifficulty) {
        return this.effectiveDifficulty > pDifficulty;
    }

    public float getSpecialMultiplier() {
        if (this.effectiveDifficulty < 2.0f) {
            return 0.0f;
        }
        return this.effectiveDifficulty > 4.0f ? 1.0f : (this.effectiveDifficulty - 2.0f) / 2.0f;
    }

    private float calculateDifficulty(Difficulty pDifficulty, long pLevelTime, long p_19054_, float pChunkInhabitedTime) {
        if (pDifficulty == Difficulty.PEACEFUL) {
            return 0.0f;
        }
        boolean flag = pDifficulty == Difficulty.HARD;
        float f = 0.75f;
        float f1 = Mth.clamp(((float)pLevelTime + -72000.0f) / 1440000.0f, 0.0f, 1.0f) * 0.25f;
        f += f1;
        float f2 = 0.0f;
        f2 += Mth.clamp((float)p_19054_ / 3600000.0f, 0.0f, 1.0f) * (flag ? 1.0f : 0.75f);
        f2 += Mth.clamp(pChunkInhabitedTime * 0.25f, 0.0f, f1);
        if (pDifficulty == Difficulty.EASY) {
            f2 *= 0.5f;
        }
        return (float)pDifficulty.getId() * (f += f2);
    }
}

