/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HoneyBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListenerRegistrar;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.slf4j.Logger;

public abstract class Entity
implements Nameable,
EntityAccess,
CommandSource {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String ID_TAG = "id";
    public static final String PASSENGERS_TAG = "Passengers";
    private static final AtomicInteger ENTITY_COUNTER = new AtomicInteger();
    private static final List<ItemStack> EMPTY_LIST = Collections.emptyList();
    public static final int BOARDING_COOLDOWN = 60;
    public static final int TOTAL_AIR_SUPPLY = 300;
    public static final int MAX_ENTITY_TAG_COUNT = 1024;
    public static final double DELTA_AFFECTED_BY_BLOCKS_BELOW = 0.5000001;
    public static final float BREATHING_DISTANCE_BELOW_EYES = 0.11111111f;
    public static final int BASE_TICKS_REQUIRED_TO_FREEZE = 140;
    public static final int FREEZE_HURT_FREQUENCY = 40;
    private static final AABB INITIAL_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double WATER_FLOW_SCALE = 0.014;
    private static final double LAVA_FAST_FLOW_SCALE = 0.007;
    private static final double LAVA_SLOW_FLOW_SCALE = 0.0023333333333333335;
    public static final String UUID_TAG = "UUID";
    private static double viewScale = 1.0;
    private final EntityType<?> type;
    private int id = ENTITY_COUNTER.incrementAndGet();
    public boolean blocksBuilding;
    private ImmutableList<Entity> passengers = ImmutableList.of();
    protected int boardingCooldown;
    @Nullable
    private Entity vehicle;
    public Level level;
    public double xo;
    public double yo;
    public double zo;
    private Vec3 position;
    private BlockPos blockPosition;
    private ChunkPos chunkPosition;
    private Vec3 deltaMovement = Vec3.ZERO;
    private float yRot;
    private float xRot;
    public float yRotO;
    public float xRotO;
    private AABB bb = INITIAL_AABB;
    protected boolean onGround;
    public boolean horizontalCollision;
    public boolean verticalCollision;
    public boolean verticalCollisionBelow;
    public boolean minorHorizontalCollision;
    public boolean hurtMarked;
    protected Vec3 stuckSpeedMultiplier = Vec3.ZERO;
    @Nullable
    private RemovalReason removalReason;
    public static final float DEFAULT_BB_WIDTH = 0.6f;
    public static final float DEFAULT_BB_HEIGHT = 1.8f;
    public float walkDistO;
    public float walkDist;
    public float moveDist;
    public float flyDist;
    public float fallDistance;
    private float nextStep = 1.0f;
    public double xOld;
    public double yOld;
    public double zOld;
    public float maxUpStep;
    public boolean noPhysics;
    protected final Random random = new Random();
    public int tickCount;
    private int remainingFireTicks = -this.getFireImmuneTicks();
    protected boolean wasTouchingWater;
    protected Object2DoubleMap<TagKey<Fluid>> fluidHeight = new Object2DoubleArrayMap(2);
    protected boolean wasEyeInWater;
    private final Set<TagKey<Fluid>> fluidOnEyes = new HashSet<TagKey<Fluid>>();
    public int invulnerableTime;
    protected boolean firstTick = true;
    protected final SynchedEntityData entityData;
    protected static final EntityDataAccessor<Byte> DATA_SHARED_FLAGS_ID = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.BYTE);
    protected static final int FLAG_ONFIRE = 0;
    private static final int FLAG_SHIFT_KEY_DOWN = 1;
    private static final int FLAG_SPRINTING = 3;
    private static final int FLAG_SWIMMING = 4;
    private static final int FLAG_INVISIBLE = 5;
    protected static final int FLAG_GLOWING = 6;
    protected static final int FLAG_FALL_FLYING = 7;
    private static final EntityDataAccessor<Integer> DATA_AIR_SUPPLY_ID = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<Component>> DATA_CUSTOM_NAME = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.OPTIONAL_COMPONENT);
    private static final EntityDataAccessor<Boolean> DATA_CUSTOM_NAME_VISIBLE = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_SILENT = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_NO_GRAVITY = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Pose> DATA_POSE = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.POSE);
    private static final EntityDataAccessor<Integer> DATA_TICKS_FROZEN = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.INT);
    private EntityInLevelCallback levelCallback = EntityInLevelCallback.NULL;
    private Vec3 packetCoordinates;
    public boolean noCulling;
    public boolean hasImpulse;
    private int portalCooldown;
    protected boolean isInsidePortal;
    protected int portalTime;
    protected BlockPos portalEntrancePos;
    private boolean invulnerable;
    protected UUID uuid = Mth.createInsecureUUID(this.random);
    protected String stringUUID = this.uuid.toString();
    private boolean hasGlowingTag;
    private final Set<String> tags = Sets.newHashSet();
    private final double[] pistonDeltas = new double[]{0.0, 0.0, 0.0};
    private long pistonDeltasGameTime;
    private EntityDimensions dimensions;
    private float eyeHeight;
    public boolean isInPowderSnow;
    public boolean wasInPowderSnow;
    public boolean wasOnFire;
    private float crystalSoundIntensity;
    private int lastCrystalSoundPlayTick;
    private boolean hasVisualFire;
    @Nullable
    private BlockState feetBlockState = null;

    public Entity(EntityType<?> pEntityType, Level pLevel) {
        this.type = pEntityType;
        this.level = pLevel;
        this.dimensions = pEntityType.getDimensions();
        this.position = Vec3.ZERO;
        this.blockPosition = BlockPos.ZERO;
        this.chunkPosition = ChunkPos.ZERO;
        this.packetCoordinates = Vec3.ZERO;
        this.entityData = new SynchedEntityData(this);
        this.entityData.define(DATA_SHARED_FLAGS_ID, (byte)0);
        this.entityData.define(DATA_AIR_SUPPLY_ID, this.getMaxAirSupply());
        this.entityData.define(DATA_CUSTOM_NAME_VISIBLE, false);
        this.entityData.define(DATA_CUSTOM_NAME, Optional.empty());
        this.entityData.define(DATA_SILENT, false);
        this.entityData.define(DATA_NO_GRAVITY, false);
        this.entityData.define(DATA_POSE, Pose.STANDING);
        this.entityData.define(DATA_TICKS_FROZEN, 0);
        this.defineSynchedData();
        this.setPos(0.0, 0.0, 0.0);
        this.eyeHeight = this.getEyeHeight(Pose.STANDING, this.dimensions);
    }

    public boolean isColliding(BlockPos pPos, BlockState pState) {
        VoxelShape voxelshape = pState.getCollisionShape(this.level, pPos, CollisionContext.of(this));
        VoxelShape voxelshape1 = voxelshape.move(pPos.getX(), pPos.getY(), pPos.getZ());
        return Shapes.joinIsNotEmpty(voxelshape1, Shapes.create(this.getBoundingBox()), BooleanOp.AND);
    }

    public int getTeamColor() {
        Team team = this.getTeam();
        return team != null && team.getColor().getColor() != null ? team.getColor().getColor() : 0xFFFFFF;
    }

    public boolean isSpectator() {
        return false;
    }

    public final void unRide() {
        if (this.isVehicle()) {
            this.ejectPassengers();
        }
        if (this.isPassenger()) {
            this.stopRiding();
        }
    }

    public void setPacketCoordinates(double pX, double p_20169_, double pY) {
        this.setPacketCoordinates(new Vec3(pX, p_20169_, pY));
    }

    public void setPacketCoordinates(Vec3 pPacketCoordinates) {
        this.packetCoordinates = pPacketCoordinates;
    }

    public Vec3 getPacketCoordinates() {
        return this.packetCoordinates;
    }

    public EntityType<?> getType() {
        return this.type;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int pId) {
        this.id = pId;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public boolean addTag(String pTag) {
        return this.tags.size() >= 1024 ? false : this.tags.add(pTag);
    }

    public boolean removeTag(String pTag) {
        return this.tags.remove(pTag);
    }

    public void kill() {
        this.remove(RemovalReason.KILLED);
    }

    public final void discard() {
        this.remove(RemovalReason.DISCARDED);
    }

    protected abstract void defineSynchedData();

    public SynchedEntityData getEntityData() {
        return this.entityData;
    }

    public boolean equals(Object pObject) {
        if (pObject instanceof Entity) {
            return ((Entity)pObject).id == this.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public void remove(RemovalReason pReason) {
        this.setRemoved(pReason);
        if (pReason == RemovalReason.KILLED) {
            this.gameEvent(GameEvent.ENTITY_KILLED);
        }
    }

    public void onClientRemoval() {
    }

    public void setPose(Pose pPose) {
        this.entityData.set(DATA_POSE, pPose);
    }

    public Pose getPose() {
        return this.entityData.get(DATA_POSE);
    }

    public boolean closerThan(Entity pEntity, double pDistance) {
        double d0 = pEntity.position.x - this.position.x;
        double d1 = pEntity.position.y - this.position.y;
        double d2 = pEntity.position.z - this.position.z;
        return d0 * d0 + d1 * d1 + d2 * d2 < pDistance * pDistance;
    }

    protected void setRot(float pYaw, float pPitch) {
        this.setYRot(pYaw % 360.0f);
        this.setXRot(pPitch % 360.0f);
    }

    public final void setPos(Vec3 pPos) {
        this.setPos(pPos.x(), pPos.y(), pPos.z());
    }

    public void setPos(double p_20210_, double p_20211_, double p_20212_) {
        this.setPosRaw(p_20210_, p_20211_, p_20212_);
        this.setBoundingBox(this.makeBoundingBox());
    }

    protected AABB makeBoundingBox() {
        return this.dimensions.makeBoundingBox(this.position);
    }

    protected void reapplyPosition() {
        this.setPos(this.position.x, this.position.y, this.position.z);
    }

    public void turn(double pYaw, double p_19886_) {
        float f = (float)p_19886_ * 0.15f;
        float f1 = (float)pYaw * 0.15f;
        this.setXRot(this.getXRot() + f);
        this.setYRot(this.getYRot() + f1);
        this.setXRot(Mth.clamp(this.getXRot(), -90.0f, 90.0f));
        this.xRotO += f;
        this.yRotO += f1;
        this.xRotO = Mth.clamp(this.xRotO, -90.0f, 90.0f);
        if (this.vehicle != null) {
            this.vehicle.onPassengerTurned(this);
        }
    }

    public void tick() {
        this.baseTick();
    }

    public void baseTick() {
        this.level.getProfiler().push("entityBaseTick");
        this.feetBlockState = null;
        if (this.isPassenger() && this.getVehicle().isRemoved()) {
            this.stopRiding();
        }
        if (this.boardingCooldown > 0) {
            --this.boardingCooldown;
        }
        this.walkDistO = this.walkDist;
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.handleNetherPortal();
        if (this.canSpawnSprintParticle()) {
            this.spawnSprintParticle();
        }
        this.wasInPowderSnow = this.isInPowderSnow;
        this.isInPowderSnow = false;
        this.updateInWaterStateAndDoFluidPushing();
        this.updateFluidOnEyes();
        this.updateSwimming();
        if (this.level.isClientSide) {
            this.clearFire();
        } else if (this.remainingFireTicks > 0) {
            if (this.fireImmune()) {
                this.setRemainingFireTicks(this.remainingFireTicks - 4);
                if (this.remainingFireTicks < 0) {
                    this.clearFire();
                }
            } else {
                if (this.remainingFireTicks % 20 == 0 && !this.isInLava()) {
                    this.hurt(DamageSource.ON_FIRE, 1.0f);
                }
                this.setRemainingFireTicks(this.remainingFireTicks - 1);
            }
            if (this.getTicksFrozen() > 0) {
                this.setTicksFrozen(0);
                this.level.levelEvent(null, 1009, this.blockPosition, 1);
            }
        }
        if (this.isInLava()) {
            this.lavaHurt();
            this.fallDistance *= 0.5f;
        }
        this.checkOutOfWorld();
        if (!this.level.isClientSide) {
            this.setSharedFlagOnFire(this.remainingFireTicks > 0);
        }
        this.firstTick = false;
        this.level.getProfiler().pop();
    }

    public void setSharedFlagOnFire(boolean pIsOnFire) {
        this.setSharedFlag(0, pIsOnFire || this.hasVisualFire);
    }

    public void checkOutOfWorld() {
        if (this.getY() < (double)(this.level.getMinBuildHeight() - 64)) {
            this.outOfWorld();
        }
    }

    public void setPortalCooldown() {
        this.portalCooldown = this.getDimensionChangingDelay();
    }

    public boolean isOnPortalCooldown() {
        return this.portalCooldown > 0;
    }

    protected void processPortalCooldown() {
        if (this.isOnPortalCooldown()) {
            --this.portalCooldown;
        }
    }

    public int getPortalWaitTime() {
        return 0;
    }

    public void lavaHurt() {
        if (!this.fireImmune()) {
            this.setSecondsOnFire(15);
            if (this.hurt(DamageSource.LAVA, 4.0f)) {
                this.playSound(SoundEvents.GENERIC_BURN, 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
            }
        }
    }

    public void setSecondsOnFire(int pSeconds) {
        int i = pSeconds * 20;
        if (this instanceof LivingEntity) {
            i = ProtectionEnchantment.getFireAfterDampener((LivingEntity)this, i);
        }
        if (this.remainingFireTicks < i) {
            this.setRemainingFireTicks(i);
        }
    }

    public void setRemainingFireTicks(int pTicks) {
        this.remainingFireTicks = pTicks;
    }

    public int getRemainingFireTicks() {
        return this.remainingFireTicks;
    }

    public void clearFire() {
        this.setRemainingFireTicks(0);
    }

    protected void outOfWorld() {
        this.discard();
    }

    public boolean isFree(double pX, double p_20231_, double pY) {
        return this.isFree(this.getBoundingBox().move(pX, p_20231_, pY));
    }

    private boolean isFree(AABB pBb) {
        return this.level.noCollision(this, pBb) && !this.level.containsAnyLiquid(pBb);
    }

    public void setOnGround(boolean pGrounded) {
        this.onGround = pGrounded;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public void move(MoverType pType, Vec3 pPos) {
        if (this.noPhysics) {
            this.setPos(this.getX() + pPos.x, this.getY() + pPos.y, this.getZ() + pPos.z);
        } else {
            Vec3 vec3;
            double d0;
            this.wasOnFire = this.isOnFire();
            if (pType == MoverType.PISTON && (pPos = this.limitPistonMovement(pPos)).equals(Vec3.ZERO)) {
                return;
            }
            this.level.getProfiler().push("move");
            if (this.stuckSpeedMultiplier.lengthSqr() > 1.0E-7) {
                pPos = pPos.multiply(this.stuckSpeedMultiplier);
                this.stuckSpeedMultiplier = Vec3.ZERO;
                this.setDeltaMovement(Vec3.ZERO);
            }
            if ((d0 = (vec3 = this.collide(pPos = this.maybeBackOffFromEdge(pPos, pType))).lengthSqr()) > 1.0E-7) {
                BlockHitResult blockhitresult;
                if (this.fallDistance != 0.0f && d0 >= 1.0 && (blockhitresult = this.level.clip(new ClipContext(this.position(), this.position().add(vec3), ClipContext.Block.FALLDAMAGE_RESETTING, ClipContext.Fluid.WATER, this))).getType() != HitResult.Type.MISS) {
                    this.resetFallDistance();
                }
                this.setPos(this.getX() + vec3.x, this.getY() + vec3.y, this.getZ() + vec3.z);
            }
            this.level.getProfiler().pop();
            this.level.getProfiler().push("rest");
            boolean flag1 = !Mth.equal(pPos.x, vec3.x);
            boolean flag = !Mth.equal(pPos.z, vec3.z);
            this.horizontalCollision = flag1 || flag;
            this.verticalCollision = pPos.y != vec3.y;
            this.verticalCollisionBelow = this.verticalCollision && pPos.y < 0.0;
            this.minorHorizontalCollision = this.horizontalCollision ? this.isHorizontalCollisionMinor(vec3) : false;
            this.onGround = this.verticalCollision && pPos.y < 0.0;
            BlockPos blockpos = this.getOnPos();
            BlockState blockstate = this.level.getBlockState(blockpos);
            this.checkFallDamage(vec3.y, this.onGround, blockstate, blockpos);
            if (this.isRemoved()) {
                this.level.getProfiler().pop();
            } else {
                MovementEmission entity$movementemission;
                if (this.horizontalCollision) {
                    Vec3 vec31 = this.getDeltaMovement();
                    this.setDeltaMovement(flag1 ? 0.0 : vec31.x, vec31.y, flag ? 0.0 : vec31.z);
                }
                Block block = blockstate.getBlock();
                if (pPos.y != vec3.y) {
                    block.updateEntityAfterFallOn(this.level, this);
                }
                if (this.onGround && !this.isSteppingCarefully()) {
                    block.stepOn(this.level, blockpos, blockstate, this);
                }
                if ((entity$movementemission = this.getMovementEmission()).emitsAnything() && !this.isPassenger()) {
                    double d1 = vec3.x;
                    double d2 = vec3.y;
                    double d3 = vec3.z;
                    this.flyDist += (float)(vec3.length() * 0.6);
                    if (!blockstate.is(BlockTags.CLIMBABLE) && !blockstate.is(Blocks.POWDER_SNOW)) {
                        d2 = 0.0;
                    }
                    this.walkDist += (float)vec3.horizontalDistance() * 0.6f;
                    this.moveDist += (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3) * 0.6f;
                    if (this.moveDist > this.nextStep && !blockstate.isAir()) {
                        this.nextStep = this.nextStep();
                        if (this.isInWater()) {
                            if (entity$movementemission.emitsSounds()) {
                                Entity entity = this.isVehicle() && this.getControllingPassenger() != null ? this.getControllingPassenger() : this;
                                float f = entity == this ? 0.35f : 0.4f;
                                Vec3 vec32 = entity.getDeltaMovement();
                                float f1 = Math.min(1.0f, (float)Math.sqrt(vec32.x * vec32.x * (double)0.2f + vec32.y * vec32.y + vec32.z * vec32.z * (double)0.2f) * f);
                                this.playSwimSound(f1);
                            }
                            if (entity$movementemission.emitsEvents()) {
                                this.gameEvent(GameEvent.SWIM);
                            }
                        } else {
                            if (entity$movementemission.emitsSounds()) {
                                this.playAmethystStepSound(blockstate);
                                this.playStepSound(blockpos, blockstate);
                            }
                            if (entity$movementemission.emitsEvents() && !blockstate.is(BlockTags.OCCLUDES_VIBRATION_SIGNALS)) {
                                this.gameEvent(GameEvent.STEP);
                            }
                        }
                    } else if (blockstate.isAir()) {
                        this.processFlappingMovement();
                    }
                }
                this.tryCheckInsideBlocks();
                float f2 = this.getBlockSpeedFactor();
                this.setDeltaMovement(this.getDeltaMovement().multiply(f2, 1.0, f2));
                if (this.level.getBlockStatesIfLoaded(this.getBoundingBox().deflate(1.0E-6)).noneMatch(p_20127_ -> p_20127_.is(BlockTags.FIRE) || p_20127_.is(Blocks.LAVA))) {
                    if (this.remainingFireTicks <= 0) {
                        this.setRemainingFireTicks(-this.getFireImmuneTicks());
                    }
                    if (this.wasOnFire && (this.isInPowderSnow || this.isInWaterRainOrBubble())) {
                        this.playEntityOnFireExtinguishedSound();
                    }
                }
                if (this.isOnFire() && (this.isInPowderSnow || this.isInWaterRainOrBubble())) {
                    this.setRemainingFireTicks(-this.getFireImmuneTicks());
                }
                this.level.getProfiler().pop();
            }
        }
    }

    protected boolean isHorizontalCollisionMinor(Vec3 p_196625_) {
        return false;
    }

    protected void tryCheckInsideBlocks() {
        try {
            this.checkInsideBlocks();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Checking entity block collision");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Entity being checked for collision");
            this.fillCrashReportCategory(crashreportcategory);
            throw new ReportedException(crashreport);
        }
    }

    protected void playEntityOnFireExtinguishedSound() {
        this.playSound(SoundEvents.GENERIC_EXTINGUISH_FIRE, 0.7f, 1.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
    }

    protected void processFlappingMovement() {
        if (this.isFlapping()) {
            this.onFlap();
            if (this.getMovementEmission().emitsEvents()) {
                this.gameEvent(GameEvent.FLAP);
            }
        }
    }

    public BlockPos getOnPos() {
        BlockPos blockpos1;
        BlockState blockstate;
        int k;
        int j;
        int i = Mth.floor(this.position.x);
        BlockPos blockpos = new BlockPos(i, j = Mth.floor(this.position.y - (double)0.2f), k = Mth.floor(this.position.z));
        if (this.level.getBlockState(blockpos).isAir() && ((blockstate = this.level.getBlockState(blockpos1 = blockpos.below())).is(BlockTags.FENCES) || blockstate.is(BlockTags.WALLS) || blockstate.getBlock() instanceof FenceGateBlock)) {
            return blockpos1;
        }
        return blockpos;
    }

    protected float getBlockJumpFactor() {
        float f = this.level.getBlockState(this.blockPosition()).getBlock().getJumpFactor();
        float f1 = this.level.getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getJumpFactor();
        return (double)f == 1.0 ? f1 : f;
    }

    protected float getBlockSpeedFactor() {
        BlockState blockstate = this.level.getBlockState(this.blockPosition());
        float f = blockstate.getBlock().getSpeedFactor();
        if (!blockstate.is(Blocks.WATER) && !blockstate.is(Blocks.BUBBLE_COLUMN)) {
            return (double)f == 1.0 ? this.level.getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getSpeedFactor() : f;
        }
        return f;
    }

    protected BlockPos getBlockPosBelowThatAffectsMyMovement() {
        return new BlockPos(this.position.x, this.getBoundingBox().minY - 0.5000001, this.position.z);
    }

    protected Vec3 maybeBackOffFromEdge(Vec3 pVec, MoverType pMover) {
        return pVec;
    }

    protected Vec3 limitPistonMovement(Vec3 pPos) {
        if (pPos.lengthSqr() <= 1.0E-7) {
            return pPos;
        }
        long i = this.level.getGameTime();
        if (i != this.pistonDeltasGameTime) {
            Arrays.fill(this.pistonDeltas, 0.0);
            this.pistonDeltasGameTime = i;
        }
        if (pPos.x != 0.0) {
            double d2 = this.applyPistonMovementRestriction(Direction.Axis.X, pPos.x);
            return Math.abs(d2) <= (double)1.0E-5f ? Vec3.ZERO : new Vec3(d2, 0.0, 0.0);
        }
        if (pPos.y != 0.0) {
            double d1 = this.applyPistonMovementRestriction(Direction.Axis.Y, pPos.y);
            return Math.abs(d1) <= (double)1.0E-5f ? Vec3.ZERO : new Vec3(0.0, d1, 0.0);
        }
        if (pPos.z != 0.0) {
            double d0 = this.applyPistonMovementRestriction(Direction.Axis.Z, pPos.z);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3.ZERO : new Vec3(0.0, 0.0, d0);
        }
        return Vec3.ZERO;
    }

    private double applyPistonMovementRestriction(Direction.Axis pAxis, double pDistance) {
        int i = pAxis.ordinal();
        double d0 = Mth.clamp(pDistance + this.pistonDeltas[i], -0.51, 0.51);
        pDistance = d0 - this.pistonDeltas[i];
        this.pistonDeltas[i] = d0;
        return pDistance;
    }

    private Vec3 collide(Vec3 pVec) {
        boolean flag3;
        AABB aabb = this.getBoundingBox();
        List<VoxelShape> list = this.level.getEntityCollisions(this, aabb.expandTowards(pVec));
        Vec3 vec3 = pVec.lengthSqr() == 0.0 ? pVec : Entity.collideBoundingBox(this, pVec, aabb, this.level, list);
        boolean flag = pVec.x != vec3.x;
        boolean flag1 = pVec.y != vec3.y;
        boolean flag2 = pVec.z != vec3.z;
        boolean bl = flag3 = this.onGround || flag1 && pVec.y < 0.0;
        if (this.maxUpStep > 0.0f && flag3 && (flag || flag2)) {
            Vec3 vec33;
            Vec3 vec31 = Entity.collideBoundingBox(this, new Vec3(pVec.x, this.maxUpStep, pVec.z), aabb, this.level, list);
            Vec3 vec32 = Entity.collideBoundingBox(this, new Vec3(0.0, this.maxUpStep, 0.0), aabb.expandTowards(pVec.x, 0.0, pVec.z), this.level, list);
            if (vec32.y < (double)this.maxUpStep && (vec33 = Entity.collideBoundingBox(this, new Vec3(pVec.x, 0.0, pVec.z), aabb.move(vec32), this.level, list).add(vec32)).horizontalDistanceSqr() > vec31.horizontalDistanceSqr()) {
                vec31 = vec33;
            }
            if (vec31.horizontalDistanceSqr() > vec3.horizontalDistanceSqr()) {
                return vec31.add(Entity.collideBoundingBox(this, new Vec3(0.0, -vec31.y + pVec.y, 0.0), aabb.move(vec31), this.level, list));
            }
        }
        return vec3;
    }

    public static Vec3 collideBoundingBox(@Nullable Entity p_198895_, Vec3 p_198896_, AABB p_198897_, Level p_198898_, List<VoxelShape> p_198899_) {
        boolean flag;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(p_198899_.size() + 1));
        if (!p_198899_.isEmpty()) {
            builder.addAll(p_198899_);
        }
        WorldBorder worldborder = p_198898_.getWorldBorder();
        boolean bl = flag = p_198895_ != null && worldborder.isInsideCloseToBorder(p_198895_, p_198897_.expandTowards(p_198896_));
        if (flag) {
            builder.add((Object)worldborder.getCollisionShape());
        }
        builder.addAll(p_198898_.getBlockCollisions(p_198895_, p_198897_.expandTowards(p_198896_)));
        return Entity.collideWithShapes(p_198896_, p_198897_, (List<VoxelShape>)builder.build());
    }

    private static Vec3 collideWithShapes(Vec3 p_198901_, AABB p_198902_, List<VoxelShape> p_198903_) {
        boolean flag;
        if (p_198903_.isEmpty()) {
            return p_198901_;
        }
        double d0 = p_198901_.x;
        double d1 = p_198901_.y;
        double d2 = p_198901_.z;
        if (d1 != 0.0 && (d1 = Shapes.collide(Direction.Axis.Y, p_198902_, p_198903_, d1)) != 0.0) {
            p_198902_ = p_198902_.move(0.0, d1, 0.0);
        }
        boolean bl = flag = Math.abs(d0) < Math.abs(d2);
        if (flag && d2 != 0.0 && (d2 = Shapes.collide(Direction.Axis.Z, p_198902_, p_198903_, d2)) != 0.0) {
            p_198902_ = p_198902_.move(0.0, 0.0, d2);
        }
        if (d0 != 0.0) {
            d0 = Shapes.collide(Direction.Axis.X, p_198902_, p_198903_, d0);
            if (!flag && d0 != 0.0) {
                p_198902_ = p_198902_.move(d0, 0.0, 0.0);
            }
        }
        if (!flag && d2 != 0.0) {
            d2 = Shapes.collide(Direction.Axis.Z, p_198902_, p_198903_, d2);
        }
        return new Vec3(d0, d1, d2);
    }

    protected float nextStep() {
        return (int)this.moveDist + 1;
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.GENERIC_SWIM;
    }

    protected SoundEvent getSwimSplashSound() {
        return SoundEvents.GENERIC_SPLASH;
    }

    protected SoundEvent getSwimHighSpeedSplashSound() {
        return SoundEvents.GENERIC_SPLASH;
    }

    protected void checkInsideBlocks() {
        AABB aabb = this.getBoundingBox();
        BlockPos blockpos = new BlockPos(aabb.minX + 0.001, aabb.minY + 0.001, aabb.minZ + 0.001);
        BlockPos blockpos1 = new BlockPos(aabb.maxX - 0.001, aabb.maxY - 0.001, aabb.maxZ - 0.001);
        if (this.level.hasChunksAt(blockpos, blockpos1)) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            int i = blockpos.getX();
            while (i <= blockpos1.getX()) {
                int j = blockpos.getY();
                while (j <= blockpos1.getY()) {
                    int k = blockpos.getZ();
                    while (k <= blockpos1.getZ()) {
                        blockpos$mutableblockpos.set(i, j, k);
                        BlockState blockstate = this.level.getBlockState(blockpos$mutableblockpos);
                        try {
                            blockstate.entityInside(this.level, blockpos$mutableblockpos, this);
                            this.onInsideBlock(blockstate);
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.forThrowable(throwable, "Colliding entity with block");
                            CrashReportCategory crashreportcategory = crashreport.addCategory("Block being collided with");
                            CrashReportCategory.populateBlockDetails(crashreportcategory, this.level, blockpos$mutableblockpos, blockstate);
                            throw new ReportedException(crashreport);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    protected void onInsideBlock(BlockState pState) {
    }

    public void gameEvent(GameEvent pEvent, @Nullable Entity pEntity, BlockPos pPos) {
        this.level.gameEvent(pEntity, pEvent, pPos);
    }

    public void gameEvent(GameEvent pEvent, @Nullable Entity pPos) {
        this.gameEvent(pEvent, pPos, this.blockPosition);
    }

    public void gameEvent(GameEvent pEvent, BlockPos pPos) {
        this.gameEvent(pEvent, this, pPos);
    }

    public void gameEvent(GameEvent pEvent) {
        this.gameEvent(pEvent, this.blockPosition);
    }

    protected void playStepSound(BlockPos pPos, BlockState pBlock) {
        if (!pBlock.getMaterial().isLiquid()) {
            BlockState blockstate = this.level.getBlockState(pPos.above());
            SoundType soundtype = blockstate.is(BlockTags.INSIDE_STEP_SOUND_BLOCKS) ? blockstate.getSoundType() : pBlock.getSoundType();
            this.playSound(soundtype.getStepSound(), soundtype.getVolume() * 0.15f, soundtype.getPitch());
        }
    }

    private void playAmethystStepSound(BlockState pState) {
        if (pState.is(BlockTags.CRYSTAL_SOUND_BLOCKS) && this.tickCount >= this.lastCrystalSoundPlayTick + 20) {
            this.crystalSoundIntensity *= (float)Math.pow(0.997, this.tickCount - this.lastCrystalSoundPlayTick);
            this.crystalSoundIntensity = Math.min(1.0f, this.crystalSoundIntensity + 0.07f);
            float f = 0.5f + this.crystalSoundIntensity * this.random.nextFloat() * 1.2f;
            float f1 = 0.1f + this.crystalSoundIntensity * 1.2f;
            this.playSound(SoundEvents.AMETHYST_BLOCK_CHIME, f1, f);
            this.lastCrystalSoundPlayTick = this.tickCount;
        }
    }

    protected void playSwimSound(float pVolume) {
        this.playSound(this.getSwimSound(), pVolume, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
    }

    protected void onFlap() {
    }

    protected boolean isFlapping() {
        return false;
    }

    public void playSound(SoundEvent pSound, float pVolume, float pPitch) {
        if (!this.isSilent()) {
            this.level.playSound(null, this.getX(), this.getY(), this.getZ(), pSound, this.getSoundSource(), pVolume, pPitch);
        }
    }

    public boolean isSilent() {
        return this.entityData.get(DATA_SILENT);
    }

    public void setSilent(boolean pIsSilent) {
        this.entityData.set(DATA_SILENT, pIsSilent);
    }

    public boolean isNoGravity() {
        return this.entityData.get(DATA_NO_GRAVITY);
    }

    public void setNoGravity(boolean pNoGravity) {
        this.entityData.set(DATA_NO_GRAVITY, pNoGravity);
    }

    protected MovementEmission getMovementEmission() {
        return MovementEmission.ALL;
    }

    public boolean occludesVibrations() {
        return false;
    }

    protected void checkFallDamage(double pY, boolean p_19912_, BlockState pOnGround, BlockPos pState) {
        if (p_19912_) {
            if (this.fallDistance > 0.0f) {
                pOnGround.getBlock().fallOn(this.level, pOnGround, pState, this, this.fallDistance);
                if (!pOnGround.is(BlockTags.OCCLUDES_VIBRATION_SIGNALS)) {
                    this.gameEvent(GameEvent.HIT_GROUND);
                }
            }
            this.resetFallDistance();
        } else if (pY < 0.0) {
            this.fallDistance -= (float)pY;
        }
    }

    public boolean fireImmune() {
        return this.getType().fireImmune();
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource) {
        if (this.isVehicle()) {
            for (Entity entity : this.getPassengers()) {
                entity.causeFallDamage(pFallDistance, pMultiplier, pSource);
            }
        }
        return false;
    }

    public boolean isInWater() {
        return this.wasTouchingWater;
    }

    private boolean isInRain() {
        BlockPos blockpos = this.blockPosition();
        return this.level.isRainingAt(blockpos) || this.level.isRainingAt(new BlockPos((double)blockpos.getX(), this.getBoundingBox().maxY, (double)blockpos.getZ()));
    }

    private boolean isInBubbleColumn() {
        return this.level.getBlockState(this.blockPosition()).is(Blocks.BUBBLE_COLUMN);
    }

    public boolean isInWaterOrRain() {
        return this.isInWater() || this.isInRain();
    }

    public boolean isInWaterRainOrBubble() {
        return this.isInWater() || this.isInRain() || this.isInBubbleColumn();
    }

    public boolean isInWaterOrBubble() {
        return this.isInWater() || this.isInBubbleColumn();
    }

    public boolean isUnderWater() {
        return this.wasEyeInWater && this.isInWater();
    }

    public void updateSwimming() {
        if (this.isSwimming()) {
            this.setSwimming(this.isSprinting() && this.isInWater() && !this.isPassenger());
        } else {
            this.setSwimming(this.isSprinting() && this.isUnderWater() && !this.isPassenger() && this.level.getFluidState(this.blockPosition).is(FluidTags.WATER));
        }
    }

    protected boolean updateInWaterStateAndDoFluidPushing() {
        this.fluidHeight.clear();
        this.updateInWaterStateAndDoWaterCurrentPushing();
        double d0 = this.level.dimensionType().ultraWarm() ? 0.007 : 0.0023333333333333335;
        boolean flag = this.updateFluidHeightAndDoFluidPushing(FluidTags.LAVA, d0);
        return this.isInWater() || flag;
    }

    void updateInWaterStateAndDoWaterCurrentPushing() {
        if (this.getVehicle() instanceof Boat) {
            this.wasTouchingWater = false;
        } else if (this.updateFluidHeightAndDoFluidPushing(FluidTags.WATER, 0.014)) {
            if (!this.wasTouchingWater && !this.firstTick) {
                this.doWaterSplashEffect();
            }
            this.resetFallDistance();
            this.wasTouchingWater = true;
            this.clearFire();
        } else {
            this.wasTouchingWater = false;
        }
    }

    private void updateFluidOnEyes() {
        Boat boat;
        this.wasEyeInWater = this.isEyeInFluid(FluidTags.WATER);
        this.fluidOnEyes.clear();
        double d0 = this.getEyeY() - 0.1111111119389534;
        Entity entity = this.getVehicle();
        if (entity instanceof Boat && !(boat = (Boat)entity).isUnderWater() && boat.getBoundingBox().maxY >= d0 && boat.getBoundingBox().minY <= d0) {
            return;
        }
        BlockPos blockpos = new BlockPos(this.getX(), d0, this.getZ());
        FluidState fluidstate = this.level.getFluidState(blockpos);
        double d1 = (float)blockpos.getY() + fluidstate.getHeight(this.level, blockpos);
        if (d1 > d0) {
            fluidstate.getTags().forEach(this.fluidOnEyes::add);
        }
    }

    protected void doWaterSplashEffect() {
        Entity entity = this.isVehicle() && this.getControllingPassenger() != null ? this.getControllingPassenger() : this;
        float f = entity == this ? 0.2f : 0.9f;
        Vec3 vec3 = entity.getDeltaMovement();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3.x * vec3.x * (double)0.2f + vec3.y * vec3.y + vec3.z * vec3.z * (double)0.2f) * f);
        if (f1 < 0.25f) {
            this.playSound(this.getSwimSplashSound(), f1, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        } else {
            this.playSound(this.getSwimHighSpeedSplashSound(), f1, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        }
        float f2 = Mth.floor(this.getY());
        int i = 0;
        while ((float)i < 1.0f + this.dimensions.width * 20.0f) {
            double d0 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width;
            double d1 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width;
            this.level.addParticle(ParticleTypes.BUBBLE, this.getX() + d0, f2 + 1.0f, this.getZ() + d1, vec3.x, vec3.y - this.random.nextDouble() * (double)0.2f, vec3.z);
            ++i;
        }
        int j = 0;
        while ((float)j < 1.0f + this.dimensions.width * 20.0f) {
            double d2 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width;
            double d3 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width;
            this.level.addParticle(ParticleTypes.SPLASH, this.getX() + d2, f2 + 1.0f, this.getZ() + d3, vec3.x, vec3.y, vec3.z);
            ++j;
        }
        this.gameEvent(GameEvent.SPLASH);
    }

    protected BlockState getBlockStateOn() {
        return this.level.getBlockState(this.getOnPos());
    }

    public boolean canSpawnSprintParticle() {
        return this.isSprinting() && !this.isInWater() && !this.isSpectator() && !this.isCrouching() && !this.isInLava() && this.isAlive();
    }

    protected void spawnSprintParticle() {
        int k;
        int j;
        int i = Mth.floor(this.getX());
        BlockPos blockpos = new BlockPos(i, j = Mth.floor(this.getY() - (double)0.2f), k = Mth.floor(this.getZ()));
        BlockState blockstate = this.level.getBlockState(blockpos);
        if (blockstate.getRenderShape() != RenderShape.INVISIBLE) {
            Vec3 vec3 = this.getDeltaMovement();
            this.level.addParticle(new BlockParticleOption(ParticleTypes.BLOCK, blockstate), this.getX() + (this.random.nextDouble() - 0.5) * (double)this.dimensions.width, this.getY() + 0.1, this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.dimensions.width, vec3.x * -4.0, 1.5, vec3.z * -4.0);
        }
    }

    public boolean isEyeInFluid(TagKey<Fluid> pFluidTag) {
        return this.fluidOnEyes.contains(pFluidTag);
    }

    public boolean isInLava() {
        return !this.firstTick && this.fluidHeight.getDouble(FluidTags.LAVA) > 0.0;
    }

    public void moveRelative(float pAmount, Vec3 pRelative) {
        Vec3 vec3 = Entity.getInputVector(pRelative, pAmount, this.getYRot());
        this.setDeltaMovement(this.getDeltaMovement().add(vec3));
    }

    private static Vec3 getInputVector(Vec3 pRelative, float pMotionScaler, float pFacing) {
        double d0 = pRelative.lengthSqr();
        if (d0 < 1.0E-7) {
            return Vec3.ZERO;
        }
        Vec3 vec3 = (d0 > 1.0 ? pRelative.normalize() : pRelative).scale(pMotionScaler);
        float f = Mth.sin(pFacing * ((float)Math.PI / 180));
        float f1 = Mth.cos(pFacing * ((float)Math.PI / 180));
        return new Vec3(vec3.x * (double)f1 - vec3.z * (double)f, vec3.y, vec3.z * (double)f1 + vec3.x * (double)f);
    }

    public float getBrightness() {
        return this.level.hasChunkAt(this.getBlockX(), this.getBlockZ()) ? this.level.getBrightness(new BlockPos(this.getX(), this.getEyeY(), this.getZ())) : 0.0f;
    }

    public void absMoveTo(double pX, double p_19892_, double pY, float p_19894_, float pZ) {
        this.absMoveTo(pX, p_19892_, pY);
        this.setYRot(p_19894_ % 360.0f);
        this.setXRot(Mth.clamp(pZ, -90.0f, 90.0f) % 360.0f);
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void absMoveTo(double pX, double p_20250_, double pY) {
        double d0 = Mth.clamp(pX, -3.0E7, 3.0E7);
        double d1 = Mth.clamp(pY, -3.0E7, 3.0E7);
        this.xo = d0;
        this.yo = p_20250_;
        this.zo = d1;
        this.setPos(d0, p_20250_, d1);
    }

    public void moveTo(Vec3 pVec) {
        this.moveTo(pVec.x, pVec.y, pVec.z);
    }

    public void moveTo(double pPos, double pRotationYaw, double pRotationPitch) {
        this.moveTo(pPos, pRotationYaw, pRotationPitch, this.getYRot(), this.getXRot());
    }

    public void moveTo(BlockPos pPos, float pRotationYaw, float pRotationPitch) {
        this.moveTo((double)pPos.getX() + 0.5, pPos.getY(), (double)pPos.getZ() + 0.5, pRotationYaw, pRotationPitch);
    }

    public void moveTo(double pX, double p_20109_, double pY, float p_20111_, float pZ) {
        this.setPosRaw(pX, p_20109_, pY);
        this.setYRot(p_20111_);
        this.setXRot(pZ);
        this.setOldPosAndRot();
        this.reapplyPosition();
    }

    public final void setOldPosAndRot() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        this.xo = d0;
        this.yo = d1;
        this.zo = d2;
        this.xOld = d0;
        this.yOld = d1;
        this.zOld = d2;
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public float distanceTo(Entity pEntity) {
        float f = (float)(this.getX() - pEntity.getX());
        float f1 = (float)(this.getY() - pEntity.getY());
        float f2 = (float)(this.getZ() - pEntity.getZ());
        return Mth.sqrt(f * f + f1 * f1 + f2 * f2);
    }

    public double distanceToSqr(double pX, double p_20277_, double pY) {
        double d0 = this.getX() - pX;
        double d1 = this.getY() - p_20277_;
        double d2 = this.getZ() - pY;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public double distanceToSqr(Entity pEntity) {
        return this.distanceToSqr(pEntity.position());
    }

    public double distanceToSqr(Vec3 pEntity) {
        double d0 = this.getX() - pEntity.x;
        double d1 = this.getY() - pEntity.y;
        double d2 = this.getZ() - pEntity.z;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void playerTouch(Player pPlayer) {
    }

    public void push(Entity pEntity) {
        double d1;
        double d0;
        double d2;
        if (!this.isPassengerOfSameVehicle(pEntity) && !pEntity.noPhysics && !this.noPhysics && (d2 = Mth.absMax(d0 = pEntity.getX() - this.getX(), d1 = pEntity.getZ() - this.getZ())) >= (double)0.01f) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!this.isVehicle()) {
                this.push(-d0, 0.0, -d1);
            }
            if (!pEntity.isVehicle()) {
                pEntity.push(d0, 0.0, d1);
            }
        }
    }

    public void push(double pX, double p_20287_, double pY) {
        this.setDeltaMovement(this.getDeltaMovement().add(pX, p_20287_, pY));
        this.hasImpulse = true;
    }

    protected void markHurt() {
        this.hurtMarked = true;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.isInvulnerableTo(pSource)) {
            return false;
        }
        this.markHurt();
        return false;
    }

    public final Vec3 getViewVector(float pPartialTicks) {
        return this.calculateViewVector(this.getViewXRot(pPartialTicks), this.getViewYRot(pPartialTicks));
    }

    public float getViewXRot(float pPartialTicks) {
        return pPartialTicks == 1.0f ? this.getXRot() : Mth.lerp(pPartialTicks, this.xRotO, this.getXRot());
    }

    public float getViewYRot(float pPartialTicks) {
        return pPartialTicks == 1.0f ? this.getYRot() : Mth.lerp(pPartialTicks, this.yRotO, this.getYRot());
    }

    protected final Vec3 calculateViewVector(float pPitch, float pYaw) {
        float f = pPitch * ((float)Math.PI / 180);
        float f1 = -pYaw * ((float)Math.PI / 180);
        float f2 = Mth.cos(f1);
        float f3 = Mth.sin(f1);
        float f4 = Mth.cos(f);
        float f5 = Mth.sin(f);
        return new Vec3(f3 * f4, -f5, f2 * f4);
    }

    public final Vec3 getUpVector(float pPartialTicks) {
        return this.calculateUpVector(this.getViewXRot(pPartialTicks), this.getViewYRot(pPartialTicks));
    }

    protected final Vec3 calculateUpVector(float pPitch, float pYaw) {
        return this.calculateViewVector(pPitch - 90.0f, pYaw);
    }

    public final Vec3 getEyePosition() {
        return new Vec3(this.getX(), this.getEyeY(), this.getZ());
    }

    public final Vec3 getEyePosition(float pPartialTicks) {
        double d0 = Mth.lerp((double)pPartialTicks, this.xo, this.getX());
        double d1 = Mth.lerp((double)pPartialTicks, this.yo, this.getY()) + (double)this.getEyeHeight();
        double d2 = Mth.lerp((double)pPartialTicks, this.zo, this.getZ());
        return new Vec3(d0, d1, d2);
    }

    public Vec3 getLightProbePosition(float pPartialTicks) {
        return this.getEyePosition(pPartialTicks);
    }

    public final Vec3 getPosition(float pPartialTicks) {
        double d0 = Mth.lerp((double)pPartialTicks, this.xo, this.getX());
        double d1 = Mth.lerp((double)pPartialTicks, this.yo, this.getY());
        double d2 = Mth.lerp((double)pPartialTicks, this.zo, this.getZ());
        return new Vec3(d0, d1, d2);
    }

    public HitResult pick(double pRayTraceDistance, float p_19909_, boolean pPartialTicks) {
        Vec3 vec3 = this.getEyePosition(p_19909_);
        Vec3 vec31 = this.getViewVector(p_19909_);
        Vec3 vec32 = vec3.add(vec31.x * pRayTraceDistance, vec31.y * pRayTraceDistance, vec31.z * pRayTraceDistance);
        return this.level.clip(new ClipContext(vec3, vec32, ClipContext.Block.OUTLINE, pPartialTicks ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, this));
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public void awardKillScore(Entity pKilled, int pScoreValue, DamageSource pSource) {
        if (pKilled instanceof ServerPlayer) {
            CriteriaTriggers.ENTITY_KILLED_PLAYER.trigger((ServerPlayer)pKilled, this, pSource);
        }
    }

    public boolean shouldRender(double pX, double p_20297_, double pY) {
        double d0 = this.getX() - pX;
        double d1 = this.getY() - p_20297_;
        double d2 = this.getZ() - pY;
        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
        return this.shouldRenderAtSqrDistance(d3);
    }

    public boolean shouldRenderAtSqrDistance(double pDistance) {
        double d0 = this.getBoundingBox().getSize();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return pDistance < (d0 *= 64.0 * viewScale) * d0;
    }

    public boolean saveAsPassenger(CompoundTag pCompound) {
        if (this.removalReason != null && !this.removalReason.shouldSave()) {
            return false;
        }
        String s = this.getEncodeId();
        if (s == null) {
            return false;
        }
        pCompound.putString(ID_TAG, s);
        this.saveWithoutId(pCompound);
        return true;
    }

    public boolean save(CompoundTag pCompound) {
        return this.isPassenger() ? false : this.saveAsPassenger(pCompound);
    }

    public CompoundTag saveWithoutId(CompoundTag pCompound) {
        try {
            int i;
            if (this.vehicle != null) {
                pCompound.put("Pos", this.a(this.vehicle.getX(), this.getY(), this.vehicle.getZ()));
            } else {
                pCompound.put("Pos", this.a(this.getX(), this.getY(), this.getZ()));
            }
            Vec3 vec3 = this.getDeltaMovement();
            pCompound.put("Motion", this.a(vec3.x, vec3.y, vec3.z));
            pCompound.put("Rotation", this.a(this.getYRot(), this.getXRot()));
            pCompound.putFloat("FallDistance", this.fallDistance);
            pCompound.putShort("Fire", (short)this.remainingFireTicks);
            pCompound.putShort("Air", (short)this.getAirSupply());
            pCompound.putBoolean("OnGround", this.onGround);
            pCompound.putBoolean("Invulnerable", this.invulnerable);
            pCompound.putInt("PortalCooldown", this.portalCooldown);
            pCompound.putUUID(UUID_TAG, this.getUUID());
            Component component = this.getCustomName();
            if (component != null) {
                pCompound.putString("CustomName", Component.Serializer.toJson(component));
            }
            if (this.isCustomNameVisible()) {
                pCompound.putBoolean("CustomNameVisible", this.isCustomNameVisible());
            }
            if (this.isSilent()) {
                pCompound.putBoolean("Silent", this.isSilent());
            }
            if (this.isNoGravity()) {
                pCompound.putBoolean("NoGravity", this.isNoGravity());
            }
            if (this.hasGlowingTag) {
                pCompound.putBoolean("Glowing", true);
            }
            if ((i = this.getTicksFrozen()) > 0) {
                pCompound.putInt("TicksFrozen", this.getTicksFrozen());
            }
            if (this.hasVisualFire) {
                pCompound.putBoolean("HasVisualFire", this.hasVisualFire);
            }
            if (!this.tags.isEmpty()) {
                ListTag listtag = new ListTag();
                for (String s : this.tags) {
                    listtag.add(StringTag.valueOf(s));
                }
                pCompound.put("Tags", listtag);
            }
            this.addAdditionalSaveData(pCompound);
            if (this.isVehicle()) {
                ListTag listtag1 = new ListTag();
                for (Entity entity : this.getPassengers()) {
                    CompoundTag compoundtag;
                    if (!entity.saveAsPassenger(compoundtag = new CompoundTag())) continue;
                    listtag1.add(compoundtag);
                }
                if (!listtag1.isEmpty()) {
                    pCompound.put(PASSENGERS_TAG, listtag1);
                }
            }
            return pCompound;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Saving entity NBT");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Entity being saved");
            this.fillCrashReportCategory(crashreportcategory);
            throw new ReportedException(crashreport);
        }
    }

    public void load(CompoundTag pCompound) {
        block12: {
            try {
                ListTag listtag = pCompound.getList("Pos", 6);
                ListTag listtag1 = pCompound.getList("Motion", 6);
                ListTag listtag2 = pCompound.getList("Rotation", 5);
                double d0 = listtag1.getDouble(0);
                double d1 = listtag1.getDouble(1);
                double d2 = listtag1.getDouble(2);
                this.setDeltaMovement(Math.abs(d0) > 10.0 ? 0.0 : d0, Math.abs(d1) > 10.0 ? 0.0 : d1, Math.abs(d2) > 10.0 ? 0.0 : d2);
                this.setPosRaw(listtag.getDouble(0), Mth.clamp(listtag.getDouble(1), -2.0E7, 2.0E7), listtag.getDouble(2));
                this.setYRot(listtag2.getFloat(0));
                this.setXRot(listtag2.getFloat(1));
                this.setOldPosAndRot();
                this.setYHeadRot(this.getYRot());
                this.setYBodyRot(this.getYRot());
                this.fallDistance = pCompound.getFloat("FallDistance");
                this.remainingFireTicks = pCompound.getShort("Fire");
                if (pCompound.contains("Air")) {
                    this.setAirSupply(pCompound.getShort("Air"));
                }
                this.onGround = pCompound.getBoolean("OnGround");
                this.invulnerable = pCompound.getBoolean("Invulnerable");
                this.portalCooldown = pCompound.getInt("PortalCooldown");
                if (pCompound.hasUUID(UUID_TAG)) {
                    this.uuid = pCompound.getUUID(UUID_TAG);
                    this.stringUUID = this.uuid.toString();
                }
                if (Double.isFinite(this.getX()) && Double.isFinite(this.getY()) && Double.isFinite(this.getZ())) {
                    if (Double.isFinite(this.getYRot()) && Double.isFinite(this.getXRot())) {
                        this.reapplyPosition();
                        this.setRot(this.getYRot(), this.getXRot());
                        if (pCompound.contains("CustomName", 8)) {
                            String s = pCompound.getString("CustomName");
                            try {
                                this.setCustomName(Component.Serializer.fromJson(s));
                            }
                            catch (Exception exception) {
                                LOGGER.warn("Failed to parse entity custom name {}", (Object)s, (Object)exception);
                            }
                        }
                        this.setCustomNameVisible(pCompound.getBoolean("CustomNameVisible"));
                        this.setSilent(pCompound.getBoolean("Silent"));
                        this.setNoGravity(pCompound.getBoolean("NoGravity"));
                        this.setGlowingTag(pCompound.getBoolean("Glowing"));
                        this.setTicksFrozen(pCompound.getInt("TicksFrozen"));
                        this.hasVisualFire = pCompound.getBoolean("HasVisualFire");
                        if (pCompound.contains("Tags", 9)) {
                            this.tags.clear();
                            ListTag listtag3 = pCompound.getList("Tags", 8);
                            int i = Math.min(listtag3.size(), 1024);
                            int j = 0;
                            while (j < i) {
                                this.tags.add(listtag3.getString(j));
                                ++j;
                            }
                        }
                        this.readAdditionalSaveData(pCompound);
                        if (this.repositionEntityAfterLoad()) {
                            this.reapplyPosition();
                        }
                        break block12;
                    }
                    throw new IllegalStateException("Entity has invalid rotation");
                }
                throw new IllegalStateException("Entity has invalid position");
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable(throwable, "Loading entity NBT");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Entity being loaded");
                this.fillCrashReportCategory(crashreportcategory);
                throw new ReportedException(crashreport);
            }
        }
    }

    protected boolean repositionEntityAfterLoad() {
        return true;
    }

    @Nullable
    protected final String getEncodeId() {
        EntityType<?> entitytype = this.getType();
        ResourceLocation resourcelocation = EntityType.getKey(entitytype);
        return entitytype.canSerialize() && resourcelocation != null ? resourcelocation.toString() : null;
    }

    protected abstract void readAdditionalSaveData(CompoundTag var1);

    protected abstract void addAdditionalSaveData(CompoundTag var1);

    protected ListTag a(double ... p_20064_) {
        ListTag listtag = new ListTag();
        double[] dArray = p_20064_;
        int n = p_20064_.length;
        int n2 = 0;
        while (n2 < n) {
            double d0 = dArray[n2];
            listtag.add(DoubleTag.valueOf(d0));
            ++n2;
        }
        return listtag;
    }

    protected ListTag a(float ... p_20066_) {
        ListTag listtag = new ListTag();
        float[] fArray = p_20066_;
        int n = p_20066_.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            listtag.add(FloatTag.valueOf(f));
            ++n2;
        }
        return listtag;
    }

    @Nullable
    public ItemEntity spawnAtLocation(ItemLike pStack) {
        return this.spawnAtLocation(pStack, 0);
    }

    @Nullable
    public ItemEntity spawnAtLocation(ItemLike pStack, int pOffsetY) {
        return this.spawnAtLocation(new ItemStack(pStack), (float)pOffsetY);
    }

    @Nullable
    public ItemEntity spawnAtLocation(ItemStack pStack) {
        return this.spawnAtLocation(pStack, 0.0f);
    }

    @Nullable
    public ItemEntity spawnAtLocation(ItemStack pStack, float pOffsetY) {
        if (pStack.isEmpty()) {
            return null;
        }
        if (this.level.isClientSide) {
            return null;
        }
        ItemEntity itementity = new ItemEntity(this.level, this.getX(), this.getY() + (double)pOffsetY, this.getZ(), pStack);
        itementity.setDefaultPickUpDelay();
        this.level.addFreshEntity(itementity);
        return itementity;
    }

    public boolean isAlive() {
        return !this.isRemoved();
    }

    public boolean isInWall() {
        if (this.noPhysics) {
            return false;
        }
        float f = this.dimensions.width * 0.8f;
        AABB aabb = AABB.ofSize(this.getEyePosition(), f, 1.0E-6, f);
        return BlockPos.betweenClosedStream(aabb).anyMatch(p_201942_ -> {
            BlockState blockstate = this.level.getBlockState((BlockPos)p_201942_);
            return !blockstate.isAir() && blockstate.isSuffocating(this.level, (BlockPos)p_201942_) && Shapes.joinIsNotEmpty(blockstate.getCollisionShape(this.level, (BlockPos)p_201942_).move(p_201942_.getX(), p_201942_.getY(), p_201942_.getZ()), Shapes.create(aabb), BooleanOp.AND);
        });
    }

    public InteractionResult interact(Player pPlayer, InteractionHand pHand) {
        return InteractionResult.PASS;
    }

    public boolean canCollideWith(Entity pEntity) {
        return pEntity.canBeCollidedWith() && !this.isPassengerOfSameVehicle(pEntity);
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public void rideTick() {
        this.setDeltaMovement(Vec3.ZERO);
        this.tick();
        if (this.isPassenger()) {
            this.getVehicle().positionRider(this);
        }
    }

    public void positionRider(Entity pPassenger) {
        this.positionRider(pPassenger, Entity::setPos);
    }

    private void positionRider(Entity pEntity, MoveFunction pCallback) {
        if (this.hasPassenger(pEntity)) {
            double d0 = this.getY() + this.getPassengersRidingOffset() + pEntity.getMyRidingOffset();
            pCallback.accept(pEntity, this.getX(), d0, this.getZ());
        }
    }

    public void onPassengerTurned(Entity pEntityToUpdate) {
    }

    public double getMyRidingOffset() {
        return 0.0;
    }

    public double getPassengersRidingOffset() {
        return (double)this.dimensions.height * 0.75;
    }

    public boolean startRiding(Entity pEntity) {
        return this.startRiding(pEntity, false);
    }

    public boolean showVehicleHealth() {
        return this instanceof LivingEntity;
    }

    public boolean startRiding(Entity pEntity, boolean pForce) {
        if (pEntity == this.vehicle) {
            return false;
        }
        Entity entity = pEntity;
        while (entity.vehicle != null) {
            if (entity.vehicle == this) {
                return false;
            }
            entity = entity.vehicle;
        }
        if (pForce || this.canRide(pEntity) && pEntity.canAddPassenger(this)) {
            if (this.isPassenger()) {
                this.stopRiding();
            }
            this.setPose(Pose.STANDING);
            this.vehicle = pEntity;
            this.vehicle.addPassenger(this);
            pEntity.getIndirectPassengersStream().filter(p_185984_ -> p_185984_ instanceof ServerPlayer).forEach(p_185982_ -> CriteriaTriggers.START_RIDING_TRIGGER.trigger((ServerPlayer)p_185982_));
            return true;
        }
        return false;
    }

    protected boolean canRide(Entity pEntity) {
        return !this.isShiftKeyDown() && this.boardingCooldown <= 0;
    }

    protected boolean canEnterPose(Pose pPose) {
        return this.level.noCollision(this, this.getBoundingBoxForPose(pPose).deflate(1.0E-7));
    }

    public void ejectPassengers() {
        int i = this.passengers.size() - 1;
        while (i >= 0) {
            ((Entity)this.passengers.get(i)).stopRiding();
            --i;
        }
    }

    public void removeVehicle() {
        if (this.vehicle != null) {
            Entity entity = this.vehicle;
            this.vehicle = null;
            entity.removePassenger(this);
        }
    }

    public void stopRiding() {
        this.removeVehicle();
    }

    protected void addPassenger(Entity pPassenger) {
        if (pPassenger.getVehicle() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.passengers.isEmpty()) {
            this.passengers = ImmutableList.of((Object)pPassenger);
        } else {
            ArrayList list = Lists.newArrayList(this.passengers);
            if (!this.level.isClientSide && pPassenger instanceof Player && !(this.getControllingPassenger() instanceof Player)) {
                list.add(0, pPassenger);
            } else {
                list.add(pPassenger);
            }
            this.passengers = ImmutableList.copyOf((Collection)list);
        }
    }

    protected void removePassenger(Entity pPassenger) {
        if (pPassenger.getVehicle() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        this.passengers = this.passengers.size() == 1 && this.passengers.get(0) == pPassenger ? ImmutableList.of() : (ImmutableList)this.passengers.stream().filter(p_185980_ -> p_185980_ != pPassenger).collect(ImmutableList.toImmutableList());
        pPassenger.boardingCooldown = 60;
    }

    protected boolean canAddPassenger(Entity pPassenger) {
        return this.passengers.isEmpty();
    }

    public void lerpTo(double pX, double p_19897_, double pY, float p_19899_, float pZ, int p_19901_, boolean pYaw) {
        this.setPos(pX, p_19897_, pY);
        this.setRot(p_19899_, pZ);
    }

    public void lerpHeadTo(float pYaw, int pPitch) {
        this.setYHeadRot(pYaw);
    }

    public float getPickRadius() {
        return 0.0f;
    }

    public Vec3 getLookAngle() {
        return this.calculateViewVector(this.getXRot(), this.getYRot());
    }

    public Vec3 getHandHoldingItemAngle(Item p_204035_) {
        if (!(this instanceof Player)) {
            return Vec3.ZERO;
        }
        Player player = (Player)this;
        boolean flag = player.getOffhandItem().is(p_204035_) && !player.getMainHandItem().is(p_204035_);
        HumanoidArm humanoidarm = flag ? player.getMainArm().getOpposite() : player.getMainArm();
        return this.calculateViewVector(0.0f, this.getYRot() + (float)(humanoidarm == HumanoidArm.RIGHT ? 80 : -80)).scale(0.5);
    }

    public Vec2 getRotationVector() {
        return new Vec2(this.getXRot(), this.getYRot());
    }

    public Vec3 getForward() {
        return Vec3.directionFromRotation(this.getRotationVector());
    }

    public void handleInsidePortal(BlockPos pPos) {
        if (this.isOnPortalCooldown()) {
            this.setPortalCooldown();
        } else {
            if (!this.level.isClientSide && !pPos.equals(this.portalEntrancePos)) {
                this.portalEntrancePos = pPos.immutable();
            }
            this.isInsidePortal = true;
        }
    }

    protected void handleNetherPortal() {
        if (this.level instanceof ServerLevel) {
            int i = this.getPortalWaitTime();
            ServerLevel serverlevel = (ServerLevel)this.level;
            if (this.isInsidePortal) {
                ResourceKey<Level> resourcekey;
                MinecraftServer minecraftserver = serverlevel.getServer();
                ServerLevel serverlevel1 = minecraftserver.getLevel(resourcekey = this.level.dimension() == Level.NETHER ? Level.OVERWORLD : Level.NETHER);
                if (serverlevel1 != null && minecraftserver.isNetherEnabled() && !this.isPassenger() && this.portalTime++ >= i) {
                    this.level.getProfiler().push("portal");
                    this.portalTime = i;
                    this.setPortalCooldown();
                    this.changeDimension(serverlevel1);
                    this.level.getProfiler().pop();
                }
                this.isInsidePortal = false;
            } else {
                if (this.portalTime > 0) {
                    this.portalTime -= 4;
                }
                if (this.portalTime < 0) {
                    this.portalTime = 0;
                }
            }
            this.processPortalCooldown();
        }
    }

    public int getDimensionChangingDelay() {
        return 300;
    }

    public void lerpMotion(double pX, double p_20307_, double pY) {
        this.setDeltaMovement(pX, p_20307_, pY);
    }

    public void handleEntityEvent(byte pId) {
        switch (pId) {
            case 53: {
                HoneyBlock.showSlideParticles(this);
            }
        }
    }

    public void animateHurt() {
    }

    public Iterable<ItemStack> getHandSlots() {
        return EMPTY_LIST;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return EMPTY_LIST;
    }

    public Iterable<ItemStack> getAllSlots() {
        return Iterables.concat(this.getHandSlots(), this.getArmorSlots());
    }

    public void setItemSlot(EquipmentSlot pSlot, ItemStack pStack) {
    }

    public boolean isOnFire() {
        boolean flag;
        boolean bl = flag = this.level != null && this.level.isClientSide;
        return !this.fireImmune() && (this.remainingFireTicks > 0 || flag && this.getSharedFlag(0));
    }

    public boolean isPassenger() {
        return this.getVehicle() != null;
    }

    public boolean isVehicle() {
        return !this.passengers.isEmpty();
    }

    public boolean rideableUnderWater() {
        return true;
    }

    public void setShiftKeyDown(boolean pKeyDown) {
        this.setSharedFlag(1, pKeyDown);
    }

    public boolean isShiftKeyDown() {
        return this.getSharedFlag(1);
    }

    public boolean isSteppingCarefully() {
        return this.isShiftKeyDown();
    }

    public boolean isSuppressingBounce() {
        return this.isShiftKeyDown();
    }

    public boolean isDiscrete() {
        return this.isShiftKeyDown();
    }

    public boolean isDescending() {
        return this.isShiftKeyDown();
    }

    public boolean isCrouching() {
        return this.getPose() == Pose.CROUCHING;
    }

    public boolean isSprinting() {
        return this.getSharedFlag(3);
    }

    public void setSprinting(boolean pSprinting) {
        this.setSharedFlag(3, pSprinting);
    }

    public boolean isSwimming() {
        return this.getSharedFlag(4);
    }

    public boolean isVisuallySwimming() {
        return this.getPose() == Pose.SWIMMING;
    }

    public boolean isVisuallyCrawling() {
        return this.isVisuallySwimming() && !this.isInWater();
    }

    public void setSwimming(boolean pSwimming) {
        this.setSharedFlag(4, pSwimming);
    }

    public final boolean hasGlowingTag() {
        return this.hasGlowingTag;
    }

    public final void setGlowingTag(boolean pHasGlowingTag) {
        this.hasGlowingTag = pHasGlowingTag;
        this.setSharedFlag(6, this.isCurrentlyGlowing());
    }

    public boolean isCurrentlyGlowing() {
        return this.level.isClientSide() ? this.getSharedFlag(6) : this.hasGlowingTag;
    }

    public boolean isInvisible() {
        return this.getSharedFlag(5);
    }

    public boolean isInvisibleTo(Player pPlayer) {
        if (pPlayer.isSpectator()) {
            return false;
        }
        Team team = this.getTeam();
        return team != null && pPlayer != null && pPlayer.getTeam() == team && team.canSeeFriendlyInvisibles() ? false : this.isInvisible();
    }

    @Nullable
    public GameEventListenerRegistrar getGameEventListenerRegistrar() {
        return null;
    }

    @Nullable
    public Team getTeam() {
        return this.level.getScoreboard().getPlayersTeam(this.getScoreboardName());
    }

    public boolean isAlliedTo(Entity pEntity) {
        return this.isAlliedTo(pEntity.getTeam());
    }

    public boolean isAlliedTo(Team pEntity) {
        return this.getTeam() != null ? this.getTeam().isAlliedTo(pEntity) : false;
    }

    public void setInvisible(boolean pInvisible) {
        this.setSharedFlag(5, pInvisible);
    }

    protected boolean getSharedFlag(int pFlag) {
        return (this.entityData.get(DATA_SHARED_FLAGS_ID) & 1 << pFlag) != 0;
    }

    protected void setSharedFlag(int pFlag, boolean pSet) {
        byte b0 = this.entityData.get(DATA_SHARED_FLAGS_ID);
        if (pSet) {
            this.entityData.set(DATA_SHARED_FLAGS_ID, (byte)(b0 | 1 << pFlag));
        } else {
            this.entityData.set(DATA_SHARED_FLAGS_ID, (byte)(b0 & ~(1 << pFlag)));
        }
    }

    public int getMaxAirSupply() {
        return 300;
    }

    public int getAirSupply() {
        return this.entityData.get(DATA_AIR_SUPPLY_ID);
    }

    public void setAirSupply(int pAir) {
        this.entityData.set(DATA_AIR_SUPPLY_ID, pAir);
    }

    public int getTicksFrozen() {
        return this.entityData.get(DATA_TICKS_FROZEN);
    }

    public void setTicksFrozen(int pTicksFrozen) {
        this.entityData.set(DATA_TICKS_FROZEN, pTicksFrozen);
    }

    public float getPercentFrozen() {
        int i = this.getTicksRequiredToFreeze();
        return (float)Math.min(this.getTicksFrozen(), i) / (float)i;
    }

    public boolean isFullyFrozen() {
        return this.getTicksFrozen() >= this.getTicksRequiredToFreeze();
    }

    public int getTicksRequiredToFreeze() {
        return 140;
    }

    public void thunderHit(ServerLevel pLevel, LightningBolt pLightning) {
        this.setRemainingFireTicks(this.remainingFireTicks + 1);
        if (this.remainingFireTicks == 0) {
            this.setSecondsOnFire(8);
        }
        this.hurt(DamageSource.LIGHTNING_BOLT, 5.0f);
    }

    public void onAboveBubbleCol(boolean pDownwards) {
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = pDownwards ? Math.max(-0.9, vec3.y - 0.03) : Math.min(1.8, vec3.y + 0.1);
        this.setDeltaMovement(vec3.x, d0, vec3.z);
    }

    public void onInsideBubbleColumn(boolean pDownwards) {
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = pDownwards ? Math.max(-0.3, vec3.y - 0.03) : Math.min(0.7, vec3.y + 0.06);
        this.setDeltaMovement(vec3.x, d0, vec3.z);
        this.resetFallDistance();
    }

    public void killed(ServerLevel pLevel, LivingEntity pKilledEntity) {
    }

    public void resetFallDistance() {
        this.fallDistance = 0.0f;
    }

    protected void moveTowardsClosestSpace(double pX, double p_20316_, double pY) {
        BlockPos blockpos = new BlockPos(pX, p_20316_, pY);
        Vec3 vec3 = new Vec3(pX - (double)blockpos.getX(), p_20316_ - (double)blockpos.getY(), pY - (double)blockpos.getZ());
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        Direction direction = Direction.UP;
        double d0 = Double.MAX_VALUE;
        Direction[] directionArray = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP};
        int n = directionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction1 = directionArray[n2];
            blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, direction1);
            if (!this.level.getBlockState(blockpos$mutableblockpos).isCollisionShapeFullBlock(this.level, blockpos$mutableblockpos)) {
                double d2;
                double d1 = vec3.get(direction1.getAxis());
                double d = d2 = direction1.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1.0 - d1 : d1;
                if (d2 < d0) {
                    d0 = d2;
                    direction = direction1;
                }
            }
            ++n2;
        }
        float f = this.random.nextFloat() * 0.2f + 0.1f;
        float f1 = direction.getAxisDirection().getStep();
        Vec3 vec31 = this.getDeltaMovement().scale(0.75);
        if (direction.getAxis() == Direction.Axis.X) {
            this.setDeltaMovement(f1 * f, vec31.y, vec31.z);
        } else if (direction.getAxis() == Direction.Axis.Y) {
            this.setDeltaMovement(vec31.x, f1 * f, vec31.z);
        } else if (direction.getAxis() == Direction.Axis.Z) {
            this.setDeltaMovement(vec31.x, vec31.y, f1 * f);
        }
    }

    public void makeStuckInBlock(BlockState pState, Vec3 pMotionMultiplier) {
        this.resetFallDistance();
        this.stuckSpeedMultiplier = pMotionMultiplier;
    }

    private static Component removeAction(Component pName) {
        MutableComponent mutablecomponent = pName.plainCopy().setStyle(pName.getStyle().withClickEvent(null));
        for (Component component : pName.getSiblings()) {
            mutablecomponent.append(Entity.removeAction(component));
        }
        return mutablecomponent;
    }

    @Override
    public Component getName() {
        Component component = this.getCustomName();
        return component != null ? Entity.removeAction(component) : this.getTypeName();
    }

    protected Component getTypeName() {
        return this.type.getDescription();
    }

    public boolean is(Entity pEntity) {
        return this == pEntity;
    }

    public float getYHeadRot() {
        return 0.0f;
    }

    public void setYHeadRot(float pRotation) {
    }

    public void setYBodyRot(float pOffset) {
    }

    public boolean isAttackable() {
        return true;
    }

    public boolean skipAttackInteraction(Entity pEntity) {
        return false;
    }

    public String toString() {
        String s = this.level == null ? "~NULL~" : this.level.toString();
        return this.removalReason != null ? String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f, removed=%s]", new Object[]{this.getClass().getSimpleName(), this.getName().getString(), this.id, s, this.getX(), this.getY(), this.getZ(), this.removalReason}) : String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f]", this.getClass().getSimpleName(), this.getName().getString(), this.id, s, this.getX(), this.getY(), this.getZ());
    }

    public boolean isInvulnerableTo(DamageSource pSource) {
        return this.isRemoved() || this.invulnerable && pSource != DamageSource.OUT_OF_WORLD && !pSource.isCreativePlayer();
    }

    public boolean isInvulnerable() {
        return this.invulnerable;
    }

    public void setInvulnerable(boolean pIsInvulnerable) {
        this.invulnerable = pIsInvulnerable;
    }

    public void copyPosition(Entity pEntity) {
        this.moveTo(pEntity.getX(), pEntity.getY(), pEntity.getZ(), pEntity.getYRot(), pEntity.getXRot());
    }

    public void restoreFrom(Entity pEntity) {
        CompoundTag compoundtag = pEntity.saveWithoutId(new CompoundTag());
        compoundtag.remove("Dimension");
        this.load(compoundtag);
        this.portalCooldown = pEntity.portalCooldown;
        this.portalEntrancePos = pEntity.portalEntrancePos;
    }

    @Nullable
    public Entity changeDimension(ServerLevel pDestination) {
        if (this.level instanceof ServerLevel && !this.isRemoved()) {
            this.level.getProfiler().push("changeDimension");
            this.unRide();
            this.level.getProfiler().push("reposition");
            PortalInfo portalinfo = this.findDimensionEntryPoint(pDestination);
            if (portalinfo == null) {
                return null;
            }
            this.level.getProfiler().popPush("reloading");
            Object entity = this.getType().create(pDestination);
            if (entity != null) {
                ((Entity)entity).restoreFrom(this);
                ((Entity)entity).moveTo(portalinfo.pos.x, portalinfo.pos.y, portalinfo.pos.z, portalinfo.yRot, ((Entity)entity).getXRot());
                ((Entity)entity).setDeltaMovement(portalinfo.speed);
                pDestination.addDuringTeleport((Entity)entity);
                if (pDestination.dimension() == Level.END) {
                    ServerLevel.makeObsidianPlatform(pDestination);
                }
            }
            this.removeAfterChangingDimensions();
            this.level.getProfiler().pop();
            ((ServerLevel)this.level).resetEmptyTime();
            pDestination.resetEmptyTime();
            this.level.getProfiler().pop();
            return entity;
        }
        return null;
    }

    protected void removeAfterChangingDimensions() {
        this.setRemoved(RemovalReason.CHANGED_DIMENSION);
    }

    @Nullable
    protected PortalInfo findDimensionEntryPoint(ServerLevel pDestination) {
        boolean flag1;
        boolean flag = this.level.dimension() == Level.END && pDestination.dimension() == Level.OVERWORLD;
        boolean bl = flag1 = pDestination.dimension() == Level.END;
        if (!flag && !flag1) {
            boolean flag2;
            boolean bl2 = flag2 = pDestination.dimension() == Level.NETHER;
            if (this.level.dimension() != Level.NETHER && !flag2) {
                return null;
            }
            WorldBorder worldborder = pDestination.getWorldBorder();
            double d0 = DimensionType.getTeleportationScale(this.level.dimensionType(), pDestination.dimensionType());
            BlockPos blockpos1 = worldborder.clampToBounds(this.getX() * d0, this.getY(), this.getZ() * d0);
            return this.getExitPortal(pDestination, blockpos1, flag2, worldborder).map(p_185941_ -> {
                Vec3 vec3;
                Direction.Axis direction$axis;
                BlockState blockstate = this.level.getBlockState(this.portalEntrancePos);
                if (blockstate.hasProperty(BlockStateProperties.HORIZONTAL_AXIS)) {
                    direction$axis = blockstate.getValue(BlockStateProperties.HORIZONTAL_AXIS);
                    BlockUtil.FoundRectangle blockutil$foundrectangle = BlockUtil.getLargestRectangleAround(this.portalEntrancePos, direction$axis, 21, Direction.Axis.Y, 21, p_185959_ -> this.level.getBlockState((BlockPos)p_185959_) == blockstate);
                    vec3 = this.getRelativePortalPosition(direction$axis, blockutil$foundrectangle);
                } else {
                    direction$axis = Direction.Axis.X;
                    vec3 = new Vec3(0.5, 0.0, 0.0);
                }
                return PortalShape.createPortalInfo(pDestination, p_185941_, direction$axis, vec3, this.getDimensions(this.getPose()), this.getDeltaMovement(), this.getYRot(), this.getXRot());
            }).orElse(null);
        }
        BlockPos blockpos = flag1 ? ServerLevel.END_SPAWN_POINT : pDestination.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pDestination.getSharedSpawnPos());
        return new PortalInfo(new Vec3((double)blockpos.getX() + 0.5, blockpos.getY(), (double)blockpos.getZ() + 0.5), this.getDeltaMovement(), this.getYRot(), this.getXRot());
    }

    protected Vec3 getRelativePortalPosition(Direction.Axis pAxis, BlockUtil.FoundRectangle pPortal) {
        return PortalShape.getRelativePosition(pPortal, pAxis, this.position(), this.getDimensions(this.getPose()));
    }

    protected Optional<BlockUtil.FoundRectangle> getExitPortal(ServerLevel p_185935_, BlockPos p_185936_, boolean p_185937_, WorldBorder p_185938_) {
        return p_185935_.getPortalForcer().findPortalAround(p_185936_, p_185937_, p_185938_);
    }

    public boolean canChangeDimensions() {
        return true;
    }

    public float getBlockExplosionResistance(Explosion pExplosion, BlockGetter pLevel, BlockPos pPos, BlockState pBlockState, FluidState pFluidState, float pExplosionPower) {
        return pExplosionPower;
    }

    public boolean shouldBlockExplode(Explosion pExplosion, BlockGetter pLevel, BlockPos pPos, BlockState pBlockState, float pExplosionPower) {
        return true;
    }

    public int getMaxFallDistance() {
        return 3;
    }

    public boolean isIgnoringBlockTriggers() {
        return false;
    }

    public void fillCrashReportCategory(CrashReportCategory pCategory) {
        pCategory.setDetail("Entity Type", () -> EntityType.getKey(this.getType()) + " (" + this.getClass().getCanonicalName() + ")");
        pCategory.setDetail("Entity ID", this.id);
        pCategory.setDetail("Entity Name", () -> this.getName().getString());
        pCategory.setDetail("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.getX(), this.getY(), this.getZ()));
        pCategory.setDetail("Entity's Block location", CrashReportCategory.formatLocation((LevelHeightAccessor)this.level, Mth.floor(this.getX()), Mth.floor(this.getY()), Mth.floor(this.getZ())));
        Vec3 vec3 = this.getDeltaMovement();
        pCategory.setDetail("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", vec3.x, vec3.y, vec3.z));
        pCategory.setDetail("Entity's Passengers", () -> this.getPassengers().toString());
        pCategory.setDetail("Entity's Vehicle", () -> String.valueOf(this.getVehicle()));
    }

    public boolean displayFireAnimation() {
        return this.isOnFire() && !this.isSpectator();
    }

    public void setUUID(UUID pUniqueId) {
        this.uuid = pUniqueId;
        this.stringUUID = this.uuid.toString();
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    public String getStringUUID() {
        return this.stringUUID;
    }

    public String getScoreboardName() {
        return this.stringUUID;
    }

    public boolean isPushedByFluid() {
        return true;
    }

    public static double getViewScale() {
        return viewScale;
    }

    public static void setViewScale(double pRenderDistWeight) {
        viewScale = pRenderDistWeight;
    }

    @Override
    public Component getDisplayName() {
        return PlayerTeam.formatNameForTeam(this.getTeam(), this.getName()).withStyle(p_185975_ -> p_185975_.withHoverEvent(this.createHoverEvent()).withInsertion(this.getStringUUID()));
    }

    public void setCustomName(@Nullable Component pName) {
        this.entityData.set(DATA_CUSTOM_NAME, Optional.ofNullable(pName));
    }

    @Override
    @Nullable
    public Component getCustomName() {
        return this.entityData.get(DATA_CUSTOM_NAME).orElse(null);
    }

    @Override
    public boolean hasCustomName() {
        return this.entityData.get(DATA_CUSTOM_NAME).isPresent();
    }

    public void setCustomNameVisible(boolean pAlwaysRenderNameTag) {
        this.entityData.set(DATA_CUSTOM_NAME_VISIBLE, pAlwaysRenderNameTag);
    }

    public boolean isCustomNameVisible() {
        return this.entityData.get(DATA_CUSTOM_NAME_VISIBLE);
    }

    public final void teleportToWithTicket(double pX, double p_20326_, double pY) {
        if (this.level instanceof ServerLevel) {
            ChunkPos chunkpos = new ChunkPos(new BlockPos(pX, p_20326_, pY));
            ((ServerLevel)this.level).getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, chunkpos, 0, this.getId());
            this.level.getChunk(chunkpos.x, chunkpos.z);
            this.teleportTo(pX, p_20326_, pY);
        }
    }

    public void dismountTo(double pX, double p_146826_, double pY) {
        this.teleportTo(pX, p_146826_, pY);
    }

    public void teleportTo(double pX, double p_19888_, double pY) {
        if (this.level instanceof ServerLevel) {
            this.moveTo(pX, p_19888_, pY, this.getYRot(), this.getXRot());
            this.getSelfAndPassengers().forEach(p_185977_ -> {
                for (Entity entity : p_185977_.passengers) {
                    p_185977_.positionRider(entity, Entity::moveTo);
                }
            });
        }
    }

    public boolean shouldShowName() {
        return this.isCustomNameVisible();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        if (DATA_POSE.equals(pKey)) {
            this.refreshDimensions();
        }
    }

    public void refreshDimensions() {
        boolean flag;
        EntityDimensions entitydimensions1;
        EntityDimensions entitydimensions = this.dimensions;
        Pose pose = this.getPose();
        this.dimensions = entitydimensions1 = this.getDimensions(pose);
        this.eyeHeight = this.getEyeHeight(pose, entitydimensions1);
        this.reapplyPosition();
        boolean bl = flag = (double)entitydimensions1.width <= 4.0 && (double)entitydimensions1.height <= 4.0;
        if (!(this.level.isClientSide || this.firstTick || this.noPhysics || !flag || !(entitydimensions1.width > entitydimensions.width) && !(entitydimensions1.height > entitydimensions.height) || this instanceof Player)) {
            Vec3 vec3 = this.position().add(0.0, (double)entitydimensions.height / 2.0, 0.0);
            double d0 = (double)Math.max(0.0f, entitydimensions1.width - entitydimensions.width) + 1.0E-6;
            double d1 = (double)Math.max(0.0f, entitydimensions1.height - entitydimensions.height) + 1.0E-6;
            VoxelShape voxelshape = Shapes.create(AABB.ofSize(vec3, d0, d1, d0));
            this.level.findFreePosition(this, voxelshape, vec3, entitydimensions1.width, entitydimensions1.height, entitydimensions1.width).ifPresent(p_185956_ -> this.setPos(p_185956_.add(0.0, (double)(-entityDimensions.height) / 2.0, 0.0)));
        }
    }

    public Direction getDirection() {
        return Direction.fromYRot(this.getYRot());
    }

    public Direction getMotionDirection() {
        return this.getDirection();
    }

    protected HoverEvent createHoverEvent() {
        return new HoverEvent(HoverEvent.Action.SHOW_ENTITY, new HoverEvent.EntityTooltipInfo(this.getType(), this.getUUID(), this.getName()));
    }

    public boolean broadcastToPlayer(ServerPlayer pPlayer) {
        return true;
    }

    @Override
    public final AABB getBoundingBox() {
        return this.bb;
    }

    public AABB getBoundingBoxForCulling() {
        return this.getBoundingBox();
    }

    protected AABB getBoundingBoxForPose(Pose pPose) {
        EntityDimensions entitydimensions = this.getDimensions(pPose);
        float f = entitydimensions.width / 2.0f;
        Vec3 vec3 = new Vec3(this.getX() - (double)f, this.getY(), this.getZ() - (double)f);
        Vec3 vec31 = new Vec3(this.getX() + (double)f, this.getY() + (double)entitydimensions.height, this.getZ() + (double)f);
        return new AABB(vec3, vec31);
    }

    public final void setBoundingBox(AABB pBb) {
        this.bb = pBb;
    }

    protected float getEyeHeight(Pose pPose, EntityDimensions pSize) {
        return pSize.height * 0.85f;
    }

    public float getEyeHeight(Pose pPose) {
        return this.getEyeHeight(pPose, this.getDimensions(pPose));
    }

    public final float getEyeHeight() {
        return this.eyeHeight;
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    public SlotAccess getSlot(int pSlot) {
        return SlotAccess.NULL;
    }

    @Override
    public void sendMessage(Component pComponent, UUID pSenderUUID) {
    }

    public Level getCommandSenderWorld() {
        return this.level;
    }

    @Nullable
    public MinecraftServer getServer() {
        return this.level.getServer();
    }

    public InteractionResult interactAt(Player pPlayer, Vec3 pVec, InteractionHand pHand) {
        return InteractionResult.PASS;
    }

    public boolean ignoreExplosion() {
        return false;
    }

    public void doEnchantDamageEffects(LivingEntity pLivingEntity, Entity pEntity) {
        if (pEntity instanceof LivingEntity) {
            EnchantmentHelper.doPostHurtEffects((LivingEntity)pEntity, pLivingEntity);
        }
        EnchantmentHelper.doPostDamageEffects(pLivingEntity, pEntity);
    }

    public void startSeenByPlayer(ServerPlayer pPlayer) {
    }

    public void stopSeenByPlayer(ServerPlayer pPlayer) {
    }

    public float rotate(Rotation pTransformRotation) {
        float f = Mth.wrapDegrees(this.getYRot());
        switch (pTransformRotation) {
            case CLOCKWISE_180: {
                return f + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return f + 270.0f;
            }
            case CLOCKWISE_90: {
                return f + 90.0f;
            }
        }
        return f;
    }

    public float mirror(Mirror pTransformMirror) {
        float f = Mth.wrapDegrees(this.getYRot());
        switch (pTransformMirror) {
            case FRONT_BACK: {
                return -f;
            }
            case LEFT_RIGHT: {
                return 180.0f - f;
            }
        }
        return f;
    }

    public boolean onlyOpCanSetNbt() {
        return false;
    }

    @Nullable
    public Entity getControllingPassenger() {
        return null;
    }

    public final List<Entity> getPassengers() {
        return this.passengers;
    }

    @Nullable
    public Entity getFirstPassenger() {
        return this.passengers.isEmpty() ? null : (Entity)this.passengers.get(0);
    }

    public boolean hasPassenger(Entity pPredicate) {
        return this.passengers.contains((Object)pPredicate);
    }

    public boolean hasPassenger(Predicate<Entity> pPredicate) {
        for (Entity entity : this.passengers) {
            if (!pPredicate.test(entity)) continue;
            return true;
        }
        return false;
    }

    private Stream<Entity> getIndirectPassengersStream() {
        return this.passengers.stream().flatMap(Entity::getSelfAndPassengers);
    }

    public Stream<Entity> getSelfAndPassengers() {
        return Stream.concat(Stream.of(this), this.getIndirectPassengersStream());
    }

    public Stream<Entity> getPassengersAndSelf() {
        return Stream.concat(this.passengers.stream().flatMap(Entity::getPassengersAndSelf), Stream.of(this));
    }

    public Iterable<Entity> getIndirectPassengers() {
        return () -> this.getIndirectPassengersStream().iterator();
    }

    public boolean hasExactlyOnePlayerPassenger() {
        return this.getIndirectPassengersStream().filter(p_185943_ -> p_185943_ instanceof Player).count() == 1L;
    }

    public Entity getRootVehicle() {
        Entity entity = this;
        while (entity.isPassenger()) {
            entity = entity.getVehicle();
        }
        return entity;
    }

    public boolean isPassengerOfSameVehicle(Entity pEntity) {
        return this.getRootVehicle() == pEntity.getRootVehicle();
    }

    public boolean hasIndirectPassenger(Entity pEntity) {
        return this.getIndirectPassengersStream().anyMatch(p_185946_ -> p_185946_ == pEntity);
    }

    public boolean isControlledByLocalInstance() {
        Entity entity = this.getControllingPassenger();
        if (entity instanceof Player) {
            return ((Player)entity).isLocalPlayer();
        }
        return !this.level.isClientSide;
    }

    protected static Vec3 getCollisionHorizontalEscapeVector(double pMountWidth, double p_19905_, float pRiderWidth) {
        double d0 = (pMountWidth + p_19905_ + (double)1.0E-5f) / 2.0;
        float f = -Mth.sin(pRiderWidth * ((float)Math.PI / 180));
        float f1 = Mth.cos(pRiderWidth * ((float)Math.PI / 180));
        float f2 = Math.max(Math.abs(f), Math.abs(f1));
        return new Vec3((double)f * d0 / (double)f2, 0.0, (double)f1 * d0 / (double)f2);
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity pLivingEntity) {
        return new Vec3(this.getX(), this.getBoundingBox().maxY, this.getZ());
    }

    @Nullable
    public Entity getVehicle() {
        return this.vehicle;
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.NORMAL;
    }

    public SoundSource getSoundSource() {
        return SoundSource.NEUTRAL;
    }

    protected int getFireImmuneTicks() {
        return 1;
    }

    public CommandSourceStack createCommandSourceStack() {
        return new CommandSourceStack(this, this.position(), this.getRotationVector(), this.level instanceof ServerLevel ? (ServerLevel)this.level : null, this.getPermissionLevel(), this.getName().getString(), this.getDisplayName(), this.level.getServer(), this);
    }

    protected int getPermissionLevel() {
        return 0;
    }

    public boolean hasPermissions(int pLevel) {
        return this.getPermissionLevel() >= pLevel;
    }

    @Override
    public boolean acceptsSuccess() {
        return this.level.getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK);
    }

    @Override
    public boolean acceptsFailure() {
        return true;
    }

    @Override
    public boolean shouldInformAdmins() {
        return true;
    }

    public void lookAt(EntityAnchorArgument.Anchor pAnchor, Vec3 pTarget) {
        Vec3 vec3 = pAnchor.apply(this);
        double d0 = pTarget.x - vec3.x;
        double d1 = pTarget.y - vec3.y;
        double d2 = pTarget.z - vec3.z;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.setXRot(Mth.wrapDegrees((float)(-(Mth.atan2(d1, d3) * 57.2957763671875))));
        this.setYRot(Mth.wrapDegrees((float)(Mth.atan2(d2, d0) * 57.2957763671875) - 90.0f));
        this.setYHeadRot(this.getYRot());
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
    }

    public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> pFluidTag, double pMotionScale) {
        if (this.touchingUnloadedChunk()) {
            return false;
        }
        AABB aabb = this.getBoundingBox().deflate(0.001);
        int i = Mth.floor(aabb.minX);
        int j = Mth.ceil(aabb.maxX);
        int k = Mth.floor(aabb.minY);
        int l = Mth.ceil(aabb.maxY);
        int i1 = Mth.floor(aabb.minZ);
        int j1 = Mth.ceil(aabb.maxZ);
        double d0 = 0.0;
        boolean flag = this.isPushedByFluid();
        boolean flag1 = false;
        Vec3 vec3 = Vec3.ZERO;
        int k1 = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int l1 = i;
        while (l1 < j) {
            int i2 = k;
            while (i2 < l) {
                int j2 = i1;
                while (j2 < j1) {
                    double d1;
                    blockpos$mutableblockpos.set(l1, i2, j2);
                    FluidState fluidstate = this.level.getFluidState(blockpos$mutableblockpos);
                    if (fluidstate.is(pFluidTag) && (d1 = (double)((float)i2 + fluidstate.getHeight(this.level, blockpos$mutableblockpos))) >= aabb.minY) {
                        flag1 = true;
                        d0 = Math.max(d1 - aabb.minY, d0);
                        if (flag) {
                            Vec3 vec31 = fluidstate.getFlow(this.level, blockpos$mutableblockpos);
                            if (d0 < 0.4) {
                                vec31 = vec31.scale(d0);
                            }
                            vec3 = vec3.add(vec31);
                            ++k1;
                        }
                    }
                    ++j2;
                }
                ++i2;
            }
            ++l1;
        }
        if (vec3.length() > 0.0) {
            if (k1 > 0) {
                vec3 = vec3.scale(1.0 / (double)k1);
            }
            if (!(this instanceof Player)) {
                vec3 = vec3.normalize();
            }
            Vec3 vec32 = this.getDeltaMovement();
            vec3 = vec3.scale(pMotionScale * 1.0);
            double d2 = 0.003;
            if (Math.abs(vec32.x) < 0.003 && Math.abs(vec32.z) < 0.003 && vec3.length() < 0.0045000000000000005) {
                vec3 = vec3.normalize().scale(0.0045000000000000005);
            }
            this.setDeltaMovement(this.getDeltaMovement().add(vec3));
        }
        this.fluidHeight.put(pFluidTag, d0);
        return flag1;
    }

    public boolean touchingUnloadedChunk() {
        int l;
        AABB aabb = this.getBoundingBox().inflate(1.0);
        int i = Mth.floor(aabb.minX);
        int j = Mth.ceil(aabb.maxX);
        int k = Mth.floor(aabb.minZ);
        return !this.level.hasChunksAt(i, k, j, l = Mth.ceil(aabb.maxZ));
    }

    public double getFluidHeight(TagKey<Fluid> pFluidTag) {
        return this.fluidHeight.getDouble(pFluidTag);
    }

    public double getFluidJumpThreshold() {
        return (double)this.getEyeHeight() < 0.4 ? 0.0 : 0.4;
    }

    public final float getBbWidth() {
        return this.dimensions.width;
    }

    public final float getBbHeight() {
        return this.dimensions.height;
    }

    public abstract Packet<?> getAddEntityPacket();

    public EntityDimensions getDimensions(Pose pPose) {
        return this.type.getDimensions();
    }

    public Vec3 position() {
        return this.position;
    }

    @Override
    public BlockPos blockPosition() {
        return this.blockPosition;
    }

    public BlockState getFeetBlockState() {
        if (this.feetBlockState == null) {
            this.feetBlockState = this.level.getBlockState(this.blockPosition());
        }
        return this.feetBlockState;
    }

    public BlockPos eyeBlockPosition() {
        return new BlockPos(this.getEyePosition(1.0f));
    }

    public ChunkPos chunkPosition() {
        return this.chunkPosition;
    }

    public Vec3 getDeltaMovement() {
        return this.deltaMovement;
    }

    public void setDeltaMovement(Vec3 pMotion) {
        this.deltaMovement = pMotion;
    }

    public void setDeltaMovement(double pX, double p_20336_, double pY) {
        this.setDeltaMovement(new Vec3(pX, p_20336_, pY));
    }

    public final int getBlockX() {
        return this.blockPosition.getX();
    }

    public final double getX() {
        return this.position.x;
    }

    public double getX(double pScale) {
        return this.position.x + (double)this.getBbWidth() * pScale;
    }

    public double getRandomX(double pScale) {
        return this.getX((2.0 * this.random.nextDouble() - 1.0) * pScale);
    }

    public final int getBlockY() {
        return this.blockPosition.getY();
    }

    public final double getY() {
        return this.position.y;
    }

    public double getY(double pScale) {
        return this.position.y + (double)this.getBbHeight() * pScale;
    }

    public double getRandomY() {
        return this.getY(this.random.nextDouble());
    }

    public double getEyeY() {
        return this.position.y + (double)this.eyeHeight;
    }

    public final int getBlockZ() {
        return this.blockPosition.getZ();
    }

    public final double getZ() {
        return this.position.z;
    }

    public double getZ(double pScale) {
        return this.position.z + (double)this.getBbWidth() * pScale;
    }

    public double getRandomZ(double pScale) {
        return this.getZ((2.0 * this.random.nextDouble() - 1.0) * pScale);
    }

    public final void setPosRaw(double pX, double p_20345_, double pY) {
        if (this.position.x != pX || this.position.y != p_20345_ || this.position.z != pY) {
            this.position = new Vec3(pX, p_20345_, pY);
            int i = Mth.floor(pX);
            int j = Mth.floor(p_20345_);
            int k = Mth.floor(pY);
            if (i != this.blockPosition.getX() || j != this.blockPosition.getY() || k != this.blockPosition.getZ()) {
                this.blockPosition = new BlockPos(i, j, k);
                this.feetBlockState = null;
                if (SectionPos.blockToSectionCoord(i) != this.chunkPosition.x || SectionPos.blockToSectionCoord(k) != this.chunkPosition.z) {
                    this.chunkPosition = new ChunkPos(this.blockPosition);
                }
            }
            this.levelCallback.onMove();
            GameEventListenerRegistrar gameeventlistenerregistrar = this.getGameEventListenerRegistrar();
            if (gameeventlistenerregistrar != null) {
                gameeventlistenerregistrar.onListenerMove(this.level);
            }
        }
    }

    public void checkDespawn() {
    }

    public Vec3 getRopeHoldPosition(float pPartialTicks) {
        return this.getPosition(pPartialTicks).add(0.0, (double)this.eyeHeight * 0.7, 0.0);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket pPacket) {
        int i = pPacket.getId();
        double d0 = pPacket.getX();
        double d1 = pPacket.getY();
        double d2 = pPacket.getZ();
        this.setPacketCoordinates(d0, d1, d2);
        this.moveTo(d0, d1, d2);
        this.setXRot((float)(pPacket.getxRot() * 360) / 256.0f);
        this.setYRot((float)(pPacket.getyRot() * 360) / 256.0f);
        this.setId(i);
        this.setUUID(pPacket.getUUID());
    }

    @Nullable
    public ItemStack getPickResult() {
        return null;
    }

    public void setIsInPowderSnow(boolean pIsInPowderSnow) {
        this.isInPowderSnow = pIsInPowderSnow;
    }

    public boolean canFreeze() {
        return !this.getType().is(EntityTypeTags.FREEZE_IMMUNE_ENTITY_TYPES);
    }

    public boolean isFreezing() {
        return (this.isInPowderSnow || this.wasInPowderSnow) && this.canFreeze();
    }

    public float getYRot() {
        return this.yRot;
    }

    public void setYRot(float pYRot) {
        if (!Float.isFinite(pYRot)) {
            Util.logAndPauseIfInIde("Invalid entity rotation: " + pYRot + ", discarding.");
        } else {
            this.yRot = pYRot;
        }
    }

    public float getXRot() {
        return this.xRot;
    }

    public void setXRot(float pXRot) {
        if (!Float.isFinite(pXRot)) {
            Util.logAndPauseIfInIde("Invalid entity rotation: " + pXRot + ", discarding.");
        } else {
            this.xRot = pXRot;
        }
    }

    public final boolean isRemoved() {
        return this.removalReason != null;
    }

    @Nullable
    public RemovalReason getRemovalReason() {
        return this.removalReason;
    }

    @Override
    public final void setRemoved(RemovalReason p_146876_) {
        if (this.removalReason == null) {
            this.removalReason = p_146876_;
        }
        if (this.removalReason.shouldDestroy()) {
            this.stopRiding();
        }
        this.getPassengers().forEach(Entity::stopRiding);
        this.levelCallback.onRemove(p_146876_);
    }

    protected void unsetRemoved() {
        this.removalReason = null;
    }

    @Override
    public void setLevelCallback(EntityInLevelCallback p_146849_) {
        this.levelCallback = p_146849_;
    }

    @Override
    public boolean shouldBeSaved() {
        if (this.removalReason != null && !this.removalReason.shouldSave()) {
            return false;
        }
        if (this.isPassenger()) {
            return false;
        }
        return !this.isVehicle() || !this.hasExactlyOnePlayerPassenger();
    }

    @Override
    public boolean isAlwaysTicking() {
        return false;
    }

    public boolean mayInteract(Level pLevel, BlockPos pPos) {
        return true;
    }

    public Level getLevel() {
        return this.level;
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public void accept(Entity var1, double var2, double var4, double var6);
    }

    public static enum MovementEmission {
        NONE(false, false),
        SOUNDS(true, false),
        EVENTS(false, true),
        ALL(true, true);

        final boolean sounds;
        final boolean events;

        private MovementEmission(boolean p_146942_, boolean p_146943_) {
            this.sounds = p_146942_;
            this.events = p_146943_;
        }

        public boolean emitsAnything() {
            return this.events || this.sounds;
        }

        public boolean emitsEvents() {
            return this.events;
        }

        public boolean emitsSounds() {
            return this.sounds;
        }
    }

    public static enum RemovalReason {
        KILLED(true, false),
        DISCARDED(true, false),
        UNLOADED_TO_CHUNK(false, true),
        UNLOADED_WITH_PLAYER(false, false),
        CHANGED_DIMENSION(false, false);

        private final boolean destroy;
        private final boolean save;

        private RemovalReason(boolean p_146963_, boolean p_146964_) {
            this.destroy = p_146963_;
            this.save = p_146964_;
        }

        public boolean shouldDestroy() {
            return this.destroy;
        }

        public boolean shouldSave() {
            return this.save;
        }
    }
}

