/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

public enum EquipmentSlot {
    MAINHAND(Type.HAND, 0, 0, "mainhand"),
    OFFHAND(Type.HAND, 1, 5, "offhand"),
    FEET(Type.ARMOR, 0, 1, "feet"),
    LEGS(Type.ARMOR, 1, 2, "legs"),
    CHEST(Type.ARMOR, 2, 3, "chest"),
    HEAD(Type.ARMOR, 3, 4, "head");

    private final Type type;
    private final int index;
    private final int filterFlag;
    private final String name;

    private EquipmentSlot(Type p_20739_, int p_20740_, int p_20741_, String p_20742_) {
        this.type = p_20739_;
        this.index = p_20740_;
        this.filterFlag = p_20741_;
        this.name = p_20742_;
    }

    public Type getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public int getIndex(int p_147069_) {
        return p_147069_ + this.index;
    }

    public int getFilterFlag() {
        return this.filterFlag;
    }

    public String getName() {
        return this.name;
    }

    public static EquipmentSlot byName(String pTargetName) {
        EquipmentSlot[] equipmentSlotArray = EquipmentSlot.values();
        int n = equipmentSlotArray.length;
        int n2 = 0;
        while (n2 < n) {
            EquipmentSlot equipmentslot = equipmentSlotArray[n2];
            if (equipmentslot.getName().equals(pTargetName)) {
                return equipmentslot;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Invalid slot '" + pTargetName + "'");
    }

    public static EquipmentSlot byTypeAndIndex(Type pSlotType, int pSlotIndex) {
        EquipmentSlot[] equipmentSlotArray = EquipmentSlot.values();
        int n = equipmentSlotArray.length;
        int n2 = 0;
        while (n2 < n) {
            EquipmentSlot equipmentslot = equipmentSlotArray[n2];
            if (equipmentslot.getType() == pSlotType && equipmentslot.getIndex() == pSlotIndex) {
                return equipmentslot;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Invalid slot '" + (Object)((Object)pSlotType) + "': " + pSlotIndex);
    }

    public static enum Type {
        HAND,
        ARMOR;

    }
}

