/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public interface ItemSteerable {
    public boolean boost();

    public void travelWithInput(Vec3 var1);

    public float getSteeringSpeed();

    default public boolean travel(Mob p_20855_, ItemBasedSteering p_20856_, Vec3 p_20857_) {
        if (!p_20855_.isAlive()) {
            return false;
        }
        Entity entity = p_20855_.getFirstPassenger();
        if (p_20855_.isVehicle() && p_20855_.canBeControlledByRider() && entity instanceof Player) {
            p_20855_.setYRot(entity.getYRot());
            p_20855_.yRotO = p_20855_.getYRot();
            p_20855_.setXRot(entity.getXRot() * 0.5f);
            p_20855_.setRot(p_20855_.getYRot(), p_20855_.getXRot());
            p_20855_.yBodyRot = p_20855_.getYRot();
            p_20855_.yHeadRot = p_20855_.getYRot();
            p_20855_.maxUpStep = 1.0f;
            p_20855_.flyingSpeed = p_20855_.getSpeed() * 0.1f;
            if (p_20856_.boosting && p_20856_.boostTime++ > p_20856_.boostTimeTotal) {
                p_20856_.boosting = false;
            }
            if (p_20855_.isControlledByLocalInstance()) {
                float f = this.getSteeringSpeed();
                if (p_20856_.boosting) {
                    f += f * 1.15f * Mth.sin((float)p_20856_.boostTime / (float)p_20856_.boostTimeTotal * (float)Math.PI);
                }
                p_20855_.setSpeed(f);
                this.travelWithInput(new Vec3(0.0, 0.0, 1.0));
                p_20855_.lerpSteps = 0;
            } else {
                p_20855_.calculateEntityAnimation(p_20855_, false);
                p_20855_.setDeltaMovement(Vec3.ZERO);
            }
            p_20855_.tryCheckInsideBlocks();
            return true;
        }
        p_20855_.maxUpStep = 0.5f;
        p_20855_.flyingSpeed = 0.02f;
        this.travelWithInput(p_20857_);
        return false;
    }
}

