/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class Brain<E extends LivingEntity> {
    static final Logger LOGGER = LogUtils.getLogger();
    private final Supplier<Codec<Brain<E>>> codec;
    private static final int SCHEDULE_UPDATE_DELAY = 20;
    private final Map<MemoryModuleType<?>, Optional<? extends ExpirableValue<?>>> memories = Maps.newHashMap();
    private final Map<SensorType<? extends Sensor<? super E>>, Sensor<? super E>> sensors = Maps.newLinkedHashMap();
    private final Map<Integer, Map<Activity, Set<Behavior<? super E>>>> availableBehaviorsByPriority = Maps.newTreeMap();
    private Schedule schedule = Schedule.EMPTY;
    private final Map<Activity, Set<Pair<MemoryModuleType<?>, MemoryStatus>>> activityRequirements = Maps.newHashMap();
    private final Map<Activity, Set<MemoryModuleType<?>>> activityMemoriesToEraseWhenStopped = Maps.newHashMap();
    private Set<Activity> coreActivities = Sets.newHashSet();
    private final Set<Activity> activeActivities = Sets.newHashSet();
    private Activity defaultActivity = Activity.IDLE;
    private long lastScheduleUpdate = -9999L;

    public static <E extends LivingEntity> Provider<E> provider(Collection<? extends MemoryModuleType<?>> pMemoryTypes, Collection<? extends SensorType<? extends Sensor<? super E>>> pSensorTypes) {
        return new Provider(pMemoryTypes, pSensorTypes);
    }

    public static <E extends LivingEntity> Codec<Brain<E>> codec(Collection<? extends MemoryModuleType<?>> pMemoryTypes, Collection<? extends SensorType<? extends Sensor<? super E>>> pSensorTypes) {
        MutableObject mutableobject = new MutableObject();
        mutableobject.setValue((Object)new MapCodec<Brain<E>>(){

            public <T> Stream<T> keys(DynamicOps<T> p_22029_) {
                return pMemoryTypes.stream().flatMap(p_22020_ -> p_22020_.getCodec().map(p_147346_ -> Registry.MEMORY_MODULE_TYPE.getKey((MemoryModuleType<?>)p_22020_)).stream()).map(p_22018_ -> p_22029_.createString(p_22018_.toString()));
            }

            public <T> DataResult<Brain<E>> decode(DynamicOps<T> p_22022_, MapLike<T> p_22023_) {
                MutableObject mutableobject1 = new MutableObject((Object)DataResult.success((Object)ImmutableList.builder()));
                p_22023_.entries().forEach(p_22015_ -> {
                    DataResult dataresult = Registry.MEMORY_MODULE_TYPE.byNameCodec().parse(p_22022_, p_22015_.getFirst());
                    DataResult dataresult1 = dataresult.flatMap(p_147350_ -> this.captureRead((MemoryModuleType)p_147350_, p_22022_, (Object)p_22015_.getSecond()));
                    mutableobject1.setValue((Object)((DataResult)mutableobject1.getValue()).apply2(ImmutableList.Builder::add, dataresult1));
                });
                ImmutableList immutablelist = ((DataResult)mutableobject1.getValue()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).map(ImmutableList.Builder::build).orElseGet(ImmutableList::of);
                return DataResult.success(new Brain(pMemoryTypes, pSensorTypes, immutablelist, () -> ((MutableObject)mutableobject).getValue()));
            }

            private <T, U> DataResult<MemoryValue<U>> captureRead(MemoryModuleType<U> p_21997_, DynamicOps<T> p_21998_, T p_21999_) {
                return p_21997_.getCodec().map(DataResult::success).orElseGet(() -> DataResult.error((String)("No codec for memory: " + p_21997_))).flatMap(p_22011_ -> p_22011_.parse(p_21998_, p_21999_)).map(p_21992_ -> new MemoryValue(p_21997_, Optional.of(p_21992_)));
            }

            public <T> RecordBuilder<T> encode(Brain<E> p_21985_, DynamicOps<T> p_21986_, RecordBuilder<T> p_21987_) {
                p_21985_.memories().forEach(p_22007_ -> p_22007_.serialize(p_21986_, p_21987_));
                return p_21987_;
            }
        }.fieldOf("memories").codec());
        return (Codec)mutableobject.getValue();
    }

    public Brain(Collection<? extends MemoryModuleType<?>> pMemoryModuleTypes, Collection<? extends SensorType<? extends Sensor<? super E>>> pSensorTypes, ImmutableList<MemoryValue<?>> pMemoryValues, Supplier<Codec<Brain<E>>> pCodec) {
        this.codec = pCodec;
        for (MemoryModuleType<?> memoryModuleType : pMemoryModuleTypes) {
            this.memories.put(memoryModuleType, Optional.empty());
        }
        for (SensorType sensorType : pSensorTypes) {
            this.sensors.put(sensorType, (Sensor<E>)sensorType.create());
        }
        for (Sensor sensor : this.sensors.values()) {
            for (MemoryModuleType<?> memorymoduletype1 : sensor.requires()) {
                this.memories.put(memorymoduletype1, Optional.empty());
            }
        }
        for (MemoryValue memoryValue : pMemoryValues) {
            memoryValue.setMemoryInternal(this);
        }
    }

    public <T> DataResult<T> serializeStart(DynamicOps<T> pOps) {
        return this.codec.get().encodeStart(pOps, (Object)this);
    }

    Stream<MemoryValue<?>> memories() {
        return this.memories.entrySet().stream().map(p_21929_ -> MemoryValue.createUnchecked((MemoryModuleType)p_21929_.getKey(), (Optional)p_21929_.getValue()));
    }

    public boolean hasMemoryValue(MemoryModuleType<?> pType) {
        return this.checkMemory(pType, MemoryStatus.VALUE_PRESENT);
    }

    public <U> void eraseMemory(MemoryModuleType<U> pType) {
        this.setMemory(pType, Optional.empty());
    }

    public <U> void setMemory(MemoryModuleType<U> pMemoryType, @Nullable U pMemory) {
        this.setMemory(pMemoryType, Optional.ofNullable(pMemory));
    }

    public <U> void setMemoryWithExpiry(MemoryModuleType<U> pMemoryType, U pMemory, long pTimesToLive) {
        this.setMemoryInternal(pMemoryType, Optional.of(ExpirableValue.of(pMemory, pTimesToLive)));
    }

    public <U> void setMemory(MemoryModuleType<U> pMemoryType, Optional<? extends U> pMemory) {
        this.setMemoryInternal(pMemoryType, pMemory.map(ExpirableValue::of));
    }

    <U> void setMemoryInternal(MemoryModuleType<U> pMemoryType, Optional<? extends ExpirableValue<?>> pMemory) {
        if (this.memories.containsKey(pMemoryType)) {
            if (pMemory.isPresent() && this.isEmptyCollection(pMemory.get().getValue())) {
                this.eraseMemory(pMemoryType);
            } else {
                this.memories.put(pMemoryType, pMemory);
            }
        }
    }

    public <U> Optional<U> getMemory(MemoryModuleType<U> pType) {
        return this.memories.get(pType).map(ExpirableValue::getValue);
    }

    public <U> long getTimeUntilExpiry(MemoryModuleType<U> pMemoryType) {
        Optional<ExpirableValue<?>> optional = this.memories.get(pMemoryType);
        return optional.map(ExpirableValue::getTimeToLive).orElse(0L);
    }

    @Deprecated
    @VisibleForDebug
    public Map<MemoryModuleType<?>, Optional<? extends ExpirableValue<?>>> getMemories() {
        return this.memories;
    }

    public <U> boolean isMemoryValue(MemoryModuleType<U> pMemoryType, U pMemory) {
        return !this.hasMemoryValue(pMemoryType) ? false : this.getMemory(pMemoryType).filter(p_21922_ -> p_21922_.equals(pMemory)).isPresent();
    }

    public boolean checkMemory(MemoryModuleType<?> pMemoryType, MemoryStatus pMemoryStatus) {
        Optional<ExpirableValue<?>> optional = this.memories.get(pMemoryType);
        if (optional == null) {
            return false;
        }
        return pMemoryStatus == MemoryStatus.REGISTERED || pMemoryStatus == MemoryStatus.VALUE_PRESENT && optional.isPresent() || pMemoryStatus == MemoryStatus.VALUE_ABSENT && !optional.isPresent();
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Schedule pNewSchedule) {
        this.schedule = pNewSchedule;
    }

    public void setCoreActivities(Set<Activity> pNewActivities) {
        this.coreActivities = pNewActivities;
    }

    @Deprecated
    @VisibleForDebug
    public Set<Activity> getActiveActivities() {
        return this.activeActivities;
    }

    @Deprecated
    @VisibleForDebug
    public List<Behavior<? super E>> getRunningBehaviors() {
        ObjectArrayList list = new ObjectArrayList();
        for (Map<Activity, Set<Behavior<E>>> map : this.availableBehaviorsByPriority.values()) {
            for (Set<Behavior<E>> set : map.values()) {
                for (Behavior<E> behavior : set) {
                    if (behavior.getStatus() != Behavior.Status.RUNNING) continue;
                    list.add(behavior);
                }
            }
        }
        return list;
    }

    public void useDefaultActivity() {
        this.setActiveActivity(this.defaultActivity);
    }

    public Optional<Activity> getActiveNonCoreActivity() {
        for (Activity activity : this.activeActivities) {
            if (this.coreActivities.contains(activity)) continue;
            return Optional.of(activity);
        }
        return Optional.empty();
    }

    public void setActiveActivityIfPossible(Activity pActivity) {
        if (this.activityRequirementsAreMet(pActivity)) {
            this.setActiveActivity(pActivity);
        } else {
            this.useDefaultActivity();
        }
    }

    private void setActiveActivity(Activity pActivity) {
        if (!this.isActive(pActivity)) {
            this.eraseMemoriesForOtherActivitesThan(pActivity);
            this.activeActivities.clear();
            this.activeActivities.addAll(this.coreActivities);
            this.activeActivities.add(pActivity);
        }
    }

    private void eraseMemoriesForOtherActivitesThan(Activity pActivity) {
        for (Activity activity : this.activeActivities) {
            Set<MemoryModuleType<?>> set;
            if (activity == pActivity || (set = this.activityMemoriesToEraseWhenStopped.get(activity)) == null) continue;
            for (MemoryModuleType<?> memorymoduletype : set) {
                this.eraseMemory(memorymoduletype);
            }
        }
    }

    public void updateActivityFromSchedule(long pDayTime, long p_21864_) {
        if (p_21864_ - this.lastScheduleUpdate > 20L) {
            this.lastScheduleUpdate = p_21864_;
            Activity activity = this.getSchedule().getActivityAt((int)(pDayTime % 24000L));
            if (!this.activeActivities.contains(activity)) {
                this.setActiveActivityIfPossible(activity);
            }
        }
    }

    public void setActiveActivityToFirstValid(List<Activity> pActivities) {
        for (Activity activity : pActivities) {
            if (!this.activityRequirementsAreMet(activity)) continue;
            this.setActiveActivity(activity);
            break;
        }
    }

    public void setDefaultActivity(Activity pNewFallbackActivity) {
        this.defaultActivity = pNewFallbackActivity;
    }

    public void addActivity(Activity pActivity, int pPriorityStart, ImmutableList<? extends Behavior<? super E>> pTasks) {
        this.addActivity(pActivity, this.createPriorityPairs(pPriorityStart, pTasks));
    }

    public void addActivityAndRemoveMemoryWhenStopped(Activity pActivity, int pPriorityStart, ImmutableList<? extends Behavior<? super E>> pTasks, MemoryModuleType<?> pMemoryType) {
        ImmutableSet set = ImmutableSet.of((Object)Pair.of(pMemoryType, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        ImmutableSet set1 = ImmutableSet.of(pMemoryType);
        this.addActivityAndRemoveMemoriesWhenStopped(pActivity, (ImmutableList<? extends Pair<Integer, ? extends Behavior<? super E>>>)this.createPriorityPairs(pPriorityStart, pTasks), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)set, (Set<MemoryModuleType<?>>)set1);
    }

    public void addActivity(Activity pActivity, ImmutableList<? extends Pair<Integer, ? extends Behavior<? super E>>> pTasks) {
        this.addActivityAndRemoveMemoriesWhenStopped(pActivity, pTasks, (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of(), Sets.newHashSet());
    }

    public void addActivityWithConditions(Activity pActivity, ImmutableList<? extends Pair<Integer, ? extends Behavior<? super E>>> pTasks, Set<Pair<MemoryModuleType<?>, MemoryStatus>> pMemoryStatuses) {
        this.addActivityAndRemoveMemoriesWhenStopped(pActivity, pTasks, pMemoryStatuses, Sets.newHashSet());
    }

    public void addActivityAndRemoveMemoriesWhenStopped(Activity pActivity, ImmutableList<? extends Pair<Integer, ? extends Behavior<? super E>>> pTasks, Set<Pair<MemoryModuleType<?>, MemoryStatus>> pMemorieStatuses, Set<MemoryModuleType<?>> pMemoryTypes) {
        this.activityRequirements.put(pActivity, pMemorieStatuses);
        if (!pMemoryTypes.isEmpty()) {
            this.activityMemoriesToEraseWhenStopped.put(pActivity, pMemoryTypes);
        }
        for (Pair pair : pTasks) {
            this.availableBehaviorsByPriority.computeIfAbsent((Integer)pair.getFirst(), p_21917_ -> Maps.newHashMap()).computeIfAbsent(pActivity, p_21972_ -> Sets.newLinkedHashSet()).add((Behavior)pair.getSecond());
        }
    }

    @VisibleForTesting
    public void removeAllBehaviors() {
        this.availableBehaviorsByPriority.clear();
    }

    public boolean isActive(Activity pActivity) {
        return this.activeActivities.contains(pActivity);
    }

    public Brain<E> copyWithoutBehaviors() {
        Brain<E> brain = new Brain<E>(this.memories.keySet(), this.sensors.keySet(), ImmutableList.of(), this.codec);
        for (Map.Entry<MemoryModuleType<?>, Optional<ExpirableValue<?>>> entry : this.memories.entrySet()) {
            MemoryModuleType<?> memorymoduletype = entry.getKey();
            if (!entry.getValue().isPresent()) continue;
            brain.memories.put(memorymoduletype, entry.getValue());
        }
        return brain;
    }

    public void tick(ServerLevel pLevel, E pEntity) {
        this.forgetOutdatedMemories();
        this.tickSensors(pLevel, pEntity);
        this.startEachNonRunningBehavior(pLevel, pEntity);
        this.tickEachRunningBehavior(pLevel, pEntity);
    }

    private void tickSensors(ServerLevel pLevel, E pBrainHolder) {
        for (Sensor<E> sensor : this.sensors.values()) {
            sensor.tick(pLevel, pBrainHolder);
        }
    }

    private void forgetOutdatedMemories() {
        for (Map.Entry<MemoryModuleType<?>, Optional<ExpirableValue<?>>> entry : this.memories.entrySet()) {
            if (!entry.getValue().isPresent()) continue;
            ExpirableValue<?> expirablevalue = entry.getValue().get();
            expirablevalue.tick();
            if (!expirablevalue.hasExpired()) continue;
            this.eraseMemory(entry.getKey());
        }
    }

    public void stopAll(ServerLevel pLevel, E pOwner) {
        long i = ((LivingEntity)pOwner).level.getGameTime();
        for (Behavior<E> behavior : this.getRunningBehaviors()) {
            behavior.doStop(pLevel, pOwner, i);
        }
    }

    private void startEachNonRunningBehavior(ServerLevel pLevel, E pEntity) {
        long i = pLevel.getGameTime();
        for (Map<Activity, Set<Behavior<E>>> map : this.availableBehaviorsByPriority.values()) {
            for (Map.Entry<Activity, Set<Behavior<E>>> entry : map.entrySet()) {
                Activity activity = entry.getKey();
                if (!this.activeActivities.contains(activity)) continue;
                for (Behavior<E> behavior : entry.getValue()) {
                    if (behavior.getStatus() != Behavior.Status.STOPPED) continue;
                    behavior.tryStart(pLevel, pEntity, i);
                }
            }
        }
    }

    private void tickEachRunningBehavior(ServerLevel pLevel, E pEntity) {
        long i = pLevel.getGameTime();
        for (Behavior<E> behavior : this.getRunningBehaviors()) {
            behavior.tickOrStop(pLevel, pEntity, i);
        }
    }

    private boolean activityRequirementsAreMet(Activity pActivity) {
        if (!this.activityRequirements.containsKey(pActivity)) {
            return false;
        }
        for (Pair<MemoryModuleType<?>, MemoryStatus> pair : this.activityRequirements.get(pActivity)) {
            MemoryStatus memorystatus;
            MemoryModuleType memorymoduletype = (MemoryModuleType)pair.getFirst();
            if (this.checkMemory(memorymoduletype, memorystatus = (MemoryStatus)((Object)pair.getSecond()))) continue;
            return false;
        }
        return true;
    }

    private boolean isEmptyCollection(Object pCollection) {
        return pCollection instanceof Collection && ((Collection)pCollection).isEmpty();
    }

    ImmutableList<? extends Pair<Integer, ? extends Behavior<? super E>>> createPriorityPairs(int pPriorityStart, ImmutableList<? extends Behavior<? super E>> pTasks) {
        int i = pPriorityStart;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Behavior behavior : pTasks) {
            builder.add((Object)Pair.of((Object)i++, (Object)behavior));
        }
        return builder.build();
    }

    static final class MemoryValue<U> {
        private final MemoryModuleType<U> type;
        private final Optional<? extends ExpirableValue<U>> value;

        static <U> MemoryValue<U> createUnchecked(MemoryModuleType<U> pMemoryType, Optional<? extends ExpirableValue<?>> pMemory) {
            return new MemoryValue<U>(pMemoryType, pMemory);
        }

        MemoryValue(MemoryModuleType<U> pType, Optional<? extends ExpirableValue<U>> pValue) {
            this.type = pType;
            this.value = pValue;
        }

        void setMemoryInternal(Brain<?> pBrain) {
            pBrain.setMemoryInternal(this.type, this.value);
        }

        public <T> void serialize(DynamicOps<T> pOps, RecordBuilder<T> pBuilder) {
            this.type.getCodec().ifPresent(p_22053_ -> this.value.ifPresent(p_147355_ -> pBuilder.add(Registry.MEMORY_MODULE_TYPE.byNameCodec().encodeStart(pOps, this.type), p_22053_.encodeStart(pOps, p_147355_))));
        }
    }

    public static final class Provider<E extends LivingEntity> {
        private final Collection<? extends MemoryModuleType<?>> memoryTypes;
        private final Collection<? extends SensorType<? extends Sensor<? super E>>> sensorTypes;
        private final Codec<Brain<E>> codec;

        Provider(Collection<? extends MemoryModuleType<?>> pMemoryTypes, Collection<? extends SensorType<? extends Sensor<? super E>>> pSensorTypes) {
            this.memoryTypes = pMemoryTypes;
            this.sensorTypes = pSensorTypes;
            this.codec = Brain.codec(pMemoryTypes, pSensorTypes);
        }

        public Brain<E> makeBrain(Dynamic<?> pOps) {
            return this.codec.parse(pOps).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseGet(() -> new Brain(this.memoryTypes, this.sensorTypes, ImmutableList.of(), () -> this.codec));
        }
    }
}

