/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class BabyFollowAdult<E extends AgeableMob>
extends Behavior<E> {
    private final UniformInt followRange;
    private final Function<LivingEntity, Float> speedModifier;

    public BabyFollowAdult(UniformInt p_147414_, float p_147415_) {
        this(p_147414_, p_147421_ -> Float.valueOf(p_147415_));
    }

    public BabyFollowAdult(UniformInt p_147417_, Function<LivingEntity, Float> p_147418_) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.NEAREST_VISIBLE_ADULT, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
        this.followRange = p_147417_;
        this.speedModifier = p_147418_;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel p_147423_, E p_147424_) {
        if (!((AgeableMob)p_147424_).isBaby()) {
            return false;
        }
        AgeableMob ageablemob = this.getNearestAdult(p_147424_);
        return ((Entity)p_147424_).closerThan(ageablemob, this.followRange.getMaxValue() + 1) && !((Entity)p_147424_).closerThan(ageablemob, this.followRange.getMinValue());
    }

    @Override
    protected void start(ServerLevel p_147426_, E p_147427_, long p_147428_) {
        BehaviorUtils.setWalkAndLookTargetMemories(p_147427_, this.getNearestAdult(p_147427_), this.speedModifier.apply((LivingEntity)p_147427_).floatValue(), this.followRange.getMinValue() - 1);
    }

    private AgeableMob getNearestAdult(E p_147430_) {
        return ((LivingEntity)p_147430_).getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT).get();
    }
}

