/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class BackUpIfTooClose<E extends Mob>
extends Behavior<E> {
    private final int tooCloseDistance;
    private final float strafeSpeed;

    public BackUpIfTooClose(int p_22492_, float p_22493_) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.tooCloseDistance = p_22492_;
        this.strafeSpeed = p_22493_;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel pLevel, E pOwner) {
        return this.isTargetVisible(pOwner) && this.isTargetTooClose(pOwner);
    }

    @Override
    protected void start(ServerLevel pLevel, E pEntity, long pGameTime) {
        ((LivingEntity)pEntity).getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new EntityTracker(this.getTarget(pEntity), true));
        ((Mob)pEntity).getMoveControl().strafe(-this.strafeSpeed, 0.0f);
        ((Entity)pEntity).setYRot(Mth.rotateIfNecessary(((Entity)pEntity).getYRot(), ((Mob)pEntity).yHeadRot, 0.0f));
    }

    private boolean isTargetVisible(E pMob) {
        return ((LivingEntity)pMob).getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).get().contains(this.getTarget(pMob));
    }

    private boolean isTargetTooClose(E pMob) {
        return this.getTarget(pMob).closerThan((Entity)pMob, this.tooCloseDistance);
    }

    private LivingEntity getTarget(E pMob) {
        return ((LivingEntity)pMob).getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
    }
}

