/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Comparator;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;

public class BehaviorUtils {
    private BehaviorUtils() {
    }

    public static void lockGazeAndWalkToEachOther(LivingEntity pFirstEntity, LivingEntity pSecondEntity, float pSpeed) {
        BehaviorUtils.lookAtEachOther(pFirstEntity, pSecondEntity);
        BehaviorUtils.setWalkAndLookTargetMemoriesToEachOther(pFirstEntity, pSecondEntity, pSpeed);
    }

    public static boolean entityIsVisible(Brain<?> pBrain, LivingEntity pTarget) {
        Optional<NearestVisibleLivingEntities> optional = pBrain.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
        return optional.isPresent() && optional.get().contains(pTarget);
    }

    public static boolean targetIsValid(Brain<?> pBrain, MemoryModuleType<? extends LivingEntity> pMemoryType, EntityType<?> pLivingPredicate) {
        return BehaviorUtils.targetIsValid(pBrain, pMemoryType, (LivingEntity p_186022_) -> p_186022_.getType() == pLivingPredicate);
    }

    private static boolean targetIsValid(Brain<?> pBrain, MemoryModuleType<? extends LivingEntity> pMemoryType, Predicate<LivingEntity> pLivingPredicate) {
        return pBrain.getMemory(pMemoryType).filter(pLivingPredicate).filter(LivingEntity::isAlive).filter(p_186037_ -> BehaviorUtils.entityIsVisible(pBrain, p_186037_)).isPresent();
    }

    private static void lookAtEachOther(LivingEntity pFirstEntity, LivingEntity pSecondEntity) {
        BehaviorUtils.lookAtEntity(pFirstEntity, pSecondEntity);
        BehaviorUtils.lookAtEntity(pSecondEntity, pFirstEntity);
    }

    public static void lookAtEntity(LivingEntity pEntity, LivingEntity pTarget) {
        pEntity.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new EntityTracker(pTarget, true));
    }

    private static void setWalkAndLookTargetMemoriesToEachOther(LivingEntity pFirstEntity, LivingEntity pSecondEntity, float pSpeed) {
        int i = 2;
        BehaviorUtils.setWalkAndLookTargetMemories(pFirstEntity, pSecondEntity, pSpeed, 2);
        BehaviorUtils.setWalkAndLookTargetMemories(pSecondEntity, pFirstEntity, pSpeed, 2);
    }

    public static void setWalkAndLookTargetMemories(LivingEntity pLivingEntity, Entity pPos, float pSpeed, int pDistance) {
        WalkTarget walktarget = new WalkTarget(new EntityTracker(pPos, false), pSpeed, pDistance);
        pLivingEntity.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new EntityTracker(pPos, true));
        pLivingEntity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, walktarget);
    }

    public static void setWalkAndLookTargetMemories(LivingEntity pLivingEntity, BlockPos pPos, float pSpeed, int pDistance) {
        WalkTarget walktarget = new WalkTarget(new BlockPosTracker(pPos), pSpeed, pDistance);
        pLivingEntity.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BlockPosTracker(pPos));
        pLivingEntity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, walktarget);
    }

    public static void throwItem(LivingEntity pLivingEntity, ItemStack pStack, Vec3 pOffset) {
        double d0 = pLivingEntity.getEyeY() - (double)0.3f;
        ItemEntity itementity = new ItemEntity(pLivingEntity.level, pLivingEntity.getX(), d0, pLivingEntity.getZ(), pStack);
        float f = 0.3f;
        Vec3 vec3 = pOffset.subtract(pLivingEntity.position());
        vec3 = vec3.normalize().scale(0.3f);
        itementity.setDeltaMovement(vec3);
        itementity.setDefaultPickUpDelay();
        pLivingEntity.level.addFreshEntity(itementity);
    }

    public static SectionPos findSectionClosestToVillage(ServerLevel pServerLevel, SectionPos pSectionPos, int pRadius) {
        int i = pServerLevel.sectionsToVillage(pSectionPos);
        return SectionPos.cube(pSectionPos, pRadius).filter(p_186017_ -> pServerLevel.sectionsToVillage((SectionPos)p_186017_) < i).min(Comparator.comparingInt(pServerLevel::sectionsToVillage)).orElse(pSectionPos);
    }

    public static boolean isWithinAttackRange(Mob pMob, LivingEntity pTarget, int pCooldown) {
        Item item = pMob.getMainHandItem().getItem();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem projectileweaponitem = (ProjectileWeaponItem)item;
            if (pMob.canFireProjectileWeapon((ProjectileWeaponItem)item)) {
                int i = projectileweaponitem.getDefaultProjectileRange() - pCooldown;
                return pMob.closerThan(pTarget, i);
            }
        }
        return BehaviorUtils.isWithinMeleeAttackRange(pMob, pTarget);
    }

    public static boolean isWithinMeleeAttackRange(Mob p_147442_, LivingEntity p_147443_) {
        double d0 = p_147442_.distanceToSqr(p_147443_.getX(), p_147443_.getY(), p_147443_.getZ());
        return d0 <= p_147442_.getMeleeAttackRangeSqr(p_147443_);
    }

    public static boolean isOtherTargetMuchFurtherAwayThanCurrentAttackTarget(LivingEntity pLivingEntity, LivingEntity pTarget, double pDistance) {
        Optional<LivingEntity> optional = pLivingEntity.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        if (optional.isEmpty()) {
            return false;
        }
        double d0 = pLivingEntity.distanceToSqr(optional.get().position());
        double d1 = pLivingEntity.distanceToSqr(pTarget.position());
        return d1 > d0 + pDistance * pDistance;
    }

    public static boolean canSee(LivingEntity pLivingEntity, LivingEntity pTarget) {
        Brain<NearestVisibleLivingEntities> brain = pLivingEntity.getBrain();
        return !brain.hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES) ? false : brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).get().contains(pTarget);
    }

    public static LivingEntity getNearestTarget(LivingEntity pCenterEntity, Optional<LivingEntity> pOptionalEntity, LivingEntity pLivingEntity) {
        return pOptionalEntity.isEmpty() ? pLivingEntity : BehaviorUtils.getTargetNearestMe(pCenterEntity, pOptionalEntity.get(), pLivingEntity);
    }

    public static LivingEntity getTargetNearestMe(LivingEntity pCenterEntity, LivingEntity pLivingEntity1, LivingEntity pLivingEntity2) {
        Vec3 vec3 = pLivingEntity1.position();
        Vec3 vec31 = pLivingEntity2.position();
        return pCenterEntity.distanceToSqr(vec3) < pCenterEntity.distanceToSqr(vec31) ? pLivingEntity1 : pLivingEntity2;
    }

    public static Optional<LivingEntity> getLivingEntityFromUUIDMemory(LivingEntity pLivingEntity, MemoryModuleType<UUID> pTargetMemory) {
        Optional<UUID> optional = pLivingEntity.getBrain().getMemory(pTargetMemory);
        return optional.map(p_186027_ -> ((ServerLevel)livingEntity.level).getEntity((UUID)p_186027_)).map(p_186019_ -> {
            LivingEntity livingentity;
            LivingEntity livingentity1 = p_186019_ instanceof LivingEntity ? (livingentity = (LivingEntity)p_186019_) : null;
            return livingentity1;
        });
    }

    public static Stream<Villager> getNearbyVillagersWithCondition(Villager pVillager, Predicate<Villager> pVillagerPredicate) {
        return pVillager.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).map(p_186034_ -> p_186034_.stream().filter(p_186030_ -> p_186030_ instanceof Villager && p_186030_ != pVillager).map(p_186024_ -> (Villager)p_186024_).filter(LivingEntity::isAlive).filter(pVillagerPredicate)).orElseGet(Stream::empty);
    }

    @Nullable
    public static Vec3 getRandomSwimmablePos(PathfinderMob p_147445_, int p_147446_, int p_147447_) {
        Vec3 vec3 = DefaultRandomPos.getPos(p_147445_, p_147446_, p_147447_);
        int i = 0;
        while (vec3 != null && !p_147445_.level.getBlockState(new BlockPos(vec3)).isPathfindable(p_147445_.level, new BlockPos(vec3), PathComputationType.WATER) && i++ < 10) {
            vec3 = DefaultRandomPos.getPos(p_147445_, p_147446_, p_147447_);
        }
        return vec3;
    }
}

