/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class CrossbowAttack<E extends Mob, T extends LivingEntity>
extends Behavior<E> {
    private static final int TIMEOUT = 1200;
    private int attackDelay;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;

    public CrossbowAttack() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT)), 1200);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel pLevel, E pOwner) {
        LivingEntity livingentity = CrossbowAttack.getAttackTarget(pOwner);
        return ((LivingEntity)pOwner).isHolding(Items.CROSSBOW) && BehaviorUtils.canSee(pOwner, livingentity) && BehaviorUtils.isWithinAttackRange(pOwner, livingentity, 0);
    }

    @Override
    protected boolean canStillUse(ServerLevel pLevel, E pEntity, long pGameTime) {
        return ((LivingEntity)pEntity).getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET) && this.checkExtraStartConditions(pLevel, pEntity);
    }

    @Override
    protected void tick(ServerLevel pLevel, E pOwner, long pGameTime) {
        LivingEntity livingentity = CrossbowAttack.getAttackTarget(pOwner);
        this.lookAtTarget((Mob)pOwner, livingentity);
        this.crossbowAttack(pOwner, livingentity);
    }

    @Override
    protected void stop(ServerLevel pLevel, E pEntity, long pGameTime) {
        if (((LivingEntity)pEntity).isUsingItem()) {
            ((LivingEntity)pEntity).stopUsingItem();
        }
        if (((LivingEntity)pEntity).isHolding(Items.CROSSBOW)) {
            ((CrossbowAttackMob)pEntity).setChargingCrossbow(false);
            CrossbowItem.setCharged(((LivingEntity)pEntity).getUseItem(), false);
        }
    }

    private void crossbowAttack(E p_22787_, LivingEntity p_22788_) {
        if (this.crossbowState == CrossbowState.UNCHARGED) {
            ((LivingEntity)p_22787_).startUsingItem(ProjectileUtil.getWeaponHoldingHand(p_22787_, Items.CROSSBOW));
            this.crossbowState = CrossbowState.CHARGING;
            ((CrossbowAttackMob)p_22787_).setChargingCrossbow(true);
        } else if (this.crossbowState == CrossbowState.CHARGING) {
            ItemStack itemstack;
            int i;
            if (!((LivingEntity)p_22787_).isUsingItem()) {
                this.crossbowState = CrossbowState.UNCHARGED;
            }
            if ((i = ((LivingEntity)p_22787_).getTicksUsingItem()) >= CrossbowItem.getChargeDuration(itemstack = ((LivingEntity)p_22787_).getUseItem())) {
                ((LivingEntity)p_22787_).releaseUsingItem();
                this.crossbowState = CrossbowState.CHARGED;
                this.attackDelay = 20 + ((LivingEntity)p_22787_).getRandom().nextInt(20);
                ((CrossbowAttackMob)p_22787_).setChargingCrossbow(false);
            }
        } else if (this.crossbowState == CrossbowState.CHARGED) {
            --this.attackDelay;
            if (this.attackDelay == 0) {
                this.crossbowState = CrossbowState.READY_TO_ATTACK;
            }
        } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK) {
            ((CrossbowAttackMob)p_22787_).performRangedAttack(p_22788_, 1.0f);
            ItemStack itemstack1 = ((LivingEntity)p_22787_).getItemInHand(ProjectileUtil.getWeaponHoldingHand(p_22787_, Items.CROSSBOW));
            CrossbowItem.setCharged(itemstack1, false);
            this.crossbowState = CrossbowState.UNCHARGED;
        }
    }

    private void lookAtTarget(Mob p_22798_, LivingEntity p_22799_) {
        p_22798_.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new EntityTracker(p_22799_, true));
    }

    private static LivingEntity getAttackTarget(LivingEntity p_22785_) {
        return p_22785_.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

