/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class DismountOrSkipMounting<E extends LivingEntity, T extends Entity>
extends Behavior<E> {
    private final int maxWalkDistToRideTarget;
    private final BiPredicate<E, Entity> dontRideIf;

    public DismountOrSkipMounting(int p_22827_, BiPredicate<E, Entity> p_22828_) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.RIDE_TARGET, (Object)((Object)MemoryStatus.REGISTERED)));
        this.maxWalkDistToRideTarget = p_22827_;
        this.dontRideIf = p_22828_;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel pLevel, E pOwner) {
        Entity entity2;
        Entity entity = ((Entity)pOwner).getVehicle();
        Entity entity1 = ((LivingEntity)pOwner).getBrain().getMemory(MemoryModuleType.RIDE_TARGET).orElse(null);
        if (entity == null && entity1 == null) {
            return false;
        }
        Entity entity3 = entity2 = entity == null ? entity1 : entity;
        return !this.isVehicleValid(pOwner, entity2) || this.dontRideIf.test(pOwner, entity2);
    }

    private boolean isVehicleValid(E p_22837_, Entity p_22838_) {
        return p_22838_.isAlive() && p_22838_.closerThan((Entity)p_22837_, this.maxWalkDistToRideTarget) && p_22838_.level == ((LivingEntity)p_22837_).level;
    }

    @Override
    protected void start(ServerLevel pLevel, E pEntity, long pGameTime) {
        ((LivingEntity)pEntity).stopRiding();
        ((LivingEntity)pEntity).getBrain().eraseMemory(MemoryModuleType.RIDE_TARGET);
    }
}

