/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class GiveGiftToHero
extends Behavior<Villager> {
    private static final int THROW_GIFT_AT_DISTANCE = 5;
    private static final int MIN_TIME_BETWEEN_GIFTS = 600;
    private static final int MAX_TIME_BETWEEN_GIFTS = 6600;
    private static final int TIME_TO_DELAY_FOR_HEAD_TO_FINISH_TURNING = 20;
    private static final Map<VillagerProfession, ResourceLocation> GIFTS = Util.make(Maps.newHashMap(), p_23020_ -> {
        p_23020_.put(VillagerProfession.ARMORER, BuiltInLootTables.ARMORER_GIFT);
        p_23020_.put(VillagerProfession.BUTCHER, BuiltInLootTables.BUTCHER_GIFT);
        p_23020_.put(VillagerProfession.CARTOGRAPHER, BuiltInLootTables.CARTOGRAPHER_GIFT);
        p_23020_.put(VillagerProfession.CLERIC, BuiltInLootTables.CLERIC_GIFT);
        p_23020_.put(VillagerProfession.FARMER, BuiltInLootTables.FARMER_GIFT);
        p_23020_.put(VillagerProfession.FISHERMAN, BuiltInLootTables.FISHERMAN_GIFT);
        p_23020_.put(VillagerProfession.FLETCHER, BuiltInLootTables.FLETCHER_GIFT);
        p_23020_.put(VillagerProfession.LEATHERWORKER, BuiltInLootTables.LEATHERWORKER_GIFT);
        p_23020_.put(VillagerProfession.LIBRARIAN, BuiltInLootTables.LIBRARIAN_GIFT);
        p_23020_.put(VillagerProfession.MASON, BuiltInLootTables.MASON_GIFT);
        p_23020_.put(VillagerProfession.SHEPHERD, BuiltInLootTables.SHEPHERD_GIFT);
        p_23020_.put(VillagerProfession.TOOLSMITH, BuiltInLootTables.TOOLSMITH_GIFT);
        p_23020_.put(VillagerProfession.WEAPONSMITH, BuiltInLootTables.WEAPONSMITH_GIFT);
    });
    private static final float SPEED_MODIFIER = 0.5f;
    private int timeUntilNextGift = 600;
    private boolean giftGivenDuringThisRun;
    private long timeSinceStart;

    public GiveGiftToHero(int p_22992_) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.INTERACTION_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)((Object)MemoryStatus.VALUE_PRESENT)), p_22992_);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (!this.isHeroVisible(pOwner)) {
            return false;
        }
        if (this.timeUntilNextGift > 0) {
            --this.timeUntilNextGift;
            return false;
        }
        return true;
    }

    @Override
    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        this.giftGivenDuringThisRun = false;
        this.timeSinceStart = pGameTime;
        Player player = this.getNearestTargetableHero(pEntity).get();
        pEntity.getBrain().setMemory(MemoryModuleType.INTERACTION_TARGET, player);
        BehaviorUtils.lookAtEntity(pEntity, player);
    }

    @Override
    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return this.isHeroVisible(pEntity) && !this.giftGivenDuringThisRun;
    }

    @Override
    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        Player player = this.getNearestTargetableHero(pOwner).get();
        BehaviorUtils.lookAtEntity(pOwner, player);
        if (this.isWithinThrowingDistance(pOwner, player)) {
            if (pGameTime - this.timeSinceStart > 20L) {
                this.throwGift(pOwner, player);
                this.giftGivenDuringThisRun = true;
            }
        } else {
            BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)pOwner, player, 0.5f, 5);
        }
    }

    @Override
    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        this.timeUntilNextGift = GiveGiftToHero.calculateTimeUntilNextGift(pLevel);
        pEntity.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
        pEntity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        pEntity.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
    }

    private void throwGift(Villager pVillager, LivingEntity pHero) {
        for (ItemStack itemstack : this.getItemToThrow(pVillager)) {
            BehaviorUtils.throwItem(pVillager, itemstack, pHero.position());
        }
    }

    private List<ItemStack> getItemToThrow(Villager pVillager) {
        if (pVillager.isBaby()) {
            return ImmutableList.of((Object)new ItemStack(Items.POPPY));
        }
        VillagerProfession villagerprofession = pVillager.getVillagerData().getProfession();
        if (GIFTS.containsKey(villagerprofession)) {
            LootTable loottable = pVillager.level.getServer().getLootTables().get(GIFTS.get(villagerprofession));
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)pVillager.level).withParameter(LootContextParams.ORIGIN, pVillager.position()).withParameter(LootContextParams.THIS_ENTITY, pVillager).withRandom(pVillager.getRandom());
            return loottable.getRandomItems(lootcontext$builder.create(LootContextParamSets.GIFT));
        }
        return ImmutableList.of((Object)new ItemStack(Items.WHEAT_SEEDS));
    }

    private boolean isHeroVisible(Villager pVillager) {
        return this.getNearestTargetableHero(pVillager).isPresent();
    }

    private Optional<Player> getNearestTargetableHero(Villager pVillager) {
        return pVillager.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER).filter(this::isHero);
    }

    private boolean isHero(Player p_23018_) {
        return p_23018_.hasEffect(MobEffects.HERO_OF_THE_VILLAGE);
    }

    private boolean isWithinThrowingDistance(Villager pVillager, Player pHero) {
        BlockPos blockpos = pHero.blockPosition();
        BlockPos blockpos1 = pVillager.blockPosition();
        return blockpos1.closerThan(blockpos, 5.0);
    }

    private static int calculateTimeUntilNextGift(ServerLevel pLevel) {
        return 600 + pLevel.random.nextInt(6001);
    }
}

