/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.phys.Vec3;

public class GoToClosestVillage
extends Behavior<Villager> {
    private final float speedModifier;
    private final int closeEnoughDistance;

    public GoToClosestVillage(float p_23077_, int p_23078_) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
        this.speedModifier = p_23077_;
        this.closeEnoughDistance = p_23078_;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        return !pLevel.isVillage(pOwner.blockPosition());
    }

    @Override
    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        PoiManager poimanager = pLevel.getPoiManager();
        int i = poimanager.sectionsToVillage(SectionPos.of(pEntity.blockPosition()));
        Vec3 vec3 = null;
        int j = 0;
        while (j < 5) {
            Vec3 vec31 = LandRandomPos.getPos(pEntity, 15, 7, p_147554_ -> -poimanager.sectionsToVillage(SectionPos.of(p_147554_)));
            if (vec31 != null) {
                int k = poimanager.sectionsToVillage(SectionPos.of(new BlockPos(vec31)));
                if (k < i) {
                    vec3 = vec31;
                    break;
                }
                if (k == i) {
                    vec3 = vec31;
                }
            }
            ++j;
        }
        if (vec3 != null) {
            pEntity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(vec3, this.speedModifier, this.closeEnoughDistance));
        }
    }
}

