/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;

public class HarvestFarmland
extends Behavior<Villager> {
    private static final int HARVEST_DURATION = 200;
    public static final float SPEED_MODIFIER = 0.5f;
    @Nullable
    private BlockPos aboveFarmlandPos;
    private long nextOkStartTime;
    private int timeWorkedSoFar;
    private final List<BlockPos> validFarmlandAroundVillager = Lists.newArrayList();

    public HarvestFarmland() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.SECONDARY_JOB_SITE, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (!pLevel.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            return false;
        }
        if (pOwner.getVillagerData().getProfession() != VillagerProfession.FARMER) {
            return false;
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pOwner.blockPosition().mutable();
        this.validFarmlandAroundVillager.clear();
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                int k = -1;
                while (k <= 1) {
                    blockpos$mutableblockpos.set(pOwner.getX() + (double)i, pOwner.getY() + (double)j, pOwner.getZ() + (double)k);
                    if (this.validPos(blockpos$mutableblockpos, pLevel)) {
                        this.validFarmlandAroundVillager.add(new BlockPos(blockpos$mutableblockpos));
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.aboveFarmlandPos = this.getValidFarmland(pLevel);
        return this.aboveFarmlandPos != null;
    }

    @Nullable
    private BlockPos getValidFarmland(ServerLevel pServerLevel) {
        return this.validFarmlandAroundVillager.isEmpty() ? null : this.validFarmlandAroundVillager.get(pServerLevel.getRandom().nextInt(this.validFarmlandAroundVillager.size()));
    }

    private boolean validPos(BlockPos pPos, ServerLevel pServerLevel) {
        BlockState blockstate = pServerLevel.getBlockState(pPos);
        Block block = blockstate.getBlock();
        Block block1 = pServerLevel.getBlockState(pPos.below()).getBlock();
        return block instanceof CropBlock && ((CropBlock)block).isMaxAge(blockstate) || blockstate.isAir() && block1 instanceof FarmBlock;
    }

    @Override
    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        if (pGameTime > this.nextOkStartTime && this.aboveFarmlandPos != null) {
            pEntity.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BlockPosTracker(this.aboveFarmlandPos));
            pEntity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(new BlockPosTracker(this.aboveFarmlandPos), 0.5f, 1));
        }
    }

    @Override
    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        pEntity.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        pEntity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        this.timeWorkedSoFar = 0;
        this.nextOkStartTime = pGameTime + 40L;
    }

    @Override
    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        if (this.aboveFarmlandPos == null || this.aboveFarmlandPos.closerToCenterThan(pOwner.position(), 1.0)) {
            if (this.aboveFarmlandPos != null && pGameTime > this.nextOkStartTime) {
                BlockState blockstate = pLevel.getBlockState(this.aboveFarmlandPos);
                Block block = blockstate.getBlock();
                Block block1 = pLevel.getBlockState(this.aboveFarmlandPos.below()).getBlock();
                if (block instanceof CropBlock && ((CropBlock)block).isMaxAge(blockstate)) {
                    pLevel.destroyBlock(this.aboveFarmlandPos, true, pOwner);
                }
                if (blockstate.isAir() && block1 instanceof FarmBlock && pOwner.hasFarmSeeds()) {
                    SimpleContainer simplecontainer = pOwner.getInventory();
                    int i = 0;
                    while (i < simplecontainer.getContainerSize()) {
                        ItemStack itemstack = simplecontainer.getItem(i);
                        boolean flag = false;
                        if (!itemstack.isEmpty()) {
                            if (itemstack.is(Items.WHEAT_SEEDS)) {
                                pLevel.setBlock(this.aboveFarmlandPos, Blocks.WHEAT.defaultBlockState(), 3);
                                flag = true;
                            } else if (itemstack.is(Items.POTATO)) {
                                pLevel.setBlock(this.aboveFarmlandPos, Blocks.POTATOES.defaultBlockState(), 3);
                                flag = true;
                            } else if (itemstack.is(Items.CARROT)) {
                                pLevel.setBlock(this.aboveFarmlandPos, Blocks.CARROTS.defaultBlockState(), 3);
                                flag = true;
                            } else if (itemstack.is(Items.BEETROOT_SEEDS)) {
                                pLevel.setBlock(this.aboveFarmlandPos, Blocks.BEETROOTS.defaultBlockState(), 3);
                                flag = true;
                            }
                        }
                        if (flag) {
                            pLevel.playSound(null, this.aboveFarmlandPos.getX(), this.aboveFarmlandPos.getY(), this.aboveFarmlandPos.getZ(), SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 1.0f, 1.0f);
                            itemstack.shrink(1);
                            if (!itemstack.isEmpty()) break;
                            simplecontainer.setItem(i, ItemStack.EMPTY);
                            break;
                        }
                        ++i;
                    }
                }
                if (block instanceof CropBlock && !((CropBlock)block).isMaxAge(blockstate)) {
                    this.validFarmlandAroundVillager.remove(this.aboveFarmlandPos);
                    this.aboveFarmlandPos = this.getValidFarmland(pLevel);
                    if (this.aboveFarmlandPos != null) {
                        this.nextOkStartTime = pGameTime + 20L;
                        pOwner.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(new BlockPosTracker(this.aboveFarmlandPos), 0.5f, 1));
                        pOwner.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BlockPosTracker(this.aboveFarmlandPos));
                    }
                }
            }
            ++this.timeWorkedSoFar;
        }
    }

    @Override
    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return this.timeWorkedSoFar < 200;
    }
}

