/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;

public class InsideBrownianWalk
extends Behavior<PathfinderMob> {
    private final float speedModifier;

    public InsideBrownianWalk(float p_23209_) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
        this.speedModifier = p_23209_;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel pLevel, PathfinderMob pOwner) {
        return !pLevel.canSeeSky(pOwner.blockPosition());
    }

    @Override
    protected void start(ServerLevel pLevel, PathfinderMob pEntity, long pGameTime) {
        BlockPos blockpos = pEntity.blockPosition();
        List list = BlockPos.betweenClosedStream(blockpos.offset(-1, -1, -1), blockpos.offset(1, 1, 1)).map(BlockPos::immutable).collect(Collectors.toList());
        Collections.shuffle(list);
        Optional<BlockPos> optional = list.stream().filter(p_23230_ -> !pLevel.canSeeSky((BlockPos)p_23230_)).filter(p_23237_ -> pLevel.loadedAndEntityCanStandOn((BlockPos)p_23237_, pEntity)).filter(p_23227_ -> pLevel.noCollision(pEntity)).findFirst();
        optional.ifPresent(p_23233_ -> pEntity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget((BlockPos)p_23233_, this.speedModifier, 0)));
    }
}

