/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class LongJumpMidJump
extends Behavior<Mob> {
    public static final int TIME_OUT_DURATION = 100;
    private final UniformInt timeBetweenLongJumps;
    private SoundEvent landingSound;

    public LongJumpMidJump(UniformInt p_147596_, SoundEvent p_147597_) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LONG_JUMP_MID_JUMP, (Object)((Object)MemoryStatus.VALUE_PRESENT)), 100);
        this.timeBetweenLongJumps = p_147596_;
        this.landingSound = p_147597_;
    }

    @Override
    protected boolean canStillUse(ServerLevel p_147603_, Mob p_147604_, long p_147605_) {
        return !p_147604_.isOnGround();
    }

    @Override
    protected void start(ServerLevel p_147611_, Mob p_147612_, long p_147613_) {
        p_147612_.setDiscardFriction(true);
        p_147612_.setPose(Pose.LONG_JUMPING);
    }

    @Override
    protected void stop(ServerLevel p_147619_, Mob p_147620_, long p_147621_) {
        if (p_147620_.isOnGround()) {
            p_147620_.setDeltaMovement(p_147620_.getDeltaMovement().scale(0.1f));
            p_147619_.playSound(null, p_147620_, this.landingSound, SoundSource.NEUTRAL, 2.0f, 1.0f);
        }
        p_147620_.setDiscardFriction(false);
        p_147620_.setPose(Pose.STANDING);
        p_147620_.getBrain().eraseMemory(MemoryModuleType.LONG_JUMP_MID_JUMP);
        p_147620_.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, this.timeBetweenLongJumps.sample(p_147619_.random));
    }
}

