/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileWeaponItem;

public class MeleeAttack
extends Behavior<Mob> {
    private final int cooldownBetweenAttacks;

    public MeleeAttack(int p_23512_) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.ATTACK_COOLING_DOWN, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
        this.cooldownBetweenAttacks = p_23512_;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel pLevel, Mob pOwner) {
        LivingEntity livingentity = this.getAttackTarget(pOwner);
        return !this.isHoldingUsableProjectileWeapon(pOwner) && BehaviorUtils.canSee(pOwner, livingentity) && BehaviorUtils.isWithinMeleeAttackRange(pOwner, livingentity);
    }

    private boolean isHoldingUsableProjectileWeapon(Mob pMob) {
        return pMob.isHolding(p_147697_ -> {
            Item item = p_147697_.getItem();
            return item instanceof ProjectileWeaponItem && pMob.canFireProjectileWeapon((ProjectileWeaponItem)item);
        });
    }

    @Override
    protected void start(ServerLevel pLevel, Mob pEntity, long pGameTime) {
        LivingEntity livingentity = this.getAttackTarget(pEntity);
        BehaviorUtils.lookAtEntity(pEntity, livingentity);
        pEntity.swing(InteractionHand.MAIN_HAND);
        pEntity.doHurtTarget(livingentity);
        pEntity.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, true, this.cooldownBetweenAttacks);
    }

    private LivingEntity getAttackTarget(Mob pMob) {
        return pMob.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
    }
}

