/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class Mount<E extends LivingEntity>
extends Behavior<E> {
    private static final int CLOSE_ENOUGH_TO_START_RIDING_DIST = 1;
    private final float speedModifier;

    public Mount(float p_23536_) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.RIDE_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.speedModifier = p_23536_;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel pLevel, E pOwner) {
        return !((Entity)pOwner).isPassenger();
    }

    @Override
    protected void start(ServerLevel pLevel, E pEntity, long pGameTime) {
        if (this.isCloseEnoughToStartRiding(pEntity)) {
            ((Entity)pEntity).startRiding(this.getRidableEntity(pEntity));
        } else {
            BehaviorUtils.setWalkAndLookTargetMemories(pEntity, this.getRidableEntity(pEntity), this.speedModifier, 1);
        }
    }

    private boolean isCloseEnoughToStartRiding(E p_23545_) {
        return this.getRidableEntity(p_23545_).closerThan((Entity)p_23545_, 1.0);
    }

    private Entity getRidableEntity(E p_23547_) {
        return ((LivingEntity)p_23547_).getBrain().getMemory(MemoryModuleType.RIDE_TARGET).get();
    }
}

