/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class PlayTagWithOtherKids
extends Behavior<PathfinderMob> {
    private static final int MAX_FLEE_XZ_DIST = 20;
    private static final int MAX_FLEE_Y_DIST = 8;
    private static final float FLEE_SPEED_MODIFIER = 0.6f;
    private static final float CHASE_SPEED_MODIFIER = 0.6f;
    private static final int MAX_CHASERS_PER_TARGET = 5;
    private static final int AVERAGE_WAIT_TIME_BETWEEN_RUNS = 10;

    public PlayTagWithOtherKids() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.VISIBLE_VILLAGER_BABIES, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.INTERACTION_TARGET, (Object)((Object)MemoryStatus.REGISTERED)));
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel pLevel, PathfinderMob pOwner) {
        return pLevel.getRandom().nextInt(10) == 0 && this.hasFriendsNearby(pOwner);
    }

    @Override
    protected void start(ServerLevel pLevel, PathfinderMob pEntity, long pGameTime) {
        LivingEntity livingentity = this.seeIfSomeoneIsChasingMe(pEntity);
        if (livingentity != null) {
            this.fleeFromChaser(pLevel, pEntity, livingentity);
        } else {
            Optional<LivingEntity> optional = this.findSomeoneBeingChased(pEntity);
            if (optional.isPresent()) {
                PlayTagWithOtherKids.chaseKid(pEntity, optional.get());
            } else {
                this.findSomeoneToChase(pEntity).ifPresent(p_23666_ -> PlayTagWithOtherKids.chaseKid(pEntity, p_23666_));
            }
        }
    }

    private void fleeFromChaser(ServerLevel p_23636_, PathfinderMob p_23637_, LivingEntity p_23638_) {
        int i = 0;
        while (i < 10) {
            Vec3 vec3 = LandRandomPos.getPos(p_23637_, 20, 8);
            if (vec3 != null && p_23636_.isVillage(new BlockPos(vec3))) {
                p_23637_.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(vec3, 0.6f, 0));
                return;
            }
            ++i;
        }
    }

    private static void chaseKid(PathfinderMob p_23650_, LivingEntity p_23651_) {
        Brain<?> brain = p_23650_.getBrain();
        brain.setMemory(MemoryModuleType.INTERACTION_TARGET, p_23651_);
        brain.setMemory(MemoryModuleType.LOOK_TARGET, new EntityTracker(p_23651_, true));
        brain.setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(new EntityTracker(p_23651_, false), 0.6f, 1));
    }

    private Optional<LivingEntity> findSomeoneToChase(PathfinderMob p_23648_) {
        return this.getFriendsNearby(p_23648_).stream().findAny();
    }

    private Optional<LivingEntity> findSomeoneBeingChased(PathfinderMob p_23663_) {
        Map<LivingEntity, Integer> map = this.checkHowManyChasersEachFriendHas(p_23663_);
        return map.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).filter(p_23653_ -> (Integer)p_23653_.getValue() > 0 && (Integer)p_23653_.getValue() <= 5).map(Map.Entry::getKey).findFirst();
    }

    private Map<LivingEntity, Integer> checkHowManyChasersEachFriendHas(PathfinderMob p_23673_) {
        HashMap map = Maps.newHashMap();
        this.getFriendsNearby(p_23673_).stream().filter(this::isChasingSomeone).forEach(p_23656_ -> map.compute(this.whoAreYouChasing((LivingEntity)p_23656_), (p_147707_, p_147708_) -> p_147708_ == null ? 1 : p_147708_ + 1));
        return map;
    }

    private List<LivingEntity> getFriendsNearby(PathfinderMob p_23675_) {
        return p_23675_.getBrain().getMemory(MemoryModuleType.VISIBLE_VILLAGER_BABIES).get();
    }

    private LivingEntity whoAreYouChasing(LivingEntity p_23640_) {
        return p_23640_.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).get();
    }

    @Nullable
    private LivingEntity seeIfSomeoneIsChasingMe(LivingEntity p_23658_) {
        return p_23658_.getBrain().getMemory(MemoryModuleType.VISIBLE_VILLAGER_BABIES).get().stream().filter(p_23671_ -> this.isFriendChasingMe(p_23658_, (LivingEntity)p_23671_)).findAny().orElse(null);
    }

    private boolean isChasingSomeone(LivingEntity p_23668_) {
        return p_23668_.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).isPresent();
    }

    private boolean isFriendChasingMe(LivingEntity p_23642_, LivingEntity p_23643_) {
        return p_23643_.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).filter(p_23661_ -> p_23661_ == p_23642_).isPresent();
    }

    private boolean hasFriendsNearby(PathfinderMob p_23677_) {
        return p_23677_.getBrain().hasMemoryValue(MemoryModuleType.VISIBLE_VILLAGER_BABIES);
    }
}

