/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class RingBell
extends Behavior<LivingEntity> {
    private static final float BELL_RING_CHANCE = 0.95f;
    public static final int RING_BELL_FROM_DISTANCE = 3;

    public RingBell() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.MEETING_POINT, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel pLevel, LivingEntity pOwner) {
        return pLevel.random.nextFloat() > 0.95f;
    }

    @Override
    protected void start(ServerLevel pLevel, LivingEntity pEntity, long pGameTime) {
        BlockState blockstate;
        Brain<?> brain = pEntity.getBrain();
        BlockPos blockpos = brain.getMemory(MemoryModuleType.MEETING_POINT).get().pos();
        if (blockpos.closerThan(pEntity.blockPosition(), 3.0) && (blockstate = pLevel.getBlockState(blockpos)).is(Blocks.BELL)) {
            BellBlock bellblock = (BellBlock)blockstate.getBlock();
            bellblock.attemptToRing(pEntity, pLevel, blockpos, null);
        }
    }
}

