/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;

public class SetEntityLookTarget
extends Behavior<LivingEntity> {
    private final Predicate<LivingEntity> predicate;
    private final float maxDistSqr;
    private Optional<LivingEntity> nearestEntityMatchingTest = Optional.empty();

    public SetEntityLookTarget(TagKey<EntityType<?>> p_204047_, float p_204048_) {
        this((LivingEntity p_204051_) -> p_204051_.getType().is(p_204047_), p_204048_);
    }

    public SetEntityLookTarget(MobCategory p_23897_, float p_23898_) {
        this((LivingEntity p_23923_) -> p_23897_.equals(p_23923_.getType().getCategory()), p_23898_);
    }

    public SetEntityLookTarget(EntityType<?> p_23894_, float p_23895_) {
        this((LivingEntity p_23911_) -> p_23894_.equals(p_23911_.getType()), p_23895_);
    }

    public SetEntityLookTarget(float p_23892_) {
        this((LivingEntity p_23913_) -> true, p_23892_);
    }

    public SetEntityLookTarget(Predicate<LivingEntity> p_23900_, float p_23901_) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.predicate = p_23900_;
        this.maxDistSqr = p_23901_ * p_23901_;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel pLevel, LivingEntity pOwner) {
        NearestVisibleLivingEntities nearestvisiblelivingentities = pOwner.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).get();
        this.nearestEntityMatchingTest = nearestvisiblelivingentities.findClosest(this.predicate.and(p_186053_ -> p_186053_.distanceToSqr(pOwner) <= (double)this.maxDistSqr));
        return this.nearestEntityMatchingTest.isPresent();
    }

    @Override
    protected void start(ServerLevel pLevel, LivingEntity pEntity, long pGameTime) {
        pEntity.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new EntityTracker(this.nearestEntityMatchingTest.get(), true));
        this.nearestEntityMatchingTest = Optional.empty();
    }
}

