/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class SetHiddenState
extends Behavior<LivingEntity> {
    private static final int HIDE_TIMEOUT = 300;
    private final int closeEnoughDist;
    private final int stayHiddenTicks;
    private int ticksHidden;

    public SetHiddenState(int p_23931_, int p_23932_) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.HIDING_PLACE, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.HEARD_BELL_TIME, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.stayHiddenTicks = p_23931_ * 20;
        this.ticksHidden = 0;
        this.closeEnoughDist = p_23932_;
    }

    @Override
    protected void start(ServerLevel pLevel, LivingEntity pEntity, long pGameTime) {
        boolean flag;
        Brain<?> brain = pEntity.getBrain();
        Optional<Long> optional = brain.getMemory(MemoryModuleType.HEARD_BELL_TIME);
        boolean bl = flag = optional.get() + 300L <= pGameTime;
        if (this.ticksHidden <= this.stayHiddenTicks && !flag) {
            BlockPos blockpos = brain.getMemory(MemoryModuleType.HIDING_PLACE).get().pos();
            if (blockpos.closerThan(pEntity.blockPosition(), this.closeEnoughDist)) {
                ++this.ticksHidden;
            }
        } else {
            brain.eraseMemory(MemoryModuleType.HEARD_BELL_TIME);
            brain.eraseMemory(MemoryModuleType.HIDING_PLACE);
            brain.updateActivityFromSchedule(pLevel.getDayTime(), pLevel.getGameTime());
            this.ticksHidden = 0;
        }
    }
}

