/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;

public class SleepInBed
extends Behavior<LivingEntity> {
    public static final int COOLDOWN_AFTER_BEING_WOKEN = 100;
    private long nextOkStartTime;

    public SleepInBed() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.HOME, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.LAST_WOKEN, (Object)((Object)MemoryStatus.REGISTERED)));
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel pLevel, LivingEntity pOwner) {
        long i;
        if (pOwner.isPassenger()) {
            return false;
        }
        Brain<?> brain = pOwner.getBrain();
        GlobalPos globalpos = brain.getMemory(MemoryModuleType.HOME).get();
        if (pLevel.dimension() != globalpos.dimension()) {
            return false;
        }
        Optional<Long> optional = brain.getMemory(MemoryModuleType.LAST_WOKEN);
        if (optional.isPresent() && (i = pLevel.getGameTime() - optional.get()) > 0L && i < 100L) {
            return false;
        }
        BlockState blockstate = pLevel.getBlockState(globalpos.pos());
        return globalpos.pos().closerToCenterThan(pOwner.position(), 2.0) && blockstate.is(BlockTags.BEDS) && blockstate.getValue(BedBlock.OCCUPIED) == false;
    }

    @Override
    protected boolean canStillUse(ServerLevel pLevel, LivingEntity pEntity, long pGameTime) {
        Optional<GlobalPos> optional = pEntity.getBrain().getMemory(MemoryModuleType.HOME);
        if (!optional.isPresent()) {
            return false;
        }
        BlockPos blockpos = optional.get().pos();
        return pEntity.getBrain().isActive(Activity.REST) && pEntity.getY() > (double)blockpos.getY() + 0.4 && blockpos.closerToCenterThan(pEntity.position(), 1.14);
    }

    @Override
    protected void start(ServerLevel pLevel, LivingEntity pEntity, long pGameTime) {
        if (pGameTime > this.nextOkStartTime) {
            InteractWithDoor.closeDoorsThatIHaveOpenedOrPassedThrough(pLevel, pEntity, null, null);
            pEntity.startSleeping(pEntity.getBrain().getMemory(MemoryModuleType.HOME).get().pos());
        }
    }

    @Override
    protected boolean timedOut(long pGameTime) {
        return false;
    }

    @Override
    protected void stop(ServerLevel pLevel, LivingEntity pEntity, long pGameTime) {
        if (pEntity.isSleeping()) {
            pEntity.stopSleeping();
            this.nextOkStartTime = pGameTime + 40L;
        }
    }
}

