/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.GameRules;

public class StartCelebratingIfTargetDead
extends Behavior<LivingEntity> {
    private final int celebrateDuration;
    private final BiPredicate<LivingEntity, LivingEntity> dancePredicate;

    public StartCelebratingIfTargetDead(int p_24222_, BiPredicate<LivingEntity, LivingEntity> p_24223_) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.ANGRY_AT, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.CELEBRATE_LOCATION, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.DANCING, (Object)((Object)MemoryStatus.REGISTERED)));
        this.celebrateDuration = p_24222_;
        this.dancePredicate = p_24223_;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel pLevel, LivingEntity pOwner) {
        return this.getAttackTarget(pOwner).isDeadOrDying();
    }

    @Override
    protected void start(ServerLevel pLevel, LivingEntity pEntity, long pGameTime) {
        LivingEntity livingentity = this.getAttackTarget(pEntity);
        if (this.dancePredicate.test(pEntity, livingentity)) {
            pEntity.getBrain().setMemoryWithExpiry(MemoryModuleType.DANCING, true, this.celebrateDuration);
        }
        pEntity.getBrain().setMemoryWithExpiry(MemoryModuleType.CELEBRATE_LOCATION, livingentity.blockPosition(), this.celebrateDuration);
        if (livingentity.getType() != EntityType.PLAYER || pLevel.getGameRules().getBoolean(GameRules.RULE_FORGIVE_DEAD_PLAYERS)) {
            pEntity.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
            pEntity.getBrain().eraseMemory(MemoryModuleType.ANGRY_AT);
        }
    }

    private LivingEntity getAttackTarget(LivingEntity pLivingEntity) {
        return pLivingEntity.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
    }
}

