/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class StopAttackingIfTargetInvalid<E extends Mob>
extends Behavior<E> {
    private static final int TIMEOUT_TO_GET_WITHIN_ATTACK_RANGE = 200;
    private final Predicate<LivingEntity> stopAttackingWhen;
    private final Consumer<E> onTargetErased;

    public StopAttackingIfTargetInvalid(Predicate<LivingEntity> p_147983_, Consumer<E> p_147984_) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)((Object)MemoryStatus.REGISTERED)));
        this.stopAttackingWhen = p_147983_;
        this.onTargetErased = p_147984_;
    }

    public StopAttackingIfTargetInvalid(Predicate<LivingEntity> p_24236_) {
        this(p_24236_, p_147992_ -> {});
    }

    public StopAttackingIfTargetInvalid(Consumer<E> p_147981_) {
        this((LivingEntity p_147988_) -> false, p_147981_);
    }

    public StopAttackingIfTargetInvalid() {
        this((LivingEntity p_147986_) -> false, p_147990_ -> {});
    }

    @Override
    protected void start(ServerLevel pLevel, E pEntity, long pGameTime) {
        LivingEntity livingentity = this.getAttackTarget(pEntity);
        if (!((LivingEntity)pEntity).canAttack(livingentity)) {
            this.clearAttackTarget(pEntity);
        } else if (StopAttackingIfTargetInvalid.isTiredOfTryingToReachTarget(pEntity)) {
            this.clearAttackTarget(pEntity);
        } else if (this.isCurrentTargetDeadOrRemoved(pEntity)) {
            this.clearAttackTarget(pEntity);
        } else if (this.isCurrentTargetInDifferentLevel(pEntity)) {
            this.clearAttackTarget(pEntity);
        } else if (this.stopAttackingWhen.test(this.getAttackTarget(pEntity))) {
            this.clearAttackTarget(pEntity);
        }
    }

    private boolean isCurrentTargetInDifferentLevel(E p_24248_) {
        return this.getAttackTarget(p_24248_).level != ((Mob)p_24248_).level;
    }

    private LivingEntity getAttackTarget(E p_24252_) {
        return ((LivingEntity)p_24252_).getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
    }

    private static <E extends LivingEntity> boolean isTiredOfTryingToReachTarget(E p_24246_) {
        Optional<Long> optional = p_24246_.getBrain().getMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        return optional.isPresent() && p_24246_.level.getGameTime() - optional.get() > 200L;
    }

    private boolean isCurrentTargetDeadOrRemoved(E p_24254_) {
        Optional<LivingEntity> optional = ((LivingEntity)p_24254_).getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        return optional.isPresent() && !optional.get().isAlive();
    }

    protected void clearAttackTarget(E p_24256_) {
        this.onTargetErased.accept(p_24256_);
        ((LivingEntity)p_24256_).getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
    }
}

