/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.GameRules;

public class StopBeingAngryIfTargetDead<E extends Mob>
extends Behavior<E> {
    public StopBeingAngryIfTargetDead() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ANGRY_AT, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
    }

    @Override
    protected void start(ServerLevel pLevel, E pEntity, long pGameTime) {
        BehaviorUtils.getLivingEntityFromUUIDMemory(pEntity, MemoryModuleType.ANGRY_AT).ifPresent(p_24269_ -> {
            if (p_24269_.isDeadOrDying() && (p_24269_.getType() != EntityType.PLAYER || pLevel.getGameRules().getBoolean(GameRules.RULE_FORGIVE_DEAD_PLAYERS))) {
                pEntity.getBrain().eraseMemory(MemoryModuleType.ANGRY_AT);
            }
        });
    }
}

