/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class StrollAroundPoi
extends Behavior<PathfinderMob> {
    private static final int MIN_TIME_BETWEEN_STROLLS = 180;
    private static final int STROLL_MAX_XZ_DIST = 8;
    private static final int STROLL_MAX_Y_DIST = 6;
    private final MemoryModuleType<GlobalPos> memoryType;
    private long nextOkStartTime;
    private final int maxDistanceFromPoi;
    private final float speedModifier;

    public StrollAroundPoi(MemoryModuleType<GlobalPos> p_24308_, float p_24309_, int p_24310_) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), p_24308_, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.memoryType = p_24308_;
        this.speedModifier = p_24309_;
        this.maxDistanceFromPoi = p_24310_;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel pLevel, PathfinderMob pOwner) {
        Optional<GlobalPos> optional = pOwner.getBrain().getMemory(this.memoryType);
        return optional.isPresent() && pLevel.dimension() == optional.get().dimension() && optional.get().pos().closerToCenterThan(pOwner.position(), this.maxDistanceFromPoi);
    }

    @Override
    protected void start(ServerLevel pLevel, PathfinderMob pEntity, long pGameTime) {
        if (pGameTime > this.nextOkStartTime) {
            Optional<Vec3> optional = Optional.ofNullable(LandRandomPos.getPos(pEntity, 8, 6));
            pEntity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, optional.map(p_24326_ -> new WalkTarget((Vec3)p_24326_, this.speedModifier, 1)));
            this.nextOkStartTime = pGameTime + 180L;
        }
    }
}

