/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class Swim
extends Behavior<Mob> {
    private final float chance;

    public Swim(float pChance) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of());
        this.chance = pChance;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel pLevel, Mob pOwner) {
        return pOwner.isInWater() && pOwner.getFluidHeight(FluidTags.WATER) > pOwner.getFluidJumpThreshold() || pOwner.isInLava();
    }

    @Override
    protected boolean canStillUse(ServerLevel pLevel, Mob pEntity, long pGameTime) {
        return this.checkExtraStartConditions(pLevel, pEntity);
    }

    @Override
    protected void tick(ServerLevel pLevel, Mob pOwner, long pGameTime) {
        if (pOwner.getRandom().nextFloat() < this.chance) {
            pOwner.getJumpControl().jump();
        }
    }
}

