/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;

public class UseBonemeal
extends Behavior<Villager> {
    private static final int BONEMEALING_DURATION = 80;
    private long nextWorkCycleTime;
    private long lastBonemealingSession;
    private int timeWorkedSoFar;
    private Optional<BlockPos> cropPos = Optional.empty();

    public UseBonemeal() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (pOwner.tickCount % 10 == 0 && (this.lastBonemealingSession == 0L || this.lastBonemealingSession + 160L <= (long)pOwner.tickCount)) {
            if (pOwner.getInventory().countItem(Items.BONE_MEAL) <= 0) {
                return false;
            }
            this.cropPos = this.pickNextTarget(pLevel, pOwner);
            return this.cropPos.isPresent();
        }
        return false;
    }

    @Override
    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return this.timeWorkedSoFar < 80 && this.cropPos.isPresent();
    }

    private Optional<BlockPos> pickNextTarget(ServerLevel pLevel, Villager pVillager) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        Optional<BlockPos> optional = Optional.empty();
        int i = 0;
        int j = -1;
        while (j <= 1) {
            int k = -1;
            while (k <= 1) {
                int l = -1;
                while (l <= 1) {
                    blockpos$mutableblockpos.setWithOffset(pVillager.blockPosition(), j, k, l);
                    if (this.validPos(blockpos$mutableblockpos, pLevel) && pLevel.random.nextInt(++i) == 0) {
                        optional = Optional.of(blockpos$mutableblockpos.immutable());
                    }
                    ++l;
                }
                ++k;
            }
            ++j;
        }
        return optional;
    }

    private boolean validPos(BlockPos pPos, ServerLevel pLevel) {
        BlockState blockstate = pLevel.getBlockState(pPos);
        Block block = blockstate.getBlock();
        return block instanceof CropBlock && !((CropBlock)block).isMaxAge(blockstate);
    }

    @Override
    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        this.setCurrentCropAsTarget(pEntity);
        pEntity.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack(Items.BONE_MEAL));
        this.nextWorkCycleTime = pGameTime;
        this.timeWorkedSoFar = 0;
    }

    private void setCurrentCropAsTarget(Villager pVillager) {
        this.cropPos.ifPresent(p_24484_ -> {
            BlockPosTracker blockpostracker = new BlockPosTracker((BlockPos)p_24484_);
            pVillager.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, blockpostracker);
            pVillager.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(blockpostracker, 0.5f, 1));
        });
    }

    @Override
    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        pEntity.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        this.lastBonemealingSession = pEntity.tickCount;
    }

    @Override
    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        BlockPos blockpos = this.cropPos.get();
        if (pGameTime >= this.nextWorkCycleTime && blockpos.closerToCenterThan(pOwner.position(), 1.0)) {
            ItemStack itemstack = ItemStack.EMPTY;
            SimpleContainer simplecontainer = pOwner.getInventory();
            int i = simplecontainer.getContainerSize();
            int j = 0;
            while (j < i) {
                ItemStack itemstack1 = simplecontainer.getItem(j);
                if (itemstack1.is(Items.BONE_MEAL)) {
                    itemstack = itemstack1;
                    break;
                }
                ++j;
            }
            if (!itemstack.isEmpty() && BoneMealItem.growCrop(itemstack, pLevel, blockpos)) {
                pLevel.levelEvent(1505, blockpos, 0);
                this.cropPos = this.pickNextTarget(pLevel, pOwner);
                this.setCurrentCropAsTarget(pOwner);
                this.nextWorkCycleTime = pGameTime + 40L;
            }
            ++this.timeWorkedSoFar;
        }
    }
}

