/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.pathfinder.Path;

public class VillagerMakeLove
extends Behavior<Villager> {
    private static final int INTERACT_DIST_SQR = 5;
    private static final float SPEED_MODIFIER = 0.5f;
    private long birthTimestamp;

    public VillagerMakeLove() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.BREED_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT)), 350, 350);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        return this.isBreedingPossible(pOwner);
    }

    @Override
    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return pGameTime <= this.birthTimestamp && this.isBreedingPossible(pEntity);
    }

    @Override
    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        AgeableMob ageablemob = pEntity.getBrain().getMemory(MemoryModuleType.BREED_TARGET).get();
        BehaviorUtils.lockGazeAndWalkToEachOther(pEntity, ageablemob, 0.5f);
        pLevel.broadcastEntityEvent(ageablemob, (byte)18);
        pLevel.broadcastEntityEvent(pEntity, (byte)18);
        int i = 275 + pEntity.getRandom().nextInt(50);
        this.birthTimestamp = pGameTime + (long)i;
    }

    @Override
    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        Villager villager = (Villager)pOwner.getBrain().getMemory(MemoryModuleType.BREED_TARGET).get();
        if (!(pOwner.distanceToSqr(villager) > 5.0)) {
            BehaviorUtils.lockGazeAndWalkToEachOther(pOwner, villager, 0.5f);
            if (pGameTime >= this.birthTimestamp) {
                pOwner.eatAndDigestFood();
                villager.eatAndDigestFood();
                this.tryToGiveBirth(pLevel, pOwner, villager);
            } else if (pOwner.getRandom().nextInt(35) == 0) {
                pLevel.broadcastEntityEvent(villager, (byte)12);
                pLevel.broadcastEntityEvent(pOwner, (byte)12);
            }
        }
    }

    private void tryToGiveBirth(ServerLevel pLevel, Villager pParent, Villager pPartner) {
        Optional<BlockPos> optional = this.takeVacantBed(pLevel, pParent);
        if (!optional.isPresent()) {
            pLevel.broadcastEntityEvent(pPartner, (byte)13);
            pLevel.broadcastEntityEvent(pParent, (byte)13);
        } else {
            Optional<Villager> optional1 = this.breed(pLevel, pParent, pPartner);
            if (optional1.isPresent()) {
                this.giveBedToChild(pLevel, optional1.get(), optional.get());
            } else {
                pLevel.getPoiManager().release(optional.get());
                DebugPackets.sendPoiTicketCountPacket(pLevel, optional.get());
            }
        }
    }

    @Override
    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        pEntity.getBrain().eraseMemory(MemoryModuleType.BREED_TARGET);
    }

    private boolean isBreedingPossible(Villager pVillager) {
        Brain<Villager> brain = pVillager.getBrain();
        Optional<AgeableMob> optional = brain.getMemory(MemoryModuleType.BREED_TARGET).filter(p_148045_ -> p_148045_.getType() == EntityType.VILLAGER);
        if (!optional.isPresent()) {
            return false;
        }
        return BehaviorUtils.targetIsValid(brain, MemoryModuleType.BREED_TARGET, EntityType.VILLAGER) && pVillager.canBreed() && optional.get().canBreed();
    }

    private Optional<BlockPos> takeVacantBed(ServerLevel pLevel, Villager pVillager) {
        return pLevel.getPoiManager().take(PoiType.HOME.getPredicate(), p_24661_ -> this.canReach(pVillager, (BlockPos)p_24661_), pVillager.blockPosition(), 48);
    }

    private boolean canReach(Villager pVillager, BlockPos pPos) {
        Path path = pVillager.getNavigation().createPath(pPos, PoiType.HOME.getValidRange());
        return path != null && path.canReach();
    }

    private Optional<Villager> breed(ServerLevel pLevel, Villager pParent, Villager pPartner) {
        Villager villager = pParent.getBreedOffspring(pLevel, pPartner);
        if (villager == null) {
            return Optional.empty();
        }
        pParent.setAge(6000);
        pPartner.setAge(6000);
        villager.setAge(-24000);
        villager.moveTo(pParent.getX(), pParent.getY(), pParent.getZ(), 0.0f, 0.0f);
        pLevel.addFreshEntityWithPassengers(villager);
        pLevel.broadcastEntityEvent(villager, (byte)12);
        return Optional.of(villager);
    }

    private void giveBedToChild(ServerLevel pLevel, Villager pVillager, BlockPos pPos) {
        GlobalPos globalpos = GlobalPos.of(pLevel.dimension(), pPos);
        pVillager.getBrain().setMemory(MemoryModuleType.HOME, globalpos);
    }
}

