/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.control;

import java.util.Optional;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.Control;
import net.minecraft.world.phys.Vec3;

public class LookControl
implements Control {
    protected final Mob mob;
    protected float yMaxRotSpeed;
    protected float xMaxRotAngle;
    protected int lookAtCooldown;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;

    public LookControl(Mob pMob) {
        this.mob = pMob;
    }

    public void setLookAt(Vec3 pEntity) {
        this.setLookAt(pEntity.x, pEntity.y, pEntity.z);
    }

    public void setLookAt(Entity pEntity) {
        this.setLookAt(pEntity.getX(), LookControl.getWantedY(pEntity), pEntity.getZ());
    }

    public void setLookAt(Entity pX, float p_24962_, float pY) {
        this.setLookAt(pX.getX(), LookControl.getWantedY(pX), pX.getZ(), p_24962_, pY);
    }

    public void setLookAt(double pX, double p_24948_, double pY) {
        this.setLookAt(pX, p_24948_, pY, this.mob.getHeadRotSpeed(), this.mob.getMaxHeadXRot());
    }

    public void setLookAt(double pX, double p_24952_, double pY, float p_24954_, float pZ) {
        this.wantedX = pX;
        this.wantedY = p_24952_;
        this.wantedZ = pY;
        this.yMaxRotSpeed = p_24954_;
        this.xMaxRotAngle = pZ;
        this.lookAtCooldown = 2;
    }

    public void tick() {
        if (this.resetXRotOnTick()) {
            this.mob.setXRot(0.0f);
        }
        if (this.lookAtCooldown > 0) {
            --this.lookAtCooldown;
            this.getYRotD().ifPresent(p_181130_ -> {
                this.mob.yHeadRot = this.rotateTowards(this.mob.yHeadRot, p_181130_.floatValue(), this.yMaxRotSpeed);
            });
            this.getXRotD().ifPresent(p_181128_ -> this.mob.setXRot(this.rotateTowards(this.mob.getXRot(), p_181128_.floatValue(), this.xMaxRotAngle)));
        } else {
            this.mob.yHeadRot = this.rotateTowards(this.mob.yHeadRot, this.mob.yBodyRot, 10.0f);
        }
        this.clampHeadRotationToBody();
    }

    protected void clampHeadRotationToBody() {
        if (!this.mob.getNavigation().isDone()) {
            this.mob.yHeadRot = Mth.rotateIfNecessary(this.mob.yHeadRot, this.mob.yBodyRot, this.mob.getMaxHeadYRot());
        }
    }

    protected boolean resetXRotOnTick() {
        return true;
    }

    public boolean isLookingAtTarget() {
        return this.lookAtCooldown > 0;
    }

    public double getWantedX() {
        return this.wantedX;
    }

    public double getWantedY() {
        return this.wantedY;
    }

    public double getWantedZ() {
        return this.wantedZ;
    }

    protected Optional<Float> getXRotD() {
        double d0 = this.wantedX - this.mob.getX();
        double d1 = this.wantedY - this.mob.getEyeY();
        double d2 = this.wantedZ - this.mob.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        return !(Math.abs(d1) > (double)1.0E-5f) && !(Math.abs(d3) > (double)1.0E-5f) ? Optional.empty() : Optional.of(Float.valueOf((float)(-(Mth.atan2(d1, d3) * 57.2957763671875))));
    }

    protected Optional<Float> getYRotD() {
        double d0 = this.wantedX - this.mob.getX();
        double d1 = this.wantedZ - this.mob.getZ();
        return !(Math.abs(d1) > (double)1.0E-5f) && !(Math.abs(d0) > (double)1.0E-5f) ? Optional.empty() : Optional.of(Float.valueOf((float)(Mth.atan2(d1, d0) * 57.2957763671875) - 90.0f));
    }

    protected float rotateTowards(float pFrom, float pTo, float pMaxDelta) {
        float f = Mth.degreesDifference(pFrom, pTo);
        float f1 = Mth.clamp(f, -pMaxDelta, pMaxDelta);
        return pFrom + f1;
    }

    private static double getWantedY(Entity pEntity) {
        return pEntity instanceof LivingEntity ? pEntity.getEyeY() : (pEntity.getBoundingBox().minY + pEntity.getBoundingBox().maxY) / 2.0;
    }
}

