/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.gossip;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.DoublePredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.SerializableUUID;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.gossip.GossipType;

public class GossipContainer {
    public static final int DISCARD_THRESHOLD = 2;
    private final Map<UUID, EntityGossips> gossips = Maps.newHashMap();

    @VisibleForDebug
    public Map<UUID, Object2IntMap<GossipType>> getGossipEntries() {
        HashMap map = Maps.newHashMap();
        this.gossips.keySet().forEach(p_148167_ -> {
            EntityGossips gossipcontainer$entitygossips = this.gossips.get(p_148167_);
            map.put(p_148167_, gossipcontainer$entitygossips.entries);
        });
        return map;
    }

    public void decay() {
        Iterator<EntityGossips> iterator = this.gossips.values().iterator();
        while (iterator.hasNext()) {
            EntityGossips gossipcontainer$entitygossips = iterator.next();
            gossipcontainer$entitygossips.decay();
            if (!gossipcontainer$entitygossips.isEmpty()) continue;
            iterator.remove();
        }
    }

    private Stream<GossipEntry> unpack() {
        return this.gossips.entrySet().stream().flatMap(p_26185_ -> ((EntityGossips)p_26185_.getValue()).unpack((UUID)p_26185_.getKey()));
    }

    private Collection<GossipEntry> selectGossipsForTransfer(Random pRand, int pGossipAmount) {
        List list = this.unpack().collect(Collectors.toList());
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        int[] aint = new int[list.size()];
        int i = 0;
        int j = 0;
        while (j < list.size()) {
            GossipEntry gossipcontainer$gossipentry = (GossipEntry)list.get(j);
            aint[j] = (i += Math.abs(gossipcontainer$gossipentry.weightedValue())) - 1;
            ++j;
        }
        Set set = Sets.newIdentityHashSet();
        int i1 = 0;
        while (i1 < pGossipAmount) {
            int k = pRand.nextInt(i);
            int l = Arrays.binarySearch(aint, k);
            set.add((GossipEntry)list.get(l < 0 ? -l - 1 : l));
            ++i1;
        }
        return set;
    }

    private EntityGossips getOrCreate(UUID pIdentifier) {
        return this.gossips.computeIfAbsent(pIdentifier, p_26202_ -> new EntityGossips());
    }

    public void transferFrom(GossipContainer pGossip, Random pRand, int pGossipAmount) {
        Collection<GossipEntry> collection = pGossip.selectGossipsForTransfer(pRand, pGossipAmount);
        collection.forEach(p_26200_ -> {
            int i = p_26200_.value - p_26200_.type.decayPerTransfer;
            if (i >= 2) {
                this.getOrCreate((UUID)p_26200_.target).entries.mergeInt((Object)p_26200_.type, i, GossipContainer::mergeValuesForTransfer);
            }
        });
    }

    public int getReputation(UUID pIdentifier, Predicate<GossipType> pGossip) {
        EntityGossips gossipcontainer$entitygossips = this.gossips.get(pIdentifier);
        return gossipcontainer$entitygossips != null ? gossipcontainer$entitygossips.weightedValue(pGossip) : 0;
    }

    public long getCountForType(GossipType pGossipType, DoublePredicate pGossipPredicate) {
        return this.gossips.values().stream().filter(p_148174_ -> pGossipPredicate.test(p_148174_.entries.getOrDefault((Object)pGossipType, 0) * gossipType.weight)).count();
    }

    public void add(UUID pIdentifier, GossipType pGossipType, int pGossipValue) {
        EntityGossips gossipcontainer$entitygossips = this.getOrCreate(pIdentifier);
        gossipcontainer$entitygossips.entries.mergeInt((Object)pGossipType, pGossipValue, (p_186096_, p_186097_) -> this.mergeValuesForAddition(pGossipType, p_186096_, p_186097_));
        gossipcontainer$entitygossips.makeSureValueIsntTooLowOrTooHigh(pGossipType);
        if (gossipcontainer$entitygossips.isEmpty()) {
            this.gossips.remove(pIdentifier);
        }
    }

    public void remove(UUID pIdentifier, GossipType pGossipType, int pGossipValue) {
        this.add(pIdentifier, pGossipType, -pGossipValue);
    }

    public void remove(UUID pIdentifier, GossipType pGossipType) {
        EntityGossips gossipcontainer$entitygossips = this.gossips.get(pIdentifier);
        if (gossipcontainer$entitygossips != null) {
            gossipcontainer$entitygossips.remove(pGossipType);
            if (gossipcontainer$entitygossips.isEmpty()) {
                this.gossips.remove(pIdentifier);
            }
        }
    }

    public void remove(GossipType pGossipType) {
        Iterator<EntityGossips> iterator = this.gossips.values().iterator();
        while (iterator.hasNext()) {
            EntityGossips gossipcontainer$entitygossips = iterator.next();
            gossipcontainer$entitygossips.remove(pGossipType);
            if (!gossipcontainer$entitygossips.isEmpty()) continue;
            iterator.remove();
        }
    }

    public <T> Dynamic<T> store(DynamicOps<T> pDynamic) {
        return new Dynamic(pDynamic, pDynamic.createList(this.unpack().map(p_26183_ -> p_26183_.store(pDynamic)).map(Dynamic::getValue)));
    }

    public void update(Dynamic<?> pDynamic) {
        pDynamic.asStream().map(GossipEntry::load).flatMap(p_26176_ -> p_26176_.result().stream()).forEach(p_26162_ -> this.getOrCreate((UUID)p_26162_.target).entries.put((Object)p_26162_.type, p_26162_.value));
    }

    private static int mergeValuesForTransfer(int p_26159_, int p_26160_) {
        return Math.max(p_26159_, p_26160_);
    }

    private int mergeValuesForAddition(GossipType pGossipType, int pExisting, int pAdditive) {
        int i = pExisting + pAdditive;
        return i > pGossipType.max ? Math.max(pGossipType.max, pExisting) : i;
    }

    static class EntityGossips {
        final Object2IntMap<GossipType> entries = new Object2IntOpenHashMap();

        EntityGossips() {
        }

        public int weightedValue(Predicate<GossipType> pGossipType) {
            return this.entries.object2IntEntrySet().stream().filter(p_26224_ -> pGossipType.test((GossipType)((Object)((Object)p_26224_.getKey())))).mapToInt(p_26214_ -> p_26214_.getIntValue() * ((GossipType)((Object)((Object)p_26214_.getKey()))).weight).sum();
        }

        public Stream<GossipEntry> unpack(UUID pIdentifier) {
            return this.entries.object2IntEntrySet().stream().map(p_26219_ -> new GossipEntry(pIdentifier, (GossipType)((Object)((Object)p_26219_.getKey())), p_26219_.getIntValue()));
        }

        public void decay() {
            ObjectIterator objectiterator = this.entries.object2IntEntrySet().iterator();
            while (objectiterator.hasNext()) {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)objectiterator.next();
                int i = entry.getIntValue() - ((GossipType)((Object)entry.getKey())).decayPerDay;
                if (i < 2) {
                    objectiterator.remove();
                    continue;
                }
                entry.setValue(i);
            }
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public void makeSureValueIsntTooLowOrTooHigh(GossipType pGossipType) {
            int i = this.entries.getInt((Object)pGossipType);
            if (i > pGossipType.max) {
                this.entries.put((Object)pGossipType, pGossipType.max);
            }
            if (i < 2) {
                this.remove(pGossipType);
            }
        }

        public void remove(GossipType pGossipType) {
            this.entries.removeInt((Object)pGossipType);
        }
    }

    static class GossipEntry {
        public static final String TAG_TARGET = "Target";
        public static final String TAG_TYPE = "Type";
        public static final String TAG_VALUE = "Value";
        public final UUID target;
        public final GossipType type;
        public final int value;

        public GossipEntry(UUID p_26232_, GossipType p_26233_, int p_26234_) {
            this.target = p_26232_;
            this.type = p_26233_;
            this.value = p_26234_;
        }

        public int weightedValue() {
            return this.value * this.type.weight;
        }

        public String toString() {
            return "GossipEntry{target=" + this.target + ", type=" + (Object)((Object)this.type) + ", value=" + this.value + "}";
        }

        public <T> Dynamic<T> store(DynamicOps<T> pDynamic) {
            return new Dynamic(pDynamic, pDynamic.createMap((Map)ImmutableMap.of((Object)pDynamic.createString(TAG_TARGET), SerializableUUID.CODEC.encodeStart(pDynamic, (Object)this.target).result().orElseThrow(RuntimeException::new), (Object)pDynamic.createString(TAG_TYPE), (Object)pDynamic.createString(this.type.id), (Object)pDynamic.createString(TAG_VALUE), (Object)pDynamic.createInt(this.value))));
        }

        public static DataResult<GossipEntry> load(Dynamic<?> pDynamic) {
            return DataResult.unbox((App)DataResult.instance().group((App)pDynamic.get(TAG_TARGET).read(SerializableUUID.CODEC), (App)pDynamic.get(TAG_TYPE).asString().map(GossipType::byId), (App)pDynamic.get(TAG_VALUE).asNumber().map(Number::intValue)).apply((Applicative)DataResult.instance(), GossipEntry::new));
        }
    }
}

