/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.navigation;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class GroundPathNavigation
extends PathNavigation {
    private boolean avoidSun;

    public GroundPathNavigation(Mob p_26448_, Level p_26449_) {
        super(p_26448_, p_26449_);
    }

    @Override
    protected PathFinder createPathFinder(int p_26453_) {
        this.nodeEvaluator = new WalkNodeEvaluator();
        this.nodeEvaluator.setCanPassDoors(true);
        return new PathFinder(this.nodeEvaluator, p_26453_);
    }

    @Override
    protected boolean canUpdatePath() {
        return this.mob.isOnGround() || this.isInLiquid() || this.mob.isPassenger();
    }

    @Override
    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.getX(), this.getSurfaceY(), this.mob.getZ());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Path createPath(BlockPos pPos, int pAccuracy) {
        block4: {
            if (!this.level.getBlockState(pPos).isAir()) break block4;
            blockpos = pPos.below();
            while (blockpos.getY() > this.level.getMinBuildHeight() && this.level.getBlockState(blockpos).isAir()) {
                blockpos = blockpos.below();
            }
            if (blockpos.getY() <= this.level.getMinBuildHeight()) ** GOTO lbl9
            return super.createPath(blockpos.above(), pAccuracy);
lbl-1000:
            // 1 sources

            {
                blockpos = blockpos.above();
lbl9:
                // 2 sources

                ** while (blockpos.getY() < this.level.getMaxBuildHeight() && this.level.getBlockState((BlockPos)blockpos).isAir())
            }
lbl10:
            // 1 sources

            pPos = blockpos;
        }
        if (!this.level.getBlockState(pPos).getMaterial().isSolid()) {
            return super.createPath(pPos, pAccuracy);
        }
        blockpos1 = pPos.above();
        while (blockpos1.getY() < this.level.getMaxBuildHeight() && this.level.getBlockState(blockpos1).getMaterial().isSolid()) {
            blockpos1 = blockpos1.above();
        }
        return super.createPath(blockpos1, pAccuracy);
    }

    @Override
    public Path createPath(Entity pPos, int pAccuracy) {
        return this.createPath(pPos.blockPosition(), pAccuracy);
    }

    private int getSurfaceY() {
        if (this.mob.isInWater() && this.canFloat()) {
            int i = this.mob.getBlockY();
            BlockState blockstate = this.level.getBlockState(new BlockPos(this.mob.getX(), (double)i, this.mob.getZ()));
            int j = 0;
            while (blockstate.is(Blocks.WATER)) {
                blockstate = this.level.getBlockState(new BlockPos(this.mob.getX(), (double)(++i), this.mob.getZ()));
                if (++j <= 16) continue;
                return this.mob.getBlockY();
            }
            return i;
        }
        return Mth.floor(this.mob.getY() + 0.5);
    }

    @Override
    protected void trimPath() {
        super.trimPath();
        if (this.avoidSun) {
            if (this.level.canSeeSky(new BlockPos(this.mob.getX(), this.mob.getY() + 0.5, this.mob.getZ()))) {
                return;
            }
            int i = 0;
            while (i < this.path.getNodeCount()) {
                Node node = this.path.getNode(i);
                if (this.level.canSeeSky(new BlockPos(node.x, node.y, node.z))) {
                    this.path.truncateNodes(i);
                    return;
                }
                ++i;
            }
        }
    }

    protected boolean hasValidPathType(BlockPathTypes p_26467_) {
        if (p_26467_ == BlockPathTypes.WATER) {
            return false;
        }
        if (p_26467_ == BlockPathTypes.LAVA) {
            return false;
        }
        return p_26467_ != BlockPathTypes.OPEN;
    }

    public void setCanOpenDoors(boolean pCanBreakDoors) {
        this.nodeEvaluator.setCanOpenDoors(pCanBreakDoors);
    }

    public boolean canPassDoors() {
        return this.nodeEvaluator.canPassDoors();
    }

    public void setCanPassDoors(boolean p_148215_) {
        this.nodeEvaluator.setCanPassDoors(p_148215_);
    }

    public boolean canOpenDoors() {
        return this.nodeEvaluator.canPassDoors();
    }

    public void setAvoidSun(boolean pAvoidSun) {
        this.avoidSun = pAvoidSun;
    }
}

