/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;

public class SecondaryPoiSensor
extends Sensor<Villager> {
    private static final int SCAN_RATE = 40;

    public SecondaryPoiSensor() {
        super(40);
    }

    @Override
    protected void doTick(ServerLevel pLevel, Villager pEntity) {
        ResourceKey<Level> resourcekey = pLevel.dimension();
        BlockPos blockpos = pEntity.blockPosition();
        ArrayList list = Lists.newArrayList();
        int i = 4;
        int j = -4;
        while (j <= 4) {
            int k = -2;
            while (k <= 2) {
                int l = -4;
                while (l <= 4) {
                    BlockPos blockpos1 = blockpos.offset(j, k, l);
                    if (pEntity.getVillagerData().getProfession().getSecondaryPoi().contains((Object)pLevel.getBlockState(blockpos1).getBlock())) {
                        list.add(GlobalPos.of(resourcekey, blockpos1));
                    }
                    ++l;
                }
                ++k;
            }
            ++j;
        }
        Brain<Villager> brain = pEntity.getBrain();
        if (!list.isEmpty()) {
            brain.setMemory(MemoryModuleType.SECONDARY_JOB_SITE, list);
        } else {
            brain.eraseMemory(MemoryModuleType.SECONDARY_JOB_SITE);
        }
    }

    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.SECONDARY_JOB_SITE);
    }
}

