/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.util;

import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.phys.Vec3;

public class LandRandomPos {
    @Nullable
    public static Vec3 getPos(PathfinderMob pMob, int pRadius, int pVerticalRange) {
        return LandRandomPos.getPos(pMob, pRadius, pVerticalRange, pMob::getWalkTargetValue);
    }

    @Nullable
    public static Vec3 getPos(PathfinderMob pMob, int pRadius, int pYRange, ToDoubleFunction<BlockPos> pToDoubleFunction) {
        boolean flag = GoalUtils.mobRestricted(pMob, pRadius);
        return RandomPos.generateRandomPos(() -> {
            BlockPos blockpos = RandomPos.generateRandomDirection(pMob.getRandom(), pRadius, pYRange);
            BlockPos blockpos1 = LandRandomPos.generateRandomPosTowardDirection(pMob, pRadius, flag, blockpos);
            return blockpos1 == null ? null : LandRandomPos.movePosUpOutOfSolid(pMob, blockpos1);
        }, pToDoubleFunction);
    }

    @Nullable
    public static Vec3 getPosTowards(PathfinderMob pMob, int pRadius, int pYRange, Vec3 pVectorPosition) {
        Vec3 vec3 = pVectorPosition.subtract(pMob.getX(), pMob.getY(), pMob.getZ());
        boolean flag = GoalUtils.mobRestricted(pMob, pRadius);
        return LandRandomPos.getPosInDirection(pMob, pRadius, pYRange, vec3, flag);
    }

    @Nullable
    public static Vec3 getPosAway(PathfinderMob pMob, int pRadius, int pYRange, Vec3 pVectorPosition) {
        Vec3 vec3 = pMob.position().subtract(pVectorPosition);
        boolean flag = GoalUtils.mobRestricted(pMob, pRadius);
        return LandRandomPos.getPosInDirection(pMob, pRadius, pYRange, vec3, flag);
    }

    @Nullable
    private static Vec3 getPosInDirection(PathfinderMob pMob, int pRadius, int pYRange, Vec3 pVectorPosition, boolean pShortCircuit) {
        return RandomPos.generateRandomPos(pMob, () -> {
            BlockPos blockpos = RandomPos.generateRandomDirectionWithinRadians(pMob.getRandom(), pRadius, pYRange, 0, vec3.x, vec3.z, 1.5707963705062866);
            if (blockpos == null) {
                return null;
            }
            BlockPos blockpos1 = LandRandomPos.generateRandomPosTowardDirection(pMob, pRadius, pShortCircuit, blockpos);
            return blockpos1 == null ? null : LandRandomPos.movePosUpOutOfSolid(pMob, blockpos1);
        });
    }

    @Nullable
    public static BlockPos movePosUpOutOfSolid(PathfinderMob pMob, BlockPos pPos) {
        return !GoalUtils.isWater(pMob, pPos = RandomPos.moveUpOutOfSolid(pPos, pMob.level.getMaxBuildHeight(), p_148534_ -> GoalUtils.isSolid(pMob, p_148534_))) && !GoalUtils.hasMalus(pMob, pPos) ? pPos : null;
    }

    @Nullable
    public static BlockPos generateRandomPosTowardDirection(PathfinderMob pMob, int pRadius, boolean pShortCircuit, BlockPos pPos) {
        BlockPos blockpos = RandomPos.generateRandomPosTowardDirection(pMob, pRadius, pMob.getRandom(), pPos);
        return !GoalUtils.isOutsideLimits(blockpos, pMob) && !GoalUtils.isRestricted(pShortCircuit, pMob, blockpos) && !GoalUtils.isNotStable(pMob.getNavigation(), blockpos) ? blockpos : null;
    }
}

