/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class VillageSiege
implements CustomSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    private boolean hasSetupSiege;
    private State siegeState = State.SIEGE_DONE;
    private int zombiesToSpawn;
    private int nextSpawnTime;
    private int spawnX;
    private int spawnY;
    private int spawnZ;

    @Override
    public int tick(ServerLevel pLevel, boolean pSpawnHostiles, boolean pSpawnPassives) {
        if (!pLevel.isDay() && pSpawnHostiles) {
            float f = pLevel.getTimeOfDay(0.0f);
            if ((double)f == 0.5) {
                State state = this.siegeState = pLevel.random.nextInt(10) == 0 ? State.SIEGE_TONIGHT : State.SIEGE_DONE;
            }
            if (this.siegeState == State.SIEGE_DONE) {
                return 0;
            }
            if (!this.hasSetupSiege) {
                if (!this.tryToSetupSiege(pLevel)) {
                    return 0;
                }
                this.hasSetupSiege = true;
            }
            if (this.nextSpawnTime > 0) {
                --this.nextSpawnTime;
                return 0;
            }
            this.nextSpawnTime = 2;
            if (this.zombiesToSpawn > 0) {
                this.trySpawn(pLevel);
                --this.zombiesToSpawn;
            } else {
                this.siegeState = State.SIEGE_DONE;
            }
            return 1;
        }
        this.siegeState = State.SIEGE_DONE;
        this.hasSetupSiege = false;
        return 0;
    }

    private boolean tryToSetupSiege(ServerLevel pLevel) {
        for (Player player : pLevel.players()) {
            BlockPos blockpos;
            if (player.isSpectator() || !pLevel.isVillage(blockpos = player.blockPosition()) || Biome.getBiomeCategory(pLevel.getBiome(blockpos)) == Biome.BiomeCategory.MUSHROOM) continue;
            int i = 0;
            while (i < 10) {
                float f = pLevel.random.nextFloat() * ((float)Math.PI * 2);
                this.spawnX = blockpos.getX() + Mth.floor(Mth.cos(f) * 32.0f);
                this.spawnY = blockpos.getY();
                this.spawnZ = blockpos.getZ() + Mth.floor(Mth.sin(f) * 32.0f);
                if (this.findRandomSpawnPos(pLevel, new BlockPos(this.spawnX, this.spawnY, this.spawnZ)) != null) {
                    this.nextSpawnTime = 0;
                    this.zombiesToSpawn = 20;
                    break;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private void trySpawn(ServerLevel pLevel) {
        Vec3 vec3 = this.findRandomSpawnPos(pLevel, new BlockPos(this.spawnX, this.spawnY, this.spawnZ));
        if (vec3 != null) {
            Zombie zombie;
            try {
                zombie = new Zombie(pLevel);
                zombie.finalizeSpawn(pLevel, pLevel.getCurrentDifficultyAt(zombie.blockPosition()), MobSpawnType.EVENT, null, null);
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to create zombie for village siege at {}", (Object)vec3, (Object)exception);
                return;
            }
            zombie.moveTo(vec3.x, vec3.y, vec3.z, pLevel.random.nextFloat() * 360.0f, 0.0f);
            pLevel.addFreshEntityWithPassengers(zombie);
        }
    }

    @Nullable
    private Vec3 findRandomSpawnPos(ServerLevel pLevel, BlockPos pPos) {
        int i = 0;
        while (i < 10) {
            int k;
            int l;
            int j = pPos.getX() + pLevel.random.nextInt(16) - 8;
            BlockPos blockpos = new BlockPos(j, l = pLevel.getHeight(Heightmap.Types.WORLD_SURFACE, j, k = pPos.getZ() + pLevel.random.nextInt(16) - 8), k);
            if (pLevel.isVillage(blockpos) && Monster.checkMonsterSpawnRules(EntityType.ZOMBIE, pLevel, MobSpawnType.EVENT, blockpos, pLevel.random)) {
                return Vec3.atBottomCenterOf(blockpos);
            }
            ++i;
        }
        return null;
    }

    static enum State {
        SIEGE_CAN_ACTIVATE,
        SIEGE_TONIGHT,
        SIEGE_DONE;

    }
}

