/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.village.poi.PoiType;

public class PoiRecord {
    private final BlockPos pos;
    private final PoiType poiType;
    private int freeTickets;
    private final Runnable setDirty;

    public static Codec<PoiRecord> codec(Runnable p_27243_) {
        return RecordCodecBuilder.create(p_27246_ -> p_27246_.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(p_148673_ -> p_148673_.pos), (App)Registry.POINT_OF_INTEREST_TYPE.byNameCodec().fieldOf("type").forGetter(p_148671_ -> p_148671_.poiType), (App)Codec.INT.fieldOf("free_tickets").orElse((Object)0).forGetter(p_148669_ -> p_148669_.freeTickets), (App)RecordCodecBuilder.point((Object)p_27243_)).apply((Applicative)p_27246_, PoiRecord::new));
    }

    private PoiRecord(BlockPos p_27232_, PoiType p_27233_, int p_27234_, Runnable p_27235_) {
        this.pos = p_27232_.immutable();
        this.poiType = p_27233_;
        this.freeTickets = p_27234_;
        this.setDirty = p_27235_;
    }

    public PoiRecord(BlockPos p_27237_, PoiType p_27238_, Runnable p_27239_) {
        this(p_27237_, p_27238_, p_27238_.getMaxTickets(), p_27239_);
    }

    @Deprecated
    @VisibleForDebug
    public int getFreeTickets() {
        return this.freeTickets;
    }

    protected boolean acquireTicket() {
        if (this.freeTickets <= 0) {
            return false;
        }
        --this.freeTickets;
        this.setDirty.run();
        return true;
    }

    protected boolean releaseTicket() {
        if (this.freeTickets >= this.poiType.getMaxTickets()) {
            return false;
        }
        ++this.freeTickets;
        this.setDirty.run();
        return true;
    }

    public boolean hasSpace() {
        return this.freeTickets > 0;
    }

    public boolean isOccupied() {
        return this.freeTickets != this.poiType.getMaxTickets();
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public PoiType getPoiType() {
        return this.poiType;
    }

    public boolean equals(Object p_27256_) {
        if (this == p_27256_) {
            return true;
        }
        return p_27256_ != null && this.getClass() == p_27256_.getClass() ? Objects.equals(this.pos, ((PoiRecord)p_27256_).pos) : false;
    }

    public int hashCode() {
        return this.pos.hashCode();
    }
}

