/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import org.slf4j.Logger;

public class PoiSection {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Short2ObjectMap<PoiRecord> records = new Short2ObjectOpenHashMap();
    private final Map<PoiType, Set<PoiRecord>> byType = Maps.newHashMap();
    private final Runnable setDirty;
    private boolean isValid;

    public static Codec<PoiSection> codec(Runnable p_27296_) {
        return RecordCodecBuilder.create(p_27299_ -> p_27299_.group((App)RecordCodecBuilder.point((Object)p_27296_), (App)Codec.BOOL.optionalFieldOf("Valid", (Object)false).forGetter(p_148681_ -> p_148681_.isValid), (App)PoiRecord.codec(p_27296_).listOf().fieldOf("Records").forGetter(p_148675_ -> ImmutableList.copyOf((Collection)p_148675_.records.values()))).apply((Applicative)p_27299_, PoiSection::new)).orElseGet(Util.prefix("Failed to read POI section: ", arg_0 -> ((Logger)LOGGER).error(arg_0)), () -> new PoiSection(p_27296_, false, (List<PoiRecord>)ImmutableList.of()));
    }

    public PoiSection(Runnable p_27267_) {
        this(p_27267_, true, (List<PoiRecord>)ImmutableList.of());
    }

    private PoiSection(Runnable p_27269_, boolean p_27270_, List<PoiRecord> p_27271_) {
        this.setDirty = p_27269_;
        this.isValid = p_27270_;
        p_27271_.forEach(this::add);
    }

    public Stream<PoiRecord> getRecords(Predicate<PoiType> pTypePredicate, PoiManager.Occupancy pStatus) {
        return this.byType.entrySet().stream().filter(p_27309_ -> pTypePredicate.test((PoiType)p_27309_.getKey())).flatMap(p_27301_ -> ((Set)p_27301_.getValue()).stream()).filter(pStatus.getTest());
    }

    public void add(BlockPos pPos, PoiType pType) {
        if (this.add(new PoiRecord(pPos, pType, this.setDirty))) {
            LOGGER.debug("Added POI of type {} @ {}", (Object)pType, (Object)pPos);
            this.setDirty.run();
        }
    }

    private boolean add(PoiRecord p_27274_) {
        BlockPos blockpos = p_27274_.getPos();
        PoiType poitype = p_27274_.getPoiType();
        short short1 = SectionPos.sectionRelativePos(blockpos);
        PoiRecord poirecord = (PoiRecord)this.records.get(short1);
        if (poirecord != null) {
            if (poitype.equals(poirecord.getPoiType())) {
                return false;
            }
            Util.logAndPauseIfInIde("POI data mismatch: already registered at " + blockpos);
        }
        this.records.put(short1, (Object)p_27274_);
        this.byType.computeIfAbsent(poitype, p_201961_ -> Sets.newHashSet()).add(p_27274_);
        return true;
    }

    public void remove(BlockPos pPos) {
        PoiRecord poirecord = (PoiRecord)this.records.remove(SectionPos.sectionRelativePos(pPos));
        if (poirecord == null) {
            LOGGER.error("POI data mismatch: never registered at {}", (Object)pPos);
        } else {
            this.byType.get(poirecord.getPoiType()).remove(poirecord);
            LOGGER.debug("Removed POI of type {} @ {}", LogUtils.defer(poirecord::getPoiType), LogUtils.defer(poirecord::getPos));
            this.setDirty.run();
        }
    }

    @Deprecated
    @VisibleForDebug
    public int getFreeTickets(BlockPos p_148683_) {
        return this.getPoiRecord(p_148683_).map(PoiRecord::getFreeTickets).orElse(0);
    }

    public boolean release(BlockPos pPos) {
        PoiRecord poirecord = (PoiRecord)this.records.get(SectionPos.sectionRelativePos(pPos));
        if (poirecord == null) {
            throw Util.pauseInIde(new IllegalStateException("POI never registered at " + pPos));
        }
        boolean flag = poirecord.releaseTicket();
        this.setDirty.run();
        return flag;
    }

    public boolean exists(BlockPos pPos, Predicate<PoiType> pTypePredicate) {
        return this.getType(pPos).filter(pTypePredicate).isPresent();
    }

    public Optional<PoiType> getType(BlockPos pPos) {
        return this.getPoiRecord(pPos).map(PoiRecord::getPoiType);
    }

    private Optional<PoiRecord> getPoiRecord(BlockPos p_148685_) {
        return Optional.ofNullable((PoiRecord)this.records.get(SectionPos.sectionRelativePos(p_148685_)));
    }

    public void refresh(Consumer<BiConsumer<BlockPos, PoiType>> pPosToTypeConsumer) {
        if (!this.isValid) {
            Short2ObjectOpenHashMap short2objectmap = new Short2ObjectOpenHashMap(this.records);
            this.clear();
            pPosToTypeConsumer.accept((arg_0, arg_1) -> this.lambda$14((Short2ObjectMap)short2objectmap, arg_0, arg_1));
            this.isValid = true;
            this.setDirty.run();
        }
    }

    private void clear() {
        this.records.clear();
        this.byType.clear();
    }

    boolean isValid() {
        return this.isValid;
    }

    private /* synthetic */ void lambda$14(Short2ObjectMap short2ObjectMap, BlockPos p_201968_, PoiType p_201969_) {
        short short1 = SectionPos.sectionRelativePos(p_201968_);
        PoiRecord poirecord = (PoiRecord)short2ObjectMap.computeIfAbsent(short1, p_201965_ -> new PoiRecord(p_201968_, p_201969_, this.setDirty));
        this.add(poirecord);
    }
}

