/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;

public class PoiType {
    private static final Supplier<Set<PoiType>> ALL_JOB_POI_TYPES = Suppliers.memoize(() -> Registry.VILLAGER_PROFESSION.stream().map(VillagerProfession::getJobPoiType).collect(Collectors.toSet()));
    public static final Predicate<PoiType> ALL_JOBS = p_27399_ -> ALL_JOB_POI_TYPES.get().contains(p_27399_);
    public static final Predicate<PoiType> ALL = p_27394_ -> true;
    private static final Set<BlockState> BEDS = (Set)ImmutableList.of((Object)Blocks.RED_BED, (Object)Blocks.BLACK_BED, (Object)Blocks.BLUE_BED, (Object)Blocks.BROWN_BED, (Object)Blocks.CYAN_BED, (Object)Blocks.GRAY_BED, (Object)Blocks.GREEN_BED, (Object)Blocks.LIGHT_BLUE_BED, (Object)Blocks.LIGHT_GRAY_BED, (Object)Blocks.LIME_BED, (Object)Blocks.MAGENTA_BED, (Object)Blocks.ORANGE_BED, (Object[])new Block[]{Blocks.PINK_BED, Blocks.PURPLE_BED, Blocks.WHITE_BED, Blocks.YELLOW_BED}).stream().flatMap(p_27389_ -> p_27389_.getStateDefinition().getPossibleStates().stream()).filter(p_27396_ -> p_27396_.getValue(BedBlock.PART) == BedPart.HEAD).collect(ImmutableSet.toImmutableSet());
    private static final Set<BlockState> CAULDRONS = (Set)ImmutableList.of((Object)Blocks.CAULDRON, (Object)Blocks.LAVA_CAULDRON, (Object)Blocks.WATER_CAULDRON, (Object)Blocks.POWDER_SNOW_CAULDRON).stream().flatMap(p_148697_ -> p_148697_.getStateDefinition().getPossibleStates().stream()).collect(ImmutableSet.toImmutableSet());
    private static final Map<BlockState, PoiType> TYPE_BY_STATE = Maps.newHashMap();
    public static final PoiType UNEMPLOYED = PoiType.register("unemployed", (Set<BlockState>)ImmutableSet.of(), 1, ALL_JOBS, 1);
    public static final PoiType ARMORER = PoiType.register("armorer", PoiType.getBlockStates(Blocks.BLAST_FURNACE), 1, 1);
    public static final PoiType BUTCHER = PoiType.register("butcher", PoiType.getBlockStates(Blocks.SMOKER), 1, 1);
    public static final PoiType CARTOGRAPHER = PoiType.register("cartographer", PoiType.getBlockStates(Blocks.CARTOGRAPHY_TABLE), 1, 1);
    public static final PoiType CLERIC = PoiType.register("cleric", PoiType.getBlockStates(Blocks.BREWING_STAND), 1, 1);
    public static final PoiType FARMER = PoiType.register("farmer", PoiType.getBlockStates(Blocks.COMPOSTER), 1, 1);
    public static final PoiType FISHERMAN = PoiType.register("fisherman", PoiType.getBlockStates(Blocks.BARREL), 1, 1);
    public static final PoiType FLETCHER = PoiType.register("fletcher", PoiType.getBlockStates(Blocks.FLETCHING_TABLE), 1, 1);
    public static final PoiType LEATHERWORKER = PoiType.register("leatherworker", CAULDRONS, 1, 1);
    public static final PoiType LIBRARIAN = PoiType.register("librarian", PoiType.getBlockStates(Blocks.LECTERN), 1, 1);
    public static final PoiType MASON = PoiType.register("mason", PoiType.getBlockStates(Blocks.STONECUTTER), 1, 1);
    public static final PoiType NITWIT = PoiType.register("nitwit", (Set<BlockState>)ImmutableSet.of(), 1, 1);
    public static final PoiType SHEPHERD = PoiType.register("shepherd", PoiType.getBlockStates(Blocks.LOOM), 1, 1);
    public static final PoiType TOOLSMITH = PoiType.register("toolsmith", PoiType.getBlockStates(Blocks.SMITHING_TABLE), 1, 1);
    public static final PoiType WEAPONSMITH = PoiType.register("weaponsmith", PoiType.getBlockStates(Blocks.GRINDSTONE), 1, 1);
    public static final PoiType HOME = PoiType.register("home", BEDS, 1, 1);
    public static final PoiType MEETING = PoiType.register("meeting", PoiType.getBlockStates(Blocks.BELL), 32, 6);
    public static final PoiType BEEHIVE = PoiType.register("beehive", PoiType.getBlockStates(Blocks.BEEHIVE), 0, 1);
    public static final PoiType BEE_NEST = PoiType.register("bee_nest", PoiType.getBlockStates(Blocks.BEE_NEST), 0, 1);
    public static final PoiType NETHER_PORTAL = PoiType.register("nether_portal", PoiType.getBlockStates(Blocks.NETHER_PORTAL), 0, 1);
    public static final PoiType LODESTONE = PoiType.register("lodestone", PoiType.getBlockStates(Blocks.LODESTONE), 0, 1);
    public static final PoiType LIGHTNING_ROD = PoiType.register("lightning_rod", PoiType.getBlockStates(Blocks.LIGHTNING_ROD), 0, 1);
    protected static final Set<BlockState> ALL_STATES = new ObjectOpenHashSet(TYPE_BY_STATE.keySet());
    private final String name;
    private final Set<BlockState> matchingStates;
    private final int maxTickets;
    private final Predicate<PoiType> predicate;
    private final int validRange;

    private static Set<BlockState> getBlockStates(Block pBlock) {
        return ImmutableSet.copyOf(pBlock.getStateDefinition().getPossibleStates());
    }

    private PoiType(String p_27362_, Set<BlockState> p_27363_, int p_27364_, Predicate<PoiType> p_27365_, int p_27366_) {
        this.name = p_27362_;
        this.matchingStates = ImmutableSet.copyOf(p_27363_);
        this.maxTickets = p_27364_;
        this.predicate = p_27365_;
        this.validRange = p_27366_;
    }

    private PoiType(String p_27357_, Set<BlockState> p_27358_, int p_27359_, int p_27360_) {
        this.name = p_27357_;
        this.matchingStates = ImmutableSet.copyOf(p_27358_);
        this.maxTickets = p_27359_;
        this.predicate = p_148695_ -> p_148695_ == this;
        this.validRange = p_27360_;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxTickets() {
        return this.maxTickets;
    }

    public Predicate<PoiType> getPredicate() {
        return this.predicate;
    }

    public boolean is(BlockState p_148693_) {
        return this.matchingStates.contains(p_148693_);
    }

    public int getValidRange() {
        return this.validRange;
    }

    public String toString() {
        return this.name;
    }

    private static PoiType register(String pKey, Set<BlockState> pBlockStates, int pMaxFreeTickets, int pValidRange) {
        return PoiType.registerBlockStates(Registry.register(Registry.POINT_OF_INTEREST_TYPE, new ResourceLocation(pKey), new PoiType(pKey, pBlockStates, pMaxFreeTickets, pValidRange)));
    }

    private static PoiType register(String pKey, Set<BlockState> pBlockStates, int pMaxFreeTickets, Predicate<PoiType> pPredicate, int pValidRange) {
        return PoiType.registerBlockStates(Registry.register(Registry.POINT_OF_INTEREST_TYPE, new ResourceLocation(pKey), new PoiType(pKey, pBlockStates, pMaxFreeTickets, pPredicate, pValidRange)));
    }

    private static PoiType registerBlockStates(PoiType pPoit) {
        pPoit.matchingStates.forEach(p_148691_ -> {
            PoiType poitype = TYPE_BY_STATE.put((BlockState)p_148691_, pPoit);
            if (poitype != null) {
                throw Util.pauseInIde(new IllegalStateException(String.format("%s is defined in too many tags", p_148691_)));
            }
        });
        return pPoit;
    }

    public static Optional<PoiType> forState(BlockState pState) {
        return Optional.ofNullable(TYPE_BY_STATE.get(pState));
    }
}

