/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class SkeletonTrapGoal
extends Goal {
    private final SkeletonHorse horse;

    public SkeletonTrapGoal(SkeletonHorse p_30927_) {
        this.horse = p_30927_;
    }

    @Override
    public boolean canUse() {
        return this.horse.level.hasNearbyAlivePlayer(this.horse.getX(), this.horse.getY(), this.horse.getZ(), 10.0);
    }

    @Override
    public void tick() {
        ServerLevel serverlevel = (ServerLevel)this.horse.level;
        DifficultyInstance difficultyinstance = serverlevel.getCurrentDifficultyAt(this.horse.blockPosition());
        this.horse.setTrap(false);
        this.horse.setTamed(true);
        this.horse.setAge(0);
        LightningBolt lightningbolt = EntityType.LIGHTNING_BOLT.create(serverlevel);
        lightningbolt.moveTo(this.horse.getX(), this.horse.getY(), this.horse.getZ());
        lightningbolt.setVisualOnly(true);
        serverlevel.addFreshEntity(lightningbolt);
        Skeleton skeleton = this.createSkeleton(difficultyinstance, this.horse);
        skeleton.startRiding(this.horse);
        serverlevel.addFreshEntityWithPassengers(skeleton);
        int i = 0;
        while (i < 3) {
            AbstractHorse abstracthorse = this.createHorse(difficultyinstance);
            Skeleton skeleton1 = this.createSkeleton(difficultyinstance, abstracthorse);
            skeleton1.startRiding(abstracthorse);
            abstracthorse.push(this.horse.getRandom().nextGaussian() * 0.5, 0.0, this.horse.getRandom().nextGaussian() * 0.5);
            serverlevel.addFreshEntityWithPassengers(abstracthorse);
            ++i;
        }
    }

    private AbstractHorse createHorse(DifficultyInstance pDifficulty) {
        SkeletonHorse skeletonhorse = EntityType.SKELETON_HORSE.create(this.horse.level);
        skeletonhorse.finalizeSpawn((ServerLevel)this.horse.level, pDifficulty, MobSpawnType.TRIGGERED, null, null);
        skeletonhorse.setPos(this.horse.getX(), this.horse.getY(), this.horse.getZ());
        skeletonhorse.invulnerableTime = 60;
        skeletonhorse.setPersistenceRequired();
        skeletonhorse.setTamed(true);
        skeletonhorse.setAge(0);
        return skeletonhorse;
    }

    private Skeleton createSkeleton(DifficultyInstance pDifficulty, AbstractHorse pHorse) {
        Skeleton skeleton = EntityType.SKELETON.create(pHorse.level);
        skeleton.finalizeSpawn((ServerLevel)pHorse.level, pDifficulty, MobSpawnType.TRIGGERED, null, null);
        skeleton.setPos(pHorse.getX(), pHorse.getY(), pHorse.getZ());
        skeleton.invulnerableTime = 60;
        skeleton.setPersistenceRequired();
        if (skeleton.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            skeleton.setItemSlot(EquipmentSlot.HEAD, new ItemStack(Items.IRON_HELMET));
        }
        skeleton.setItemSlot(EquipmentSlot.MAINHAND, EnchantmentHelper.enchantItem(skeleton.getRandom(), this.disenchant(skeleton.getMainHandItem()), (int)(5.0f + pDifficulty.getSpecialMultiplier() * (float)skeleton.getRandom().nextInt(18)), false));
        skeleton.setItemSlot(EquipmentSlot.HEAD, EnchantmentHelper.enchantItem(skeleton.getRandom(), this.disenchant(skeleton.getItemBySlot(EquipmentSlot.HEAD)), (int)(5.0f + pDifficulty.getSpecialMultiplier() * (float)skeleton.getRandom().nextInt(18)), false));
        return skeleton;
    }

    private ItemStack disenchant(ItemStack p_30935_) {
        p_30935_.removeTagKey("Enchantments");
        return p_30935_;
    }
}

