/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddMobPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhaseManager;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class EnderDragon
extends Mob
implements Enemy {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final EntityDataAccessor<Integer> DATA_PHASE = SynchedEntityData.defineId(EnderDragon.class, EntityDataSerializers.INT);
    private static final TargetingConditions CRYSTAL_DESTROY_TARGETING = TargetingConditions.forCombat().range(64.0);
    private static final int GROWL_INTERVAL_MIN = 200;
    private static final int GROWL_INTERVAL_MAX = 400;
    private static final float SITTING_ALLOWED_DAMAGE_PERCENTAGE = 0.25f;
    private static final String DRAGON_DEATH_TIME_KEY = "DragonDeathTime";
    private static final String DRAGON_PHASE_KEY = "DragonPhase";
    public final double[][] positions = new double[64][3];
    public int posPointer = -1;
    private final EnderDragonPart[] subEntities;
    public final EnderDragonPart head;
    private final EnderDragonPart neck;
    private final EnderDragonPart body;
    private final EnderDragonPart tail1;
    private final EnderDragonPart tail2;
    private final EnderDragonPart tail3;
    private final EnderDragonPart wing1;
    private final EnderDragonPart wing2;
    public float oFlapTime;
    public float flapTime;
    public boolean inWall;
    public int dragonDeathTime;
    public float yRotA;
    @Nullable
    public EndCrystal nearestCrystal;
    @Nullable
    private final EndDragonFight dragonFight;
    private final EnderDragonPhaseManager phaseManager;
    private int growlTime = 100;
    private float sittingDamageReceived;
    private final Node[] nodes = new Node[24];
    private final int[] nodeAdjacency = new int[24];
    private final BinaryHeap openSet = new BinaryHeap();

    public EnderDragon(EntityType<? extends EnderDragon> p_31096_, Level p_31097_) {
        super((EntityType<? extends Mob>)EntityType.ENDER_DRAGON, p_31097_);
        this.head = new EnderDragonPart(this, "head", 1.0f, 1.0f);
        this.neck = new EnderDragonPart(this, "neck", 3.0f, 3.0f);
        this.body = new EnderDragonPart(this, "body", 5.0f, 3.0f);
        this.tail1 = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.tail2 = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.tail3 = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.wing1 = new EnderDragonPart(this, "wing", 4.0f, 2.0f);
        this.wing2 = new EnderDragonPart(this, "wing", 4.0f, 2.0f);
        this.subEntities = new EnderDragonPart[]{this.head, this.neck, this.body, this.tail1, this.tail2, this.tail3, this.wing1, this.wing2};
        this.setHealth(this.getMaxHealth());
        this.noPhysics = true;
        this.noCulling = true;
        this.dragonFight = p_31097_ instanceof ServerLevel ? ((ServerLevel)p_31097_).dragonFight() : null;
        this.phaseManager = new EnderDragonPhaseManager(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 200.0);
    }

    @Override
    public boolean isFlapping() {
        float f = Mth.cos(this.flapTime * ((float)Math.PI * 2));
        float f1 = Mth.cos(this.oFlapTime * ((float)Math.PI * 2));
        return f1 <= -0.3f && f >= -0.3f;
    }

    @Override
    public void onFlap() {
        if (this.level.isClientSide && !this.isSilent()) {
            this.level.playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ENDER_DRAGON_FLAP, this.getSoundSource(), 5.0f, 0.8f + this.random.nextFloat() * 0.3f, false);
        }
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.getEntityData().define(DATA_PHASE, EnderDragonPhase.HOVERING.getId());
    }

    public double[] getLatencyPos(int p_31102_, float p_31103_) {
        if (this.isDeadOrDying()) {
            p_31103_ = 0.0f;
        }
        p_31103_ = 1.0f - p_31103_;
        int i = this.posPointer - p_31102_ & 0x3F;
        int j = this.posPointer - p_31102_ - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.positions[i][0];
        double d1 = Mth.wrapDegrees(this.positions[j][0] - d0);
        adouble[0] = d0 + d1 * (double)p_31103_;
        d0 = this.positions[i][1];
        d1 = this.positions[j][1] - d0;
        adouble[1] = d0 + d1 * (double)p_31103_;
        adouble[2] = Mth.lerp((double)p_31103_, this.positions[i][2], this.positions[j][2]);
        return adouble;
    }

    @Override
    public void aiStep() {
        this.processFlappingMovement();
        if (this.level.isClientSide) {
            this.setHealth(this.getHealth());
            if (!this.isSilent() && !this.phaseManager.getCurrentPhase().isSitting() && --this.growlTime < 0) {
                this.level.playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ENDER_DRAGON_GROWL, this.getSoundSource(), 2.5f, 0.8f + this.random.nextFloat() * 0.3f, false);
                this.growlTime = 200 + this.random.nextInt(200);
            }
        }
        this.oFlapTime = this.flapTime;
        if (this.isDeadOrDying()) {
            float f9 = (this.random.nextFloat() - 0.5f) * 8.0f;
            float f10 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float f11 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level.addParticle(ParticleTypes.EXPLOSION, this.getX() + (double)f9, this.getY() + 2.0 + (double)f10, this.getZ() + (double)f11, 0.0, 0.0, 0.0);
        } else {
            this.checkCrystals();
            Vec3 vec3 = this.getDeltaMovement();
            float f = 0.2f / ((float)vec3.horizontalDistance() * 10.0f + 1.0f);
            this.flapTime = this.phaseManager.getCurrentPhase().isSitting() ? (this.flapTime += 0.1f) : (this.inWall ? (this.flapTime += f * 0.5f) : (this.flapTime += (f *= (float)Math.pow(2.0, vec3.y))));
            this.setYRot(Mth.wrapDegrees(this.getYRot()));
            if (this.isNoAi()) {
                this.flapTime = 0.5f;
            } else {
                if (this.posPointer < 0) {
                    int i = 0;
                    while (i < this.positions.length) {
                        this.positions[i][0] = this.getYRot();
                        this.positions[i][1] = this.getY();
                        ++i;
                    }
                }
                if (++this.posPointer == this.positions.length) {
                    this.posPointer = 0;
                }
                this.positions[this.posPointer][0] = this.getYRot();
                this.positions[this.posPointer][1] = this.getY();
                if (this.level.isClientSide) {
                    if (this.lerpSteps > 0) {
                        double d6 = this.getX() + (this.lerpX - this.getX()) / (double)this.lerpSteps;
                        double d0 = this.getY() + (this.lerpY - this.getY()) / (double)this.lerpSteps;
                        double d1 = this.getZ() + (this.lerpZ - this.getZ()) / (double)this.lerpSteps;
                        double d2 = Mth.wrapDegrees(this.lerpYRot - (double)this.getYRot());
                        this.setYRot(this.getYRot() + (float)d2 / (float)this.lerpSteps);
                        this.setXRot(this.getXRot() + (float)(this.lerpXRot - (double)this.getXRot()) / (float)this.lerpSteps);
                        --this.lerpSteps;
                        this.setPos(d6, d0, d1);
                        this.setRot(this.getYRot(), this.getXRot());
                    }
                    this.phaseManager.getCurrentPhase().doClientTick();
                } else {
                    Vec3 vec31;
                    DragonPhaseInstance dragonphaseinstance = this.phaseManager.getCurrentPhase();
                    dragonphaseinstance.doServerTick();
                    if (this.phaseManager.getCurrentPhase() != dragonphaseinstance) {
                        dragonphaseinstance = this.phaseManager.getCurrentPhase();
                        dragonphaseinstance.doServerTick();
                    }
                    if ((vec31 = dragonphaseinstance.getFlyTargetLocation()) != null) {
                        double d7 = vec31.x - this.getX();
                        double d8 = vec31.y - this.getY();
                        double d9 = vec31.z - this.getZ();
                        double d3 = d7 * d7 + d8 * d8 + d9 * d9;
                        float f5 = dragonphaseinstance.getFlySpeed();
                        double d4 = Math.sqrt(d7 * d7 + d9 * d9);
                        if (d4 > 0.0) {
                            d8 = Mth.clamp(d8 / d4, (double)(-f5), (double)f5);
                        }
                        this.setDeltaMovement(this.getDeltaMovement().add(0.0, d8 * 0.01, 0.0));
                        this.setYRot(Mth.wrapDegrees(this.getYRot()));
                        Vec3 vec32 = vec31.subtract(this.getX(), this.getY(), this.getZ()).normalize();
                        Vec3 vec33 = new Vec3(Mth.sin(this.getYRot() * ((float)Math.PI / 180)), this.getDeltaMovement().y, -Mth.cos(this.getYRot() * ((float)Math.PI / 180))).normalize();
                        float f6 = Math.max(((float)vec33.dot(vec32) + 0.5f) / 1.5f, 0.0f);
                        if (Math.abs(d7) > (double)1.0E-5f || Math.abs(d9) > (double)1.0E-5f) {
                            float f7 = Mth.clamp(Mth.wrapDegrees(180.0f - (float)Mth.atan2(d7, d9) * 57.295776f - this.getYRot()), -50.0f, 50.0f);
                            this.yRotA *= 0.8f;
                            this.yRotA += f7 * dragonphaseinstance.getTurnSpeed();
                            this.setYRot(this.getYRot() + this.yRotA * 0.1f);
                        }
                        float f19 = (float)(2.0 / (d3 + 1.0));
                        float f8 = 0.06f;
                        this.moveRelative(0.06f * (f6 * f19 + (1.0f - f19)), new Vec3(0.0, 0.0, -1.0));
                        if (this.inWall) {
                            this.move(MoverType.SELF, this.getDeltaMovement().scale(0.8f));
                        } else {
                            this.move(MoverType.SELF, this.getDeltaMovement());
                        }
                        Vec3 vec34 = this.getDeltaMovement().normalize();
                        double d5 = 0.8 + 0.15 * (vec34.dot(vec33) + 1.0) / 2.0;
                        this.setDeltaMovement(this.getDeltaMovement().multiply(d5, 0.91f, d5));
                    }
                }
                this.yBodyRot = this.getYRot();
                Vec3[] avec3 = new Vec3[this.subEntities.length];
                int j = 0;
                while (j < this.subEntities.length) {
                    avec3[j] = new Vec3(this.subEntities[j].getX(), this.subEntities[j].getY(), this.subEntities[j].getZ());
                    ++j;
                }
                float f12 = (float)(this.getLatencyPos(5, 1.0f)[1] - this.getLatencyPos(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f13 = Mth.cos(f12);
                float f1 = Mth.sin(f12);
                float f14 = this.getYRot() * ((float)Math.PI / 180);
                float f2 = Mth.sin(f14);
                float f15 = Mth.cos(f14);
                this.tickPart(this.body, f2 * 0.5f, 0.0, -f15 * 0.5f);
                this.tickPart(this.wing1, f15 * 4.5f, 2.0, f2 * 4.5f);
                this.tickPart(this.wing2, f15 * -4.5f, 2.0, f2 * -4.5f);
                if (!this.level.isClientSide && this.hurtTime == 0) {
                    this.knockBack(this.level.getEntities(this, this.wing1.getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                    this.knockBack(this.level.getEntities(this, this.wing2.getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                    this.hurt(this.level.getEntities(this, this.head.getBoundingBox().inflate(1.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                    this.hurt(this.level.getEntities(this, this.neck.getBoundingBox().inflate(1.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                }
                float f3 = Mth.sin(this.getYRot() * ((float)Math.PI / 180) - this.yRotA * 0.01f);
                float f16 = Mth.cos(this.getYRot() * ((float)Math.PI / 180) - this.yRotA * 0.01f);
                float f4 = this.getHeadYOffset();
                this.tickPart(this.head, f3 * 6.5f * f13, f4 + f1 * 6.5f, -f16 * 6.5f * f13);
                this.tickPart(this.neck, f3 * 5.5f * f13, f4 + f1 * 5.5f, -f16 * 5.5f * f13);
                double[] adouble = this.getLatencyPos(5, 1.0f);
                int k = 0;
                while (k < 3) {
                    EnderDragonPart enderdragonpart = null;
                    if (k == 0) {
                        enderdragonpart = this.tail1;
                    }
                    if (k == 1) {
                        enderdragonpart = this.tail2;
                    }
                    if (k == 2) {
                        enderdragonpart = this.tail3;
                    }
                    double[] adouble1 = this.getLatencyPos(12 + k * 2, 1.0f);
                    float f17 = this.getYRot() * ((float)Math.PI / 180) + this.rotWrap(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
                    float f18 = Mth.sin(f17);
                    float f20 = Mth.cos(f17);
                    float f21 = 1.5f;
                    float f22 = (float)(k + 1) * 2.0f;
                    this.tickPart(enderdragonpart, -(f2 * 1.5f + f18 * f22) * f13, adouble1[1] - adouble[1] - (double)((f22 + 1.5f) * f1) + 1.5, (f15 * 1.5f + f20 * f22) * f13);
                    ++k;
                }
                if (!this.level.isClientSide) {
                    this.inWall = this.checkWalls(this.head.getBoundingBox()) | this.checkWalls(this.neck.getBoundingBox()) | this.checkWalls(this.body.getBoundingBox());
                    if (this.dragonFight != null) {
                        this.dragonFight.updateDragon(this);
                    }
                }
                int l = 0;
                while (l < this.subEntities.length) {
                    this.subEntities[l].xo = avec3[l].x;
                    this.subEntities[l].yo = avec3[l].y;
                    this.subEntities[l].zo = avec3[l].z;
                    this.subEntities[l].xOld = avec3[l].x;
                    this.subEntities[l].yOld = avec3[l].y;
                    this.subEntities[l].zOld = avec3[l].z;
                    ++l;
                }
            }
        }
    }

    private void tickPart(EnderDragonPart pPart, double pOffsetX, double p_31118_, double pOffsetY) {
        pPart.setPos(this.getX() + pOffsetX, this.getY() + p_31118_, this.getZ() + pOffsetY);
    }

    private float getHeadYOffset() {
        if (this.phaseManager.getCurrentPhase().isSitting()) {
            return -1.0f;
        }
        double[] adouble = this.getLatencyPos(5, 1.0f);
        double[] adouble1 = this.getLatencyPos(0, 1.0f);
        return (float)(adouble[1] - adouble1[1]);
    }

    private void checkCrystals() {
        if (this.nearestCrystal != null) {
            if (this.nearestCrystal.isRemoved()) {
                this.nearestCrystal = null;
            } else if (this.tickCount % 10 == 0 && this.getHealth() < this.getMaxHealth()) {
                this.setHealth(this.getHealth() + 1.0f);
            }
        }
        if (this.random.nextInt(10) == 0) {
            List<EndCrystal> list = this.level.getEntitiesOfClass(EndCrystal.class, this.getBoundingBox().inflate(32.0));
            EndCrystal endcrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EndCrystal endcrystal1 : list) {
                double d1 = endcrystal1.distanceToSqr(this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                endcrystal = endcrystal1;
            }
            this.nearestCrystal = endcrystal;
        }
    }

    private void knockBack(List<Entity> pEntities) {
        double d0 = (this.body.getBoundingBox().minX + this.body.getBoundingBox().maxX) / 2.0;
        double d1 = (this.body.getBoundingBox().minZ + this.body.getBoundingBox().maxZ) / 2.0;
        for (Entity entity : pEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            double d2 = entity.getX() - d0;
            double d3 = entity.getZ() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.push(d2 / d4 * 4.0, 0.2f, d3 / d4 * 4.0);
            if (this.phaseManager.getCurrentPhase().isSitting() || ((LivingEntity)entity).getLastHurtByMobTimestamp() >= entity.tickCount - 2) continue;
            entity.hurt(DamageSource.mobAttack(this), 5.0f);
            this.doEnchantDamageEffects(this, entity);
        }
    }

    private void hurt(List<Entity> pEntities) {
        for (Entity entity : pEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            entity.hurt(DamageSource.mobAttack(this), 10.0f);
            this.doEnchantDamageEffects(this, entity);
        }
    }

    private float rotWrap(double pAngle) {
        return (float)Mth.wrapDegrees(pAngle);
    }

    private boolean checkWalls(AABB pArea) {
        int i = Mth.floor(pArea.minX);
        int j = Mth.floor(pArea.minY);
        int k = Mth.floor(pArea.minZ);
        int l = Mth.floor(pArea.maxX);
        int i1 = Mth.floor(pArea.maxY);
        int j1 = Mth.floor(pArea.maxZ);
        boolean flag = false;
        boolean flag1 = false;
        int k1 = i;
        while (k1 <= l) {
            int l1 = j;
            while (l1 <= i1) {
                int i2 = k;
                while (i2 <= j1) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockstate = this.level.getBlockState(blockpos);
                    if (!blockstate.isAir() && blockstate.getMaterial() != Material.FIRE) {
                        if (this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && !blockstate.is(BlockTags.DRAGON_IMMUNE)) {
                            flag1 = this.level.removeBlock(blockpos, false) || flag1;
                        } else {
                            flag = true;
                        }
                    }
                    ++i2;
                }
                ++l1;
            }
            ++k1;
        }
        if (flag1) {
            BlockPos blockpos1 = new BlockPos(i + this.random.nextInt(l - i + 1), j + this.random.nextInt(i1 - j + 1), k + this.random.nextInt(j1 - k + 1));
            this.level.levelEvent(2008, blockpos1, 0);
        }
        return flag;
    }

    public boolean hurt(EnderDragonPart pPart, DamageSource pSource, float pDamage) {
        if (this.phaseManager.getCurrentPhase().getPhase() == EnderDragonPhase.DYING) {
            return false;
        }
        pDamage = this.phaseManager.getCurrentPhase().onHurt(pSource, pDamage);
        if (pPart != this.head) {
            pDamage = pDamage / 4.0f + Math.min(pDamage, 1.0f);
        }
        if (pDamage < 0.01f) {
            return false;
        }
        if (pSource.getEntity() instanceof Player || pSource.isExplosion()) {
            float f = this.getHealth();
            this.reallyHurt(pSource, pDamage);
            if (this.isDeadOrDying() && !this.phaseManager.getCurrentPhase().isSitting()) {
                this.setHealth(1.0f);
                this.phaseManager.setPhase(EnderDragonPhase.DYING);
            }
            if (this.phaseManager.getCurrentPhase().isSitting()) {
                this.sittingDamageReceived = this.sittingDamageReceived + f - this.getHealth();
                if (this.sittingDamageReceived > 0.25f * this.getMaxHealth()) {
                    this.sittingDamageReceived = 0.0f;
                    this.phaseManager.setPhase(EnderDragonPhase.TAKEOFF);
                }
            }
        }
        return true;
    }

    @Override
    public boolean hurt(DamageSource pSource, float pAmount) {
        if (pSource instanceof EntityDamageSource && ((EntityDamageSource)pSource).isThorns() && !this.level.isClientSide) {
            this.hurt(this.body, pSource, pAmount);
        }
        return false;
    }

    protected boolean reallyHurt(DamageSource pSource, float pAmount) {
        return super.hurt(pSource, pAmount);
    }

    @Override
    public void kill() {
        this.remove(Entity.RemovalReason.KILLED);
        if (this.dragonFight != null) {
            this.dragonFight.updateDragon(this);
            this.dragonFight.setDragonKilled(this);
        }
    }

    @Override
    protected void tickDeath() {
        if (this.dragonFight != null) {
            this.dragonFight.updateDragon(this);
        }
        ++this.dragonDeathTime;
        if (this.dragonDeathTime >= 180 && this.dragonDeathTime <= 200) {
            float f = (this.random.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level.addParticle(ParticleTypes.EXPLOSION_EMITTER, this.getX() + (double)f, this.getY() + 2.0 + (double)f1, this.getZ() + (double)f2, 0.0, 0.0, 0.0);
        }
        boolean flag = this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT);
        int i = 500;
        if (this.dragonFight != null && !this.dragonFight.hasPreviouslyKilledDragon()) {
            i = 12000;
        }
        if (this.level instanceof ServerLevel) {
            if (this.dragonDeathTime > 150 && this.dragonDeathTime % 5 == 0 && flag) {
                ExperienceOrb.award((ServerLevel)this.level, this.position(), Mth.floor((float)i * 0.08f));
            }
            if (this.dragonDeathTime == 1 && !this.isSilent()) {
                this.level.globalLevelEvent(1028, this.blockPosition(), 0);
            }
        }
        this.move(MoverType.SELF, new Vec3(0.0, 0.1f, 0.0));
        this.setYRot(this.getYRot() + 20.0f);
        this.yBodyRot = this.getYRot();
        if (this.dragonDeathTime == 200 && this.level instanceof ServerLevel) {
            if (flag) {
                ExperienceOrb.award((ServerLevel)this.level, this.position(), Mth.floor((float)i * 0.2f));
            }
            if (this.dragonFight != null) {
                this.dragonFight.setDragonKilled(this);
            }
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public int findClosestNode() {
        if (this.nodes[0] == null) {
            int i = 0;
            while (i < 24) {
                int i1;
                int l;
                int j = 5;
                if (i < 12) {
                    l = Mth.floor(60.0f * Mth.cos(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i)));
                    i1 = Mth.floor(60.0f * Mth.sin(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i)));
                } else if (i < 20) {
                    int $$2 = i - 12;
                    l = Mth.floor(40.0f * Mth.cos(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)$$2)));
                    i1 = Mth.floor(40.0f * Mth.sin(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)$$2)));
                    j += 10;
                } else {
                    int k1 = i - 20;
                    l = Mth.floor(20.0f * Mth.cos(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)k1)));
                    i1 = Mth.floor(20.0f * Mth.sin(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)k1)));
                }
                int j1 = Math.max(this.level.getSeaLevel() + 10, this.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(l, 0, i1)).getY() + j);
                this.nodes[i] = new Node(l, j1, i1);
                ++i;
            }
            this.nodeAdjacency[0] = 6146;
            this.nodeAdjacency[1] = 8197;
            this.nodeAdjacency[2] = 8202;
            this.nodeAdjacency[3] = 16404;
            this.nodeAdjacency[4] = 32808;
            this.nodeAdjacency[5] = 32848;
            this.nodeAdjacency[6] = 65696;
            this.nodeAdjacency[7] = 131392;
            this.nodeAdjacency[8] = 131712;
            this.nodeAdjacency[9] = 263424;
            this.nodeAdjacency[10] = 526848;
            this.nodeAdjacency[11] = 525313;
            this.nodeAdjacency[12] = 1581057;
            this.nodeAdjacency[13] = 3166214;
            this.nodeAdjacency[14] = 2138120;
            this.nodeAdjacency[15] = 6373424;
            this.nodeAdjacency[16] = 4358208;
            this.nodeAdjacency[17] = 12910976;
            this.nodeAdjacency[18] = 9044480;
            this.nodeAdjacency[19] = 9706496;
            this.nodeAdjacency[20] = 15216640;
            this.nodeAdjacency[21] = 0xD0E000;
            this.nodeAdjacency[22] = 11763712;
            this.nodeAdjacency[23] = 0x7E0000;
        }
        return this.findClosestNode(this.getX(), this.getY(), this.getZ());
    }

    public int findClosestNode(double pX, double p_31172_, double pY) {
        float f = 10000.0f;
        int i = 0;
        Node node = new Node(Mth.floor(pX), Mth.floor(p_31172_), Mth.floor(pY));
        int j = 0;
        if (this.dragonFight == null || this.dragonFight.getCrystalsAlive() == 0) {
            j = 12;
        }
        int k = j;
        while (k < 24) {
            float f1;
            if (this.nodes[k] != null && (f1 = this.nodes[k].distanceToSqr(node)) < f) {
                f = f1;
                i = k;
            }
            ++k;
        }
        return i;
    }

    @Nullable
    public Path findPath(int pStartIdx, int pFinishIdx, @Nullable Node pAndThen) {
        int i = 0;
        while (i < 24) {
            Node node = this.nodes[i];
            node.closed = false;
            node.f = 0.0f;
            node.g = 0.0f;
            node.h = 0.0f;
            node.cameFrom = null;
            node.heapIdx = -1;
            ++i;
        }
        Node node4 = this.nodes[pStartIdx];
        Node node5 = this.nodes[pFinishIdx];
        node4.g = 0.0f;
        node4.f = node4.h = node4.distanceTo(node5);
        this.openSet.clear();
        this.openSet.insert(node4);
        Node node1 = node4;
        int j = 0;
        if (this.dragonFight == null || this.dragonFight.getCrystalsAlive() == 0) {
            j = 12;
        }
        while (!this.openSet.isEmpty()) {
            Node node2 = this.openSet.pop();
            if (node2.equals(node5)) {
                if (pAndThen != null) {
                    pAndThen.cameFrom = node5;
                    node5 = pAndThen;
                }
                return this.reconstructPath(node4, node5);
            }
            if (node2.distanceTo(node5) < node1.distanceTo(node5)) {
                node1 = node2;
            }
            node2.closed = true;
            int k = 0;
            int l = 0;
            while (l < 24) {
                if (this.nodes[l] == node2) {
                    k = l;
                    break;
                }
                ++l;
            }
            int i1 = j;
            while (i1 < 24) {
                if ((this.nodeAdjacency[k] & 1 << i1) > 0) {
                    Node node3 = this.nodes[i1];
                    if (!node3.closed) {
                        float f = node2.g + node2.distanceTo(node3);
                        if (!node3.inOpenSet() || f < node3.g) {
                            node3.cameFrom = node2;
                            node3.g = f;
                            node3.h = node3.distanceTo(node5);
                            if (node3.inOpenSet()) {
                                this.openSet.changeCost(node3, node3.g + node3.h);
                            } else {
                                node3.f = node3.g + node3.h;
                                this.openSet.insert(node3);
                            }
                        }
                    }
                }
                ++i1;
            }
        }
        if (node1 == node4) {
            return null;
        }
        LOGGER.debug("Failed to find path from {} to {}", (Object)pStartIdx, (Object)pFinishIdx);
        if (pAndThen != null) {
            pAndThen.cameFrom = node1;
            node1 = pAndThen;
        }
        return this.reconstructPath(node4, node1);
    }

    private Path reconstructPath(Node pStart, Node pFinish) {
        ArrayList list = Lists.newArrayList();
        Node node = pFinish;
        list.add(0, pFinish);
        while (node.cameFrom != null) {
            node = node.cameFrom;
            list.add(0, node);
        }
        return new Path(list, new BlockPos(pFinish.x, pFinish.y, pFinish.z), true);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt(DRAGON_PHASE_KEY, this.phaseManager.getCurrentPhase().getPhase().getId());
        pCompound.putInt(DRAGON_DEATH_TIME_KEY, this.dragonDeathTime);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains(DRAGON_PHASE_KEY)) {
            this.phaseManager.setPhase(EnderDragonPhase.getById(pCompound.getInt(DRAGON_PHASE_KEY)));
        }
        if (pCompound.contains(DRAGON_DEATH_TIME_KEY)) {
            this.dragonDeathTime = pCompound.getInt(DRAGON_DEATH_TIME_KEY);
        }
    }

    @Override
    public void checkDespawn() {
    }

    public EnderDragonPart[] getSubEntities() {
        return this.subEntities;
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENDER_DRAGON_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.ENDER_DRAGON_HURT;
    }

    @Override
    protected float getSoundVolume() {
        return 5.0f;
    }

    public float a(int p_31109_, double[] p_31110_, double[] p_31111_) {
        double d0;
        DragonPhaseInstance dragonphaseinstance = this.phaseManager.getCurrentPhase();
        EnderDragonPhase<? extends DragonPhaseInstance> enderdragonphase = dragonphaseinstance.getPhase();
        if (enderdragonphase != EnderDragonPhase.LANDING && enderdragonphase != EnderDragonPhase.TAKEOFF) {
            d0 = dragonphaseinstance.isSitting() ? (double)p_31109_ : (p_31109_ == 6 ? 0.0 : p_31111_[1] - p_31110_[1]);
        } else {
            BlockPos blockpos = this.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.END_PODIUM_LOCATION);
            double d1 = Math.max(Math.sqrt(blockpos.distToCenterSqr(this.position())) / 4.0, 1.0);
            d0 = (double)p_31109_ / d1;
        }
        return (float)d0;
    }

    public Vec3 getHeadLookVector(float pPartialTicks) {
        Vec3 vec3;
        DragonPhaseInstance dragonphaseinstance = this.phaseManager.getCurrentPhase();
        EnderDragonPhase<? extends DragonPhaseInstance> enderdragonphase = dragonphaseinstance.getPhase();
        if (enderdragonphase != EnderDragonPhase.LANDING && enderdragonphase != EnderDragonPhase.TAKEOFF) {
            if (dragonphaseinstance.isSitting()) {
                float f4 = this.getXRot();
                float f5 = 1.5f;
                this.setXRot(-45.0f);
                vec3 = this.getViewVector(pPartialTicks);
                this.setXRot(f4);
            } else {
                vec3 = this.getViewVector(pPartialTicks);
            }
        } else {
            BlockPos blockpos = this.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.END_PODIUM_LOCATION);
            float f = Math.max((float)Math.sqrt(blockpos.distToCenterSqr(this.position())) / 4.0f, 1.0f);
            float f1 = 6.0f / f;
            float f2 = this.getXRot();
            float f3 = 1.5f;
            this.setXRot(-f1 * 1.5f * 5.0f);
            vec3 = this.getViewVector(pPartialTicks);
            this.setXRot(f2);
        }
        return vec3;
    }

    public void onCrystalDestroyed(EndCrystal pCrystal, BlockPos pPos, DamageSource pDmgSrc) {
        Player player = pDmgSrc.getEntity() instanceof Player ? (Player)pDmgSrc.getEntity() : this.level.getNearestPlayer(CRYSTAL_DESTROY_TARGETING, pPos.getX(), pPos.getY(), pPos.getZ());
        if (pCrystal == this.nearestCrystal) {
            this.hurt(this.head, DamageSource.explosion(player), 10.0f);
        }
        this.phaseManager.getCurrentPhase().onCrystalDestroyed(pCrystal, pPos, pDmgSrc, player);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        if (DATA_PHASE.equals(pKey) && this.level.isClientSide) {
            this.phaseManager.setPhase(EnderDragonPhase.getById(this.getEntityData().get(DATA_PHASE)));
        }
        super.onSyncedDataUpdated(pKey);
    }

    public EnderDragonPhaseManager getPhaseManager() {
        return this.phaseManager;
    }

    @Nullable
    public EndDragonFight getDragonFight() {
        return this.dragonFight;
    }

    @Override
    public boolean addEffect(MobEffectInstance p_182394_, @Nullable Entity p_182395_) {
        return false;
    }

    @Override
    protected boolean canRide(Entity pEntity) {
        return false;
    }

    @Override
    public boolean canChangeDimensions() {
        return false;
    }

    @Override
    public void recreateFromPacket(ClientboundAddMobPacket p_149572_) {
        super.recreateFromPacket(p_149572_);
        EnderDragonPart[] aenderdragonpart = this.getSubEntities();
        int i = 0;
        while (i < aenderdragonpart.length) {
            aenderdragonpart[i].setId(i + p_149572_.getId());
            ++i;
        }
    }

    @Override
    public boolean canAttack(LivingEntity pTarget) {
        return pTarget.canBeSeenAsEnemy();
    }
}

