/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class ItemFrame
extends HangingEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.defineId(ItemFrame.class, EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Integer> DATA_ROTATION = SynchedEntityData.defineId(ItemFrame.class, EntityDataSerializers.INT);
    public static final int NUM_ROTATIONS = 8;
    private float dropChance = 1.0f;
    private boolean fixed;

    public ItemFrame(EntityType<? extends ItemFrame> p_31761_, Level p_31762_) {
        super((EntityType<? extends HangingEntity>)p_31761_, p_31762_);
    }

    public ItemFrame(Level p_31764_, BlockPos p_31765_, Direction p_31766_) {
        this(EntityType.ITEM_FRAME, p_31764_, p_31765_, p_31766_);
    }

    public ItemFrame(EntityType<? extends ItemFrame> p_149621_, Level p_149622_, BlockPos p_149623_, Direction p_149624_) {
        super(p_149621_, p_149622_, p_149623_);
        this.setDirection(p_149624_);
    }

    @Override
    protected float getEyeHeight(Pose pPose, EntityDimensions pSize) {
        return 0.0f;
    }

    @Override
    protected void defineSynchedData() {
        this.getEntityData().define(DATA_ITEM, ItemStack.EMPTY);
        this.getEntityData().define(DATA_ROTATION, 0);
    }

    @Override
    protected void setDirection(Direction pFacingDirection) {
        Validate.notNull((Object)pFacingDirection);
        this.direction = pFacingDirection;
        if (pFacingDirection.getAxis().isHorizontal()) {
            this.setXRot(0.0f);
            this.setYRot(this.direction.get2DDataValue() * 90);
        } else {
            this.setXRot(-90 * pFacingDirection.getAxisDirection().getStep());
            this.setYRot(0.0f);
        }
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
    }

    @Override
    protected void recalculateBoundingBox() {
        if (this.direction != null) {
            double d0 = 0.46875;
            double d1 = (double)this.pos.getX() + 0.5 - (double)this.direction.getStepX() * 0.46875;
            double d2 = (double)this.pos.getY() + 0.5 - (double)this.direction.getStepY() * 0.46875;
            double d3 = (double)this.pos.getZ() + 0.5 - (double)this.direction.getStepZ() * 0.46875;
            this.setPosRaw(d1, d2, d3);
            double d4 = this.getWidth();
            double d5 = this.getHeight();
            double d6 = this.getWidth();
            Direction.Axis direction$axis = this.direction.getAxis();
            switch (direction$axis) {
                case X: {
                    d4 = 1.0;
                    break;
                }
                case Y: {
                    d5 = 1.0;
                    break;
                }
                case Z: {
                    d6 = 1.0;
                }
            }
            this.setBoundingBox(new AABB(d1 - (d4 /= 32.0), d2 - (d5 /= 32.0), d3 - (d6 /= 32.0), d1 + d4, d2 + d5, d3 + d6));
        }
    }

    @Override
    public boolean survives() {
        if (this.fixed) {
            return true;
        }
        if (!this.level.noCollision(this)) {
            return false;
        }
        BlockState blockstate = this.level.getBlockState(this.pos.relative(this.direction.getOpposite()));
        return blockstate.getMaterial().isSolid() || this.direction.getAxis().isHorizontal() && DiodeBlock.isDiode(blockstate) ? this.level.getEntities(this, this.getBoundingBox(), HANGING_ENTITY).isEmpty() : false;
    }

    @Override
    public void move(MoverType pType, Vec3 pPos) {
        if (!this.fixed) {
            super.move(pType, pPos);
        }
    }

    @Override
    public void push(double pX, double p_31818_, double pY) {
        if (!this.fixed) {
            super.push(pX, p_31818_, pY);
        }
    }

    @Override
    public float getPickRadius() {
        return 0.0f;
    }

    @Override
    public void kill() {
        this.removeFramedMap(this.getItem());
        super.kill();
    }

    @Override
    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.fixed) {
            return pSource != DamageSource.OUT_OF_WORLD && !pSource.isCreativePlayer() ? false : super.hurt(pSource, pAmount);
        }
        if (this.isInvulnerableTo(pSource)) {
            return false;
        }
        if (!pSource.isExplosion() && !this.getItem().isEmpty()) {
            if (!this.level.isClientSide) {
                this.dropItem(pSource.getEntity(), false);
                this.playSound(this.getRemoveItemSound(), 1.0f, 1.0f);
            }
            return true;
        }
        return super.hurt(pSource, pAmount);
    }

    public SoundEvent getRemoveItemSound() {
        return SoundEvents.ITEM_FRAME_REMOVE_ITEM;
    }

    @Override
    public int getWidth() {
        return 12;
    }

    @Override
    public int getHeight() {
        return 12;
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double pDistance) {
        double d0 = 16.0;
        return pDistance < (d0 *= 64.0 * ItemFrame.getViewScale()) * d0;
    }

    @Override
    public void dropItem(@Nullable Entity pBrokenEntity) {
        this.playSound(this.getBreakSound(), 1.0f, 1.0f);
        this.dropItem(pBrokenEntity, true);
    }

    public SoundEvent getBreakSound() {
        return SoundEvents.ITEM_FRAME_BREAK;
    }

    @Override
    public void playPlacementSound() {
        this.playSound(this.getPlaceSound(), 1.0f, 1.0f);
    }

    public SoundEvent getPlaceSound() {
        return SoundEvents.ITEM_FRAME_PLACE;
    }

    private void dropItem(@Nullable Entity p_31803_, boolean p_31804_) {
        if (!this.fixed) {
            ItemStack itemstack = this.getItem();
            this.setItem(ItemStack.EMPTY);
            if (!this.level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                if (p_31803_ == null) {
                    this.removeFramedMap(itemstack);
                }
            } else {
                if (p_31803_ instanceof Player) {
                    Player player = (Player)p_31803_;
                    if (player.getAbilities().instabuild) {
                        this.removeFramedMap(itemstack);
                        return;
                    }
                }
                if (p_31804_) {
                    this.spawnAtLocation(this.getFrameItemStack());
                }
                if (!itemstack.isEmpty()) {
                    itemstack = itemstack.copy();
                    this.removeFramedMap(itemstack);
                    if (this.random.nextFloat() < this.dropChance) {
                        this.spawnAtLocation(itemstack);
                    }
                }
            }
        }
    }

    private void removeFramedMap(ItemStack pStack) {
        MapItemSavedData mapitemsaveddata;
        if (pStack.is(Items.FILLED_MAP) && (mapitemsaveddata = MapItem.getSavedData(pStack, this.level)) != null) {
            mapitemsaveddata.removedFromFrame(this.pos, this.getId());
            mapitemsaveddata.setDirty(true);
        }
        pStack.setEntityRepresentation(null);
    }

    public ItemStack getItem() {
        return this.getEntityData().get(DATA_ITEM);
    }

    public void setItem(ItemStack pStack) {
        this.setItem(pStack, true);
    }

    public void setItem(ItemStack p_31790_, boolean p_31791_) {
        if (!p_31790_.isEmpty()) {
            p_31790_ = p_31790_.copy();
            p_31790_.setCount(1);
            p_31790_.setEntityRepresentation(this);
        }
        this.getEntityData().set(DATA_ITEM, p_31790_);
        if (!p_31790_.isEmpty()) {
            this.playSound(this.getAddItemSound(), 1.0f, 1.0f);
        }
        if (p_31791_ && this.pos != null) {
            this.level.updateNeighbourForOutputSignal(this.pos, Blocks.AIR);
        }
    }

    public SoundEvent getAddItemSound() {
        return SoundEvents.ITEM_FRAME_ADD_ITEM;
    }

    @Override
    public SlotAccess getSlot(int pSlot) {
        return pSlot == 0 ? new SlotAccess(){

            @Override
            public ItemStack get() {
                return ItemFrame.this.getItem();
            }

            @Override
            public boolean set(ItemStack p_149635_) {
                ItemFrame.this.setItem(p_149635_);
                return true;
            }
        } : super.getSlot(pSlot);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        ItemStack itemstack;
        if (pKey.equals(DATA_ITEM) && !(itemstack = this.getItem()).isEmpty() && itemstack.getFrame() != this) {
            itemstack.setEntityRepresentation(this);
        }
    }

    public int getRotation() {
        return this.getEntityData().get(DATA_ROTATION);
    }

    public void setRotation(int pRotation) {
        this.setRotation(pRotation, true);
    }

    private void setRotation(int p_31773_, boolean p_31774_) {
        this.getEntityData().set(DATA_ROTATION, p_31773_ % 8);
        if (p_31774_ && this.pos != null) {
            this.level.updateNeighbourForOutputSignal(this.pos, Blocks.AIR);
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        if (!this.getItem().isEmpty()) {
            pCompound.put("Item", this.getItem().save(new CompoundTag()));
            pCompound.putByte("ItemRotation", (byte)this.getRotation());
            pCompound.putFloat("ItemDropChance", this.dropChance);
        }
        pCompound.putByte("Facing", (byte)this.direction.get3DDataValue());
        pCompound.putBoolean("Invisible", this.isInvisible());
        pCompound.putBoolean("Fixed", this.fixed);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        CompoundTag compoundtag = pCompound.getCompound("Item");
        if (compoundtag != null && !compoundtag.isEmpty()) {
            ItemStack itemstack1;
            ItemStack itemstack = ItemStack.of(compoundtag);
            if (itemstack.isEmpty()) {
                LOGGER.warn("Unable to load item from: {}", (Object)compoundtag);
            }
            if (!(itemstack1 = this.getItem()).isEmpty() && !ItemStack.matches(itemstack, itemstack1)) {
                this.removeFramedMap(itemstack1);
            }
            this.setItem(itemstack, false);
            this.setRotation(pCompound.getByte("ItemRotation"), false);
            if (pCompound.contains("ItemDropChance", 99)) {
                this.dropChance = pCompound.getFloat("ItemDropChance");
            }
        }
        this.setDirection(Direction.from3DDataValue(pCompound.getByte("Facing")));
        this.setInvisible(pCompound.getBoolean("Invisible"));
        this.fixed = pCompound.getBoolean("Fixed");
    }

    @Override
    public InteractionResult interact(Player pPlayer, InteractionHand pHand) {
        boolean flag1;
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        boolean flag = !this.getItem().isEmpty();
        boolean bl = flag1 = !itemstack.isEmpty();
        if (this.fixed) {
            return InteractionResult.PASS;
        }
        if (!this.level.isClientSide) {
            if (!flag) {
                if (flag1 && !this.isRemoved()) {
                    MapItemSavedData mapitemsaveddata;
                    if (itemstack.is(Items.FILLED_MAP) && (mapitemsaveddata = MapItem.getSavedData(itemstack, this.level)) != null && mapitemsaveddata.isTrackedCountOverLimit(256)) {
                        return InteractionResult.FAIL;
                    }
                    this.setItem(itemstack);
                    if (!pPlayer.getAbilities().instabuild) {
                        itemstack.shrink(1);
                    }
                }
            } else {
                this.playSound(this.getRotateItemSound(), 1.0f, 1.0f);
                this.setRotation(this.getRotation() + 1);
            }
            return InteractionResult.CONSUME;
        }
        return !flag && !flag1 ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }

    public SoundEvent getRotateItemSound() {
        return SoundEvents.ITEM_FRAME_ROTATE_ITEM;
    }

    public int getAnalogOutput() {
        return this.getItem().isEmpty() ? 0 : this.getRotation() % 8 + 1;
    }

    @Override
    public Packet<?> getAddEntityPacket() {
        return new ClientboundAddEntityPacket(this, this.getType(), this.direction.get3DDataValue(), this.getPos());
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket pPacket) {
        super.recreateFromPacket(pPacket);
        this.setDirection(Direction.from3DDataValue(pPacket.getData()));
    }

    @Override
    public ItemStack getPickResult() {
        ItemStack itemstack = this.getItem();
        return itemstack.isEmpty() ? this.getFrameItemStack() : itemstack.copy();
    }

    protected ItemStack getFrameItemStack() {
        return new ItemStack(Items.ITEM_FRAME);
    }
}

