/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddPaintingPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public class Painting
extends HangingEntity {
    public Motive motive = Motive.KEBAB;

    public Painting(EntityType<? extends Painting> p_31904_, Level p_31905_) {
        super((EntityType<? extends HangingEntity>)p_31904_, p_31905_);
    }

    public Painting(Level p_31907_, BlockPos p_31908_, Direction p_31909_) {
        super(EntityType.PAINTING, p_31907_, p_31908_);
        ArrayList list = Lists.newArrayList();
        int i = 0;
        Iterator iterator = Registry.MOTIVE.iterator();
        while (iterator.hasNext()) {
            Motive motive;
            this.motive = motive = (Motive)iterator.next();
            this.setDirection(p_31909_);
            if (!this.survives()) continue;
            list.add(motive);
            int j = motive.getWidth() * motive.getHeight();
            if (j <= i) continue;
            i = j;
        }
        if (!list.isEmpty()) {
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Motive motive1 = (Motive)iterator2.next();
                if (motive1.getWidth() * motive1.getHeight() >= i) continue;
                iterator2.remove();
            }
            this.motive = (Motive)list.get(this.random.nextInt(list.size()));
        }
        this.setDirection(p_31909_);
    }

    public Painting(Level p_31911_, BlockPos p_31912_, Direction p_31913_, Motive p_31914_) {
        this(p_31911_, p_31912_, p_31913_);
        this.motive = p_31914_;
        this.setDirection(p_31913_);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        pCompound.putString("Motive", Registry.MOTIVE.getKey(this.motive).toString());
        pCompound.putByte("Facing", (byte)this.direction.get2DDataValue());
        super.addAdditionalSaveData(pCompound);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        this.motive = Registry.MOTIVE.get(ResourceLocation.tryParse(pCompound.getString("Motive")));
        this.direction = Direction.from2DDataValue(pCompound.getByte("Facing"));
        super.readAdditionalSaveData(pCompound);
        this.setDirection(this.direction);
    }

    @Override
    public int getWidth() {
        return this.motive.getWidth();
    }

    @Override
    public int getHeight() {
        return this.motive.getHeight();
    }

    @Override
    public void dropItem(@Nullable Entity pBrokenEntity) {
        if (this.level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            this.playSound(SoundEvents.PAINTING_BREAK, 1.0f, 1.0f);
            if (pBrokenEntity instanceof Player) {
                Player player = (Player)pBrokenEntity;
                if (player.getAbilities().instabuild) {
                    return;
                }
            }
            this.spawnAtLocation(Items.PAINTING);
        }
    }

    @Override
    public void playPlacementSound() {
        this.playSound(SoundEvents.PAINTING_PLACE, 1.0f, 1.0f);
    }

    @Override
    public void moveTo(double pX, double p_31930_, double pY, float p_31932_, float pZ) {
        this.setPos(pX, p_31930_, pY);
    }

    @Override
    public void lerpTo(double pX, double p_31918_, double pY, float p_31920_, float pZ, int p_31922_, boolean pYaw) {
        BlockPos blockpos = this.pos.offset(pX - this.getX(), p_31918_ - this.getY(), pY - this.getZ());
        this.setPos(blockpos.getX(), blockpos.getY(), blockpos.getZ());
    }

    @Override
    public Packet<?> getAddEntityPacket() {
        return new ClientboundAddPaintingPacket(this);
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.PAINTING);
    }
}

