/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;

public class RememberIfHoglinWasKilled<E extends Piglin>
extends Behavior<E> {
    public RememberIfHoglinWasKilled() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.HUNTED_RECENTLY, (Object)((Object)MemoryStatus.REGISTERED)));
    }

    @Override
    protected void start(ServerLevel pLevel, E pEntity, long pGameTime) {
        if (this.isAttackTargetDeadHoglin(pEntity)) {
            PiglinAi.dontKillAnyMoreHoglinsForAWhile(pEntity);
        }
    }

    private boolean isAttackTargetDeadHoglin(E p_35137_) {
        LivingEntity livingentity = ((Piglin)p_35137_).getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        return livingentity.getType() == EntityType.HOGLIN && livingentity.isDeadOrDying();
    }
}

