/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;

public class StartHuntingHoglin<E extends Piglin>
extends Behavior<E> {
    public StartHuntingHoglin() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.NEAREST_VISIBLE_HUNTABLE_HOGLIN, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.ANGRY_AT, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.HUNTED_RECENTLY, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS, (Object)((Object)MemoryStatus.REGISTERED)));
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel pLevel, Piglin pOwner) {
        return !pOwner.isBaby() && !PiglinAi.hasAnyoneNearbyHuntedRecently(pOwner);
    }

    @Override
    protected void start(ServerLevel pLevel, E pEntity, long pGameTime) {
        Hoglin hoglin = ((Piglin)pEntity).getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_HUNTABLE_HOGLIN).get();
        PiglinAi.setAngerTarget(pEntity, hoglin);
        PiglinAi.dontKillAnyMoreHoglinsForAWhile(pEntity);
        PiglinAi.broadcastAngerTarget(pEntity, hoglin);
        PiglinAi.broadcastDontKillAnyMoreHoglinsForAWhile(pEntity);
    }
}

