/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;

public class VillagerData {
    public static final int MIN_VILLAGER_LEVEL = 1;
    public static final int MAX_VILLAGER_LEVEL = 5;
    private static final int[] NEXT_LEVEL_XP_THRESHOLDS;
    public static final Codec<VillagerData> CODEC;
    private final VillagerType type;
    private final VillagerProfession profession;
    private final int level;

    static {
        int[] nArray = new int[5];
        nArray[1] = 10;
        nArray[2] = 70;
        nArray[3] = 150;
        nArray[4] = 250;
        NEXT_LEVEL_XP_THRESHOLDS = nArray;
        CODEC = RecordCodecBuilder.create(p_35570_ -> p_35570_.group((App)Registry.VILLAGER_TYPE.byNameCodec().fieldOf("type").orElseGet(() -> VillagerType.PLAINS).forGetter(p_150024_ -> p_150024_.type), (App)Registry.VILLAGER_PROFESSION.byNameCodec().fieldOf("profession").orElseGet(() -> VillagerProfession.NONE).forGetter(p_150022_ -> p_150022_.profession), (App)Codec.INT.fieldOf("level").orElse((Object)1).forGetter(p_150020_ -> p_150020_.level)).apply((Applicative)p_35570_, VillagerData::new));
    }

    public VillagerData(VillagerType p_35557_, VillagerProfession p_35558_, int p_35559_) {
        this.type = p_35557_;
        this.profession = p_35558_;
        this.level = Math.max(1, p_35559_);
    }

    public VillagerType getType() {
        return this.type;
    }

    public VillagerProfession getProfession() {
        return this.profession;
    }

    public int getLevel() {
        return this.level;
    }

    public VillagerData setType(VillagerType pType) {
        return new VillagerData(pType, this.profession, this.level);
    }

    public VillagerData setProfession(VillagerProfession pProfession) {
        return new VillagerData(this.type, pProfession, this.level);
    }

    public VillagerData setLevel(int pLevel) {
        return new VillagerData(this.type, this.profession, pLevel);
    }

    public static int getMinXpPerLevel(int pLevel) {
        return VillagerData.canLevelUp(pLevel) ? NEXT_LEVEL_XP_THRESHOLDS[pLevel - 1] : 0;
    }

    public static int getMaxXpPerLevel(int pLevel) {
        return VillagerData.canLevelUp(pLevel) ? NEXT_LEVEL_XP_THRESHOLDS[pLevel] : 0;
    }

    public static boolean canLevelUp(int pLevel) {
        return pLevel >= 1 && pLevel < 5;
    }
}

