/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class Inventory
implements Container,
Nameable {
    public static final int POP_TIME_DURATION = 5;
    public static final int INVENTORY_SIZE = 36;
    private static final int SELECTION_SIZE = 9;
    public static final int SLOT_OFFHAND = 40;
    public static final int NOT_FOUND_INDEX = -1;
    public static final int[] ALL_ARMOR_SLOTS;
    public static final int[] HELMET_SLOT_ONLY;
    public final NonNullList<ItemStack> items = NonNullList.withSize(36, ItemStack.EMPTY);
    public final NonNullList<ItemStack> armor = NonNullList.withSize(4, ItemStack.EMPTY);
    public final NonNullList<ItemStack> offhand = NonNullList.withSize(1, ItemStack.EMPTY);
    private final List<NonNullList<ItemStack>> compartments = ImmutableList.of(this.items, this.armor, this.offhand);
    public int selected;
    public final Player player;
    private int timesChanged;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        ALL_ARMOR_SLOTS = nArray;
        HELMET_SLOT_ONLY = new int[]{3};
    }

    public Inventory(Player p_35983_) {
        this.player = p_35983_;
    }

    public ItemStack getSelected() {
        return Inventory.isHotbarSlot(this.selected) ? this.items.get(this.selected) : ItemStack.EMPTY;
    }

    public static int getSelectionSize() {
        return 9;
    }

    private boolean hasRemainingSpaceForItem(ItemStack pStack1, ItemStack pStack2) {
        return !pStack1.isEmpty() && ItemStack.isSameItemSameTags(pStack1, pStack2) && pStack1.isStackable() && pStack1.getCount() < pStack1.getMaxStackSize() && pStack1.getCount() < this.getMaxStackSize();
    }

    public int getFreeSlot() {
        int i = 0;
        while (i < this.items.size()) {
            if (this.items.get(i).isEmpty()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setPickedItem(ItemStack pStack) {
        int i = this.findSlotMatchingItem(pStack);
        if (Inventory.isHotbarSlot(i)) {
            this.selected = i;
        } else if (i == -1) {
            int j;
            this.selected = this.getSuitableHotbarSlot();
            if (!this.items.get(this.selected).isEmpty() && (j = this.getFreeSlot()) != -1) {
                this.items.set(j, this.items.get(this.selected));
            }
            this.items.set(this.selected, pStack);
        } else {
            this.pickSlot(i);
        }
    }

    public void pickSlot(int pIndex) {
        this.selected = this.getSuitableHotbarSlot();
        ItemStack itemstack = this.items.get(this.selected);
        this.items.set(this.selected, this.items.get(pIndex));
        this.items.set(pIndex, itemstack);
    }

    public static boolean isHotbarSlot(int pIndex) {
        return pIndex >= 0 && pIndex < 9;
    }

    public int findSlotMatchingItem(ItemStack pStack) {
        int i = 0;
        while (i < this.items.size()) {
            if (!this.items.get(i).isEmpty() && ItemStack.isSameItemSameTags(pStack, this.items.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int findSlotMatchingUnusedItem(ItemStack p_36044_) {
        int i = 0;
        while (i < this.items.size()) {
            ItemStack itemstack = this.items.get(i);
            if (!(this.items.get(i).isEmpty() || !ItemStack.isSameItemSameTags(p_36044_, this.items.get(i)) || this.items.get(i).isDamaged() || itemstack.isEnchanted() || itemstack.hasCustomHoverName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getSuitableHotbarSlot() {
        int i = 0;
        while (i < 9) {
            int j = (this.selected + i) % 9;
            if (this.items.get(j).isEmpty()) {
                return j;
            }
            ++i;
        }
        int k = 0;
        while (k < 9) {
            int l = (this.selected + k) % 9;
            if (!this.items.get(l).isEnchanted()) {
                return l;
            }
            ++k;
        }
        return this.selected;
    }

    public void swapPaint(double pDirection) {
        int i = (int)Math.signum(pDirection);
        this.selected -= i;
        while (this.selected < 0) {
            this.selected += 9;
        }
        while (this.selected >= 9) {
            this.selected -= 9;
        }
    }

    public int clearOrCountMatchingItems(Predicate<ItemStack> p_36023_, int p_36024_, Container p_36025_) {
        int i = 0;
        boolean flag = p_36024_ == 0;
        i += ContainerHelper.clearOrCountMatchingItems(this, p_36023_, p_36024_ - i, flag);
        i += ContainerHelper.clearOrCountMatchingItems(p_36025_, p_36023_, p_36024_ - i, flag);
        ItemStack itemstack = this.player.containerMenu.getCarried();
        i += ContainerHelper.clearOrCountMatchingItems(itemstack, p_36023_, p_36024_ - i, flag);
        if (itemstack.isEmpty()) {
            this.player.containerMenu.setCarried(ItemStack.EMPTY);
        }
        return i;
    }

    private int addResource(ItemStack pItemStack) {
        int i = this.getSlotWithRemainingSpace(pItemStack);
        if (i == -1) {
            i = this.getFreeSlot();
        }
        return i == -1 ? pItemStack.getCount() : this.addResource(i, pItemStack);
    }

    private int addResource(int p_36048_, ItemStack p_36049_) {
        Item item = p_36049_.getItem();
        int i = p_36049_.getCount();
        ItemStack itemstack = this.getItem(p_36048_);
        if (itemstack.isEmpty()) {
            itemstack = new ItemStack(item, 0);
            if (p_36049_.hasTag()) {
                itemstack.setTag(p_36049_.getTag().copy());
            }
            this.setItem(p_36048_, itemstack);
        }
        int j = i;
        if (i > itemstack.getMaxStackSize() - itemstack.getCount()) {
            j = itemstack.getMaxStackSize() - itemstack.getCount();
        }
        if (j > this.getMaxStackSize() - itemstack.getCount()) {
            j = this.getMaxStackSize() - itemstack.getCount();
        }
        if (j == 0) {
            return i;
        }
        itemstack.grow(j);
        itemstack.setPopTime(5);
        return i -= j;
    }

    public int getSlotWithRemainingSpace(ItemStack pItemStack) {
        if (this.hasRemainingSpaceForItem(this.getItem(this.selected), pItemStack)) {
            return this.selected;
        }
        if (this.hasRemainingSpaceForItem(this.getItem(40), pItemStack)) {
            return 40;
        }
        int i = 0;
        while (i < this.items.size()) {
            if (this.hasRemainingSpaceForItem(this.items.get(i), pItemStack)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void tick() {
        for (NonNullList<ItemStack> nonnulllist : this.compartments) {
            int i = 0;
            while (i < nonnulllist.size()) {
                if (!nonnulllist.get(i).isEmpty()) {
                    nonnulllist.get(i).inventoryTick(this.player.level, this.player, i, this.selected == i);
                }
                ++i;
            }
        }
    }

    public boolean add(ItemStack pItemStack) {
        return this.add(-1, pItemStack);
    }

    public boolean add(int pSlot, ItemStack pStack) {
        int i;
        block12: {
            block10: {
                block11: {
                    if (pStack.isEmpty()) {
                        return false;
                    }
                    if (!pStack.isDamaged()) break block10;
                    if (pSlot == -1) {
                        pSlot = this.getFreeSlot();
                    }
                    if (pSlot < 0) break block11;
                    this.items.set(pSlot, pStack.copy());
                    this.items.get(pSlot).setPopTime(5);
                    pStack.setCount(0);
                    return true;
                }
                if (this.player.getAbilities().instabuild) {
                    pStack.setCount(0);
                    return true;
                }
                return false;
            }
            try {
                do {
                    i = pStack.getCount();
                    if (pSlot == -1) {
                        pStack.setCount(this.addResource(pStack));
                        continue;
                    }
                    pStack.setCount(this.addResource(pSlot, pStack));
                } while (!pStack.isEmpty() && pStack.getCount() < i);
                if (pStack.getCount() != i || !this.player.getAbilities().instabuild) break block12;
                pStack.setCount(0);
                return true;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable(throwable, "Adding item to inventory");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Item being added");
                crashreportcategory.setDetail("Item ID", Item.getId(pStack.getItem()));
                crashreportcategory.setDetail("Item data", pStack.getDamageValue());
                crashreportcategory.setDetail("Item name", () -> pStack.getHoverName().getString());
                throw new ReportedException(crashreport);
            }
        }
        return pStack.getCount() < i;
    }

    public void placeItemBackInInventory(ItemStack p_150080_) {
        this.placeItemBackInInventory(p_150080_, true);
    }

    public void placeItemBackInInventory(ItemStack p_150077_, boolean p_150078_) {
        while (!p_150077_.isEmpty()) {
            int i = this.getSlotWithRemainingSpace(p_150077_);
            if (i == -1) {
                i = this.getFreeSlot();
            }
            if (i != -1) {
                int j = p_150077_.getMaxStackSize() - this.getItem(i).getCount();
                if (!this.add(i, p_150077_.split(j)) || !p_150078_ || !(this.player instanceof ServerPlayer)) continue;
                ((ServerPlayer)this.player).connection.send(new ClientboundContainerSetSlotPacket(-2, 0, i, this.getItem(i)));
                continue;
            }
            this.player.drop(p_150077_, false);
            break;
        }
    }

    @Override
    public ItemStack removeItem(int pIndex, int pCount) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> nonnulllist : this.compartments) {
            if (pIndex < nonnulllist.size()) {
                list = nonnulllist;
                break;
            }
            pIndex -= nonnulllist.size();
        }
        return list != null && !((ItemStack)list.get(pIndex)).isEmpty() ? ContainerHelper.removeItem(list, pIndex, pCount) : ItemStack.EMPTY;
    }

    public void removeItem(ItemStack pStack) {
        block0: for (NonNullList<ItemStack> nonnulllist : this.compartments) {
            int i = 0;
            while (i < nonnulllist.size()) {
                if (nonnulllist.get(i) == pStack) {
                    nonnulllist.set(i, ItemStack.EMPTY);
                    continue block0;
                }
                ++i;
            }
        }
    }

    @Override
    public ItemStack removeItemNoUpdate(int pIndex) {
        NonNullList<ItemStack> nonnulllist = null;
        for (NonNullList<ItemStack> nonnulllist1 : this.compartments) {
            if (pIndex < nonnulllist1.size()) {
                nonnulllist = nonnulllist1;
                break;
            }
            pIndex -= nonnulllist1.size();
        }
        if (nonnulllist != null && !((ItemStack)nonnulllist.get(pIndex)).isEmpty()) {
            ItemStack itemstack = nonnulllist.get(pIndex);
            nonnulllist.set(pIndex, ItemStack.EMPTY);
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setItem(int pIndex, ItemStack pStack) {
        NonNullList<ItemStack> nonnulllist = null;
        for (NonNullList<ItemStack> nonnulllist1 : this.compartments) {
            if (pIndex < nonnulllist1.size()) {
                nonnulllist = nonnulllist1;
                break;
            }
            pIndex -= nonnulllist1.size();
        }
        if (nonnulllist != null) {
            nonnulllist.set(pIndex, pStack);
        }
    }

    public float getDestroySpeed(BlockState pState) {
        return this.items.get(this.selected).getDestroySpeed(pState);
    }

    public ListTag save(ListTag pNbtTagList) {
        int i = 0;
        while (i < this.items.size()) {
            if (!this.items.get(i).isEmpty()) {
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.putByte("Slot", (byte)i);
                this.items.get(i).save(compoundtag);
                pNbtTagList.add(compoundtag);
            }
            ++i;
        }
        int j = 0;
        while (j < this.armor.size()) {
            if (!this.armor.get(j).isEmpty()) {
                CompoundTag compoundtag1 = new CompoundTag();
                compoundtag1.putByte("Slot", (byte)(j + 100));
                this.armor.get(j).save(compoundtag1);
                pNbtTagList.add(compoundtag1);
            }
            ++j;
        }
        int k = 0;
        while (k < this.offhand.size()) {
            if (!this.offhand.get(k).isEmpty()) {
                CompoundTag compoundtag2 = new CompoundTag();
                compoundtag2.putByte("Slot", (byte)(k + 150));
                this.offhand.get(k).save(compoundtag2);
                pNbtTagList.add(compoundtag2);
            }
            ++k;
        }
        return pNbtTagList;
    }

    public void load(ListTag pNbtTagList) {
        this.items.clear();
        this.armor.clear();
        this.offhand.clear();
        int i = 0;
        while (i < pNbtTagList.size()) {
            CompoundTag compoundtag = pNbtTagList.getCompound(i);
            int j = compoundtag.getByte("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.of(compoundtag);
            if (!itemstack.isEmpty()) {
                if (j >= 0 && j < this.items.size()) {
                    this.items.set(j, itemstack);
                } else if (j >= 100 && j < this.armor.size() + 100) {
                    this.armor.set(j - 100, itemstack);
                } else if (j >= 150 && j < this.offhand.size() + 150) {
                    this.offhand.set(j - 150, itemstack);
                }
            }
            ++i;
        }
    }

    @Override
    public int getContainerSize() {
        return this.items.size() + this.armor.size() + this.offhand.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        for (ItemStack itemstack1 : this.armor) {
            if (itemstack1.isEmpty()) continue;
            return false;
        }
        for (ItemStack itemstack2 : this.offhand) {
            if (itemstack2.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getItem(int pIndex) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> nonnulllist : this.compartments) {
            if (pIndex < nonnulllist.size()) {
                list = nonnulllist;
                break;
            }
            pIndex -= nonnulllist.size();
        }
        return list == null ? ItemStack.EMPTY : (ItemStack)list.get(pIndex);
    }

    @Override
    public Component getName() {
        return new TranslatableComponent("container.inventory");
    }

    public ItemStack getArmor(int pSlot) {
        return this.armor.get(pSlot);
    }

    public void a(DamageSource p_150073_, float p_150074_, int[] p_150075_) {
        if (!(p_150074_ <= 0.0f)) {
            if ((p_150074_ /= 4.0f) < 1.0f) {
                p_150074_ = 1.0f;
            }
            int[] nArray = p_150075_;
            int n = p_150075_.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                ItemStack itemstack = this.armor.get(i);
                if (!(p_150073_.isFire() && itemstack.getItem().isFireResistant() || !(itemstack.getItem() instanceof ArmorItem))) {
                    itemstack.hurtAndBreak((int)p_150074_, this.player, p_35997_ -> p_35997_.broadcastBreakEvent(EquipmentSlot.byTypeAndIndex(EquipmentSlot.Type.ARMOR, i)));
                }
                ++n2;
            }
        }
    }

    public void dropAll() {
        for (List list : this.compartments) {
            int i = 0;
            while (i < list.size()) {
                ItemStack itemstack = (ItemStack)list.get(i);
                if (!itemstack.isEmpty()) {
                    this.player.drop(itemstack, true, false);
                    list.set(i, ItemStack.EMPTY);
                }
                ++i;
            }
        }
    }

    @Override
    public void setChanged() {
        ++this.timesChanged;
    }

    public int getTimesChanged() {
        return this.timesChanged;
    }

    @Override
    public boolean stillValid(Player pPlayer) {
        if (this.player.isRemoved()) {
            return false;
        }
        return !(pPlayer.distanceToSqr(this.player) > 64.0);
    }

    public boolean contains(ItemStack pItemTag) {
        for (List list : this.compartments) {
            for (ItemStack itemstack : list) {
                if (itemstack.isEmpty() || !itemstack.sameItem(pItemTag)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(TagKey<Item> pItemTag) {
        for (List list : this.compartments) {
            for (ItemStack itemstack : list) {
                if (itemstack.isEmpty() || !itemstack.is(pItemTag)) continue;
                return true;
            }
        }
        return false;
    }

    public void replaceWith(Inventory pPlayerInventory) {
        int i = 0;
        while (i < this.getContainerSize()) {
            this.setItem(i, pPlayerInventory.getItem(i));
            ++i;
        }
        this.selected = pPlayerInventory.selected;
    }

    @Override
    public void clearContent() {
        for (List list : this.compartments) {
            list.clear();
        }
    }

    public void fillStackedContents(StackedContents p_36011_) {
        for (ItemStack itemstack : this.items) {
            p_36011_.accountSimpleStack(itemstack);
        }
    }

    public ItemStack removeFromSelected(boolean p_182404_) {
        ItemStack itemstack = this.getSelected();
        return itemstack.isEmpty() ? ItemStack.EMPTY : this.removeItem(this.selected, p_182404_ ? itemstack.getCount() : 1);
    }
}

