/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public final class ProjectileUtil {
    public static HitResult getHitResult(Entity p_37295_, Predicate<Entity> p_37296_) {
        EntityHitResult hitresult1;
        Vec3 vec32;
        Vec3 vec3 = p_37295_.getDeltaMovement();
        Level level = p_37295_.level;
        Vec3 vec31 = p_37295_.position();
        HitResult hitresult = level.clip(new ClipContext(vec31, vec32 = vec31.add(vec3), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, p_37295_));
        if (((HitResult)hitresult).getType() != HitResult.Type.MISS) {
            vec32 = hitresult.getLocation();
        }
        if ((hitresult1 = ProjectileUtil.getEntityHitResult(level, p_37295_, vec31, vec32, p_37295_.getBoundingBox().expandTowards(p_37295_.getDeltaMovement()).inflate(1.0), p_37296_)) != null) {
            hitresult = hitresult1;
        }
        return hitresult;
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(Entity pShooter, Vec3 pStartVec, Vec3 pEndVec, AABB pBoundingBox, Predicate<Entity> pFilter, double pDistance) {
        Level level = pShooter.level;
        double d0 = pDistance;
        Entity entity = null;
        Vec3 vec3 = null;
        for (Entity entity1 : level.getEntities(pShooter, pBoundingBox, pFilter)) {
            Vec3 vec31;
            double d1;
            AABB aabb = entity1.getBoundingBox().inflate(entity1.getPickRadius());
            Optional<Vec3> optional = aabb.clip(pStartVec, pEndVec);
            if (aabb.contains(pStartVec)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vec3 = optional.orElse(pStartVec);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = pStartVec.distanceToSqr(vec31 = optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.getRootVehicle() == pShooter.getRootVehicle()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vec3 = vec31;
                continue;
            }
            entity = entity1;
            vec3 = vec31;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity, vec3);
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(Level pShooter, Entity pStartVec, Vec3 pEndVec, Vec3 pBoundingBox, AABB pFilter, Predicate<Entity> pDistance) {
        return ProjectileUtil.getEntityHitResult(pShooter, pStartVec, pEndVec, pBoundingBox, pFilter, pDistance, 0.3f);
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(Level pLevel, Entity pProjectile, Vec3 pStartVec, Vec3 pEndVec, AABB pBoundingBox, Predicate<Entity> pFilter, float pInflationAmount) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        for (Entity entity1 : pLevel.getEntities(pProjectile, pBoundingBox, pFilter)) {
            double d1;
            AABB aabb = entity1.getBoundingBox().inflate(pInflationAmount);
            Optional<Vec3> optional = aabb.clip(pStartVec, pEndVec);
            if (!optional.isPresent() || !((d1 = pStartVec.distanceToSqr(optional.get())) < d0)) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity);
    }

    public static void rotateTowardsMovement(Entity pProjectile, float pRotationSpeed) {
        Vec3 vec3 = pProjectile.getDeltaMovement();
        if (vec3.lengthSqr() != 0.0) {
            double d0 = vec3.horizontalDistance();
            pProjectile.setYRot((float)(Mth.atan2(vec3.z, vec3.x) * 57.2957763671875) + 90.0f);
            pProjectile.setXRot((float)(Mth.atan2(d0, vec3.y) * 57.2957763671875) - 90.0f);
            while (pProjectile.getXRot() - pProjectile.xRotO < -180.0f) {
                pProjectile.xRotO -= 360.0f;
            }
            while (pProjectile.getXRot() - pProjectile.xRotO >= 180.0f) {
                pProjectile.xRotO += 360.0f;
            }
            while (pProjectile.getYRot() - pProjectile.yRotO < -180.0f) {
                pProjectile.yRotO -= 360.0f;
            }
            while (pProjectile.getYRot() - pProjectile.yRotO >= 180.0f) {
                pProjectile.yRotO += 360.0f;
            }
            pProjectile.setXRot(Mth.lerp(pRotationSpeed, pProjectile.xRotO, pProjectile.getXRot()));
            pProjectile.setYRot(Mth.lerp(pRotationSpeed, pProjectile.yRotO, pProjectile.getYRot()));
        }
    }

    public static InteractionHand getWeaponHoldingHand(LivingEntity pLiving, Item pItem) {
        return pLiving.getMainHandItem().is(pItem) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public static AbstractArrow getMobArrow(LivingEntity pShooter, ItemStack pArrowStack, float pDistanceFactor) {
        ArrowItem arrowitem = (ArrowItem)(pArrowStack.getItem() instanceof ArrowItem ? pArrowStack.getItem() : Items.ARROW);
        AbstractArrow abstractarrow = arrowitem.createArrow(pShooter.level, pArrowStack, pShooter);
        abstractarrow.setEnchantmentEffectsFromEntity(pShooter, pDistanceFactor);
        if (pArrowStack.is(Items.TIPPED_ARROW) && abstractarrow instanceof Arrow) {
            ((Arrow)abstractarrow).setEffectsFromItem(pArrowStack);
        }
        return abstractarrow;
    }
}

