/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.schedule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.entity.schedule.Keyframe;

public class Timeline {
    private final List<Keyframe> keyframes = Lists.newArrayList();
    private int previousIndex;

    public ImmutableList<Keyframe> getKeyframes() {
        return ImmutableList.copyOf(this.keyframes);
    }

    public Timeline addKeyframe(int pDuration, float pActive) {
        this.keyframes.add(new Keyframe(pDuration, pActive));
        this.sortAndDeduplicateKeyframes();
        return this;
    }

    public Timeline addKeyframes(Collection<Keyframe> p_150248_) {
        this.keyframes.addAll(p_150248_);
        this.sortAndDeduplicateKeyframes();
        return this;
    }

    private void sortAndDeduplicateKeyframes() {
        Int2ObjectAVLTreeMap int2objectsortedmap = new Int2ObjectAVLTreeMap();
        this.keyframes.forEach(arg_0 -> Timeline.lambda$0((Int2ObjectSortedMap)int2objectsortedmap, arg_0));
        this.keyframes.clear();
        this.keyframes.addAll((Collection<Keyframe>)int2objectsortedmap.values());
        this.previousIndex = 0;
    }

    public float getValueAt(int pDayTime) {
        if (this.keyframes.size() <= 0) {
            return 0.0f;
        }
        Keyframe keyframe = this.keyframes.get(this.previousIndex);
        Keyframe keyframe1 = this.keyframes.get(this.keyframes.size() - 1);
        boolean flag = pDayTime < keyframe.getTimeStamp();
        int i = flag ? 0 : this.previousIndex;
        float f = flag ? keyframe1.getValue() : keyframe.getValue();
        int j = i;
        while (j < this.keyframes.size()) {
            Keyframe keyframe2 = this.keyframes.get(j);
            if (keyframe2.getTimeStamp() > pDayTime) break;
            this.previousIndex = j++;
            f = keyframe2.getValue();
        }
        return f;
    }

    private static /* synthetic */ void lambda$0(Int2ObjectSortedMap int2ObjectSortedMap, Keyframe p_38065_) {
        int2ObjectSortedMap.put(p_38065_.getTimeStamp(), (Object)p_38065_);
    }
}

