/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.entity.vehicle.MinecartCommandBlock;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.entity.vehicle.MinecartHopper;
import net.minecraft.world.entity.vehicle.MinecartSpawner;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractMinecart
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATA_ID_DISPLAY_BLOCK = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_ID_DISPLAY_OFFSET = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_ID_CUSTOM_DISPLAY = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.BOOLEAN);
    private static final ImmutableMap<Pose, ImmutableList<Integer>> POSE_DISMOUNT_HEIGHTS = ImmutableMap.of((Object)((Object)Pose.STANDING), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)Pose.CROUCHING), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)Pose.SWIMMING), (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float WATER_SLOWDOWN_FACTOR = 0.95f;
    private boolean flipped;
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> EXITS = Util.make(Maps.newEnumMap(RailShape.class), p_38135_ -> {
        Vec3i vec3i = Direction.WEST.getNormal();
        Vec3i vec3i1 = Direction.EAST.getNormal();
        Vec3i vec3i2 = Direction.NORTH.getNormal();
        Vec3i vec3i3 = Direction.SOUTH.getNormal();
        Vec3i vec3i4 = vec3i.below();
        Vec3i vec3i5 = vec3i1.below();
        Vec3i vec3i6 = vec3i2.below();
        Vec3i vec3i7 = vec3i3.below();
        p_38135_.put(RailShape.NORTH_SOUTH, Pair.of((Object)vec3i2, (Object)vec3i3));
        p_38135_.put(RailShape.EAST_WEST, Pair.of((Object)vec3i, (Object)vec3i1));
        p_38135_.put(RailShape.ASCENDING_EAST, Pair.of((Object)vec3i4, (Object)vec3i1));
        p_38135_.put(RailShape.ASCENDING_WEST, Pair.of((Object)vec3i, (Object)vec3i5));
        p_38135_.put(RailShape.ASCENDING_NORTH, Pair.of((Object)vec3i2, (Object)vec3i7));
        p_38135_.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)vec3i6, (Object)vec3i3));
        p_38135_.put(RailShape.SOUTH_EAST, Pair.of((Object)vec3i3, (Object)vec3i1));
        p_38135_.put(RailShape.SOUTH_WEST, Pair.of((Object)vec3i3, (Object)vec3i));
        p_38135_.put(RailShape.NORTH_WEST, Pair.of((Object)vec3i2, (Object)vec3i));
        p_38135_.put(RailShape.NORTH_EAST, Pair.of((Object)vec3i2, (Object)vec3i1));
    });
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;

    protected AbstractMinecart(EntityType<?> p_38087_, Level p_38088_) {
        super(p_38087_, p_38088_);
        this.blocksBuilding = true;
    }

    protected AbstractMinecart(EntityType<?> p_38090_, Level p_38091_, double p_38092_, double p_38093_, double p_38094_) {
        this(p_38090_, p_38091_);
        this.setPos(p_38092_, p_38093_, p_38094_);
        this.xo = p_38092_;
        this.yo = p_38093_;
        this.zo = p_38094_;
    }

    public static AbstractMinecart createMinecart(Level pLevel, double pX, double p_38122_, double pY, Type p_38124_) {
        if (p_38124_ == Type.CHEST) {
            return new MinecartChest(pLevel, pX, p_38122_, pY);
        }
        if (p_38124_ == Type.FURNACE) {
            return new MinecartFurnace(pLevel, pX, p_38122_, pY);
        }
        if (p_38124_ == Type.TNT) {
            return new MinecartTNT(pLevel, pX, p_38122_, pY);
        }
        if (p_38124_ == Type.SPAWNER) {
            return new MinecartSpawner(pLevel, pX, p_38122_, pY);
        }
        if (p_38124_ == Type.HOPPER) {
            return new MinecartHopper(pLevel, pX, p_38122_, pY);
        }
        return p_38124_ == Type.COMMAND_BLOCK ? new MinecartCommandBlock(pLevel, pX, p_38122_, pY) : new Minecart(pLevel, pX, p_38122_, pY);
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    protected void defineSynchedData() {
        this.entityData.define(DATA_ID_HURT, 0);
        this.entityData.define(DATA_ID_HURTDIR, 1);
        this.entityData.define(DATA_ID_DAMAGE, Float.valueOf(0.0f));
        this.entityData.define(DATA_ID_DISPLAY_BLOCK, Block.getId(Blocks.AIR.defaultBlockState()));
        this.entityData.define(DATA_ID_DISPLAY_OFFSET, 6);
        this.entityData.define(DATA_ID_CUSTOM_DISPLAY, false);
    }

    @Override
    public boolean canCollideWith(Entity pEntity) {
        return Boat.canVehicleCollide(this, pEntity);
    }

    @Override
    public boolean isPushable() {
        return true;
    }

    @Override
    protected Vec3 getRelativePortalPosition(Direction.Axis pAxis, BlockUtil.FoundRectangle pPortal) {
        return LivingEntity.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(pAxis, pPortal));
    }

    @Override
    public double getPassengersRidingOffset() {
        return 0.0;
    }

    @Override
    public Vec3 getDismountLocationForPassenger(LivingEntity pLivingEntity) {
        Direction direction = this.getMotionDirection();
        if (direction.getAxis() == Direction.Axis.Y) {
            return super.getDismountLocationForPassenger(pLivingEntity);
        }
        int[][] aint = DismountHelper.offsetsForDirection(direction);
        BlockPos blockpos = this.blockPosition();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        ImmutableList<Pose> immutablelist = pLivingEntity.getDismountPoses();
        for (Pose pose : immutablelist) {
            EntityDimensions entitydimensions = pLivingEntity.getDimensions(pose);
            float f = Math.min(entitydimensions.width, 1.0f) / 2.0f;
            Iterator iterator = ((ImmutableList)POSE_DISMOUNT_HEIGHTS.get((Object)pose)).iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                int[][] nArray = aint;
                int n = aint.length;
                int n2 = 0;
                while (n2 < n) {
                    Vec3 vec3;
                    AABB aabb;
                    int[] aint1 = nArray[n2];
                    blockpos$mutableblockpos.set(blockpos.getX() + aint1[0], blockpos.getY() + i, blockpos.getZ() + aint1[1]);
                    double d0 = this.level.getBlockFloorHeight(DismountHelper.nonClimbableShape(this.level, blockpos$mutableblockpos), () -> DismountHelper.nonClimbableShape(this.level, blockpos$mutableblockpos.below()));
                    if (DismountHelper.isBlockFloorValid(d0) && DismountHelper.canDismountTo(this.level, pLivingEntity, (aabb = new AABB(-f, 0.0, -f, f, entitydimensions.height, f)).move(vec3 = Vec3.upFromBottomCenterOf(blockpos$mutableblockpos, d0)))) {
                        pLivingEntity.setPose(pose);
                        return vec3;
                    }
                    ++n2;
                }
            }
        }
        double d1 = this.getBoundingBox().maxY;
        blockpos$mutableblockpos.set((double)blockpos.getX(), d1, (double)blockpos.getZ());
        for (Pose pose1 : immutablelist) {
            double d2 = pLivingEntity.getDimensions((Pose)pose1).height;
            int j = Mth.ceil(d1 - (double)blockpos$mutableblockpos.getY() + d2);
            double d3 = DismountHelper.findCeilingFrom(blockpos$mutableblockpos, j, p_38149_ -> this.level.getBlockState((BlockPos)p_38149_).getCollisionShape(this.level, (BlockPos)p_38149_));
            if (!(d1 + d2 <= d3)) continue;
            pLivingEntity.setPose(pose1);
            break;
        }
        return super.getDismountLocationForPassenger(pLivingEntity);
    }

    @Override
    public boolean hurt(DamageSource pSource, float pAmount) {
        if (!this.level.isClientSide && !this.isRemoved()) {
            boolean flag;
            if (this.isInvulnerableTo(pSource)) {
                return false;
            }
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.markHurt();
            this.setDamage(this.getDamage() + pAmount * 10.0f);
            this.gameEvent(GameEvent.ENTITY_DAMAGED, pSource.getEntity());
            boolean bl = flag = pSource.getEntity() instanceof Player && ((Player)pSource.getEntity()).getAbilities().instabuild;
            if (flag || this.getDamage() > 40.0f) {
                this.ejectPassengers();
                if (flag && !this.hasCustomName()) {
                    this.discard();
                } else {
                    this.destroy(pSource);
                }
            }
            return true;
        }
        return true;
    }

    @Override
    protected float getBlockSpeedFactor() {
        BlockState blockstate = this.level.getBlockState(this.blockPosition());
        return blockstate.is(BlockTags.RAILS) ? 1.0f : super.getBlockSpeedFactor();
    }

    public void destroy(DamageSource pSource) {
        this.remove(Entity.RemovalReason.KILLED);
        if (this.level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            ItemStack itemstack = new ItemStack(Items.MINECART);
            if (this.hasCustomName()) {
                itemstack.setHoverName(this.getCustomName());
            }
            this.spawnAtLocation(itemstack);
        }
    }

    @Override
    public void animateHurt() {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + this.getDamage() * 10.0f);
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    private static Pair<Vec3i, Vec3i> exits(RailShape pShape) {
        return EXITS.get(pShape);
    }

    @Override
    public Direction getMotionDirection() {
        return this.flipped ? this.getDirection().getOpposite().getClockWise() : this.getDirection().getClockWise();
    }

    @Override
    public void tick() {
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        this.checkOutOfWorld();
        this.handleNetherPortal();
        if (this.level.isClientSide) {
            if (this.lSteps > 0) {
                double d5 = this.getX() + (this.lx - this.getX()) / (double)this.lSteps;
                double d6 = this.getY() + (this.ly - this.getY()) / (double)this.lSteps;
                double d7 = this.getZ() + (this.lz - this.getZ()) / (double)this.lSteps;
                double d2 = Mth.wrapDegrees(this.lyr - (double)this.getYRot());
                this.setYRot(this.getYRot() + (float)d2 / (float)this.lSteps);
                this.setXRot(this.getXRot() + (float)(this.lxr - (double)this.getXRot()) / (float)this.lSteps);
                --this.lSteps;
                this.setPos(d5, d6, d7);
                this.setRot(this.getYRot(), this.getXRot());
            } else {
                this.reapplyPosition();
                this.setRot(this.getYRot(), this.getXRot());
            }
        } else {
            double d4;
            BlockPos blockpos;
            BlockState blockstate;
            int j;
            int i;
            int k;
            if (!this.isNoGravity()) {
                double d0 = this.isInWater() ? -0.005 : -0.04;
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, d0, 0.0));
            }
            if (this.level.getBlockState(new BlockPos(k = Mth.floor(this.getX()), (i = Mth.floor(this.getY())) - 1, j = Mth.floor(this.getZ()))).is(BlockTags.RAILS)) {
                --i;
            }
            if (BaseRailBlock.isRail(blockstate = this.level.getBlockState(blockpos = new BlockPos(k, i, j)))) {
                this.moveAlongTrack(blockpos, blockstate);
                if (blockstate.is(Blocks.ACTIVATOR_RAIL)) {
                    this.activateMinecart(k, i, j, blockstate.getValue(PoweredRailBlock.POWERED));
                }
            } else {
                this.comeOffTrack();
            }
            this.checkInsideBlocks();
            this.setXRot(0.0f);
            double d1 = this.xo - this.getX();
            double d3 = this.zo - this.getZ();
            if (d1 * d1 + d3 * d3 > 0.001) {
                this.setYRot((float)(Mth.atan2(d3, d1) * 180.0 / Math.PI));
                if (this.flipped) {
                    this.setYRot(this.getYRot() + 180.0f);
                }
            }
            if ((d4 = (double)Mth.wrapDegrees(this.getYRot() - this.yRotO)) < -170.0 || d4 >= 170.0) {
                this.setYRot(this.getYRot() + 180.0f);
                this.flipped = !this.flipped;
            }
            this.setRot(this.getYRot(), this.getXRot());
            if (this.getMinecartType() == Type.RIDEABLE && this.getDeltaMovement().horizontalDistanceSqr() > 0.01) {
                List<Entity> list = this.level.getEntities(this, this.getBoundingBox().inflate(0.2f, 0.0, 0.2f), EntitySelector.pushableBy(this));
                if (!list.isEmpty()) {
                    int l = 0;
                    while (l < list.size()) {
                        Entity entity1 = list.get(l);
                        if (!(entity1 instanceof Player || entity1 instanceof IronGolem || entity1 instanceof AbstractMinecart || this.isVehicle() || entity1.isPassenger())) {
                            entity1.startRiding(this);
                        } else {
                            entity1.push(this);
                        }
                        ++l;
                    }
                }
            } else {
                for (Entity entity : this.level.getEntities(this, this.getBoundingBox().inflate(0.2f, 0.0, 0.2f))) {
                    if (this.hasPassenger(entity) || !entity.isPushable() || !(entity instanceof AbstractMinecart)) continue;
                    entity.push(this);
                }
            }
            this.updateInWaterStateAndDoFluidPushing();
            if (this.isInLava()) {
                this.lavaHurt();
                this.fallDistance *= 0.5f;
            }
            this.firstTick = false;
        }
    }

    protected double getMaxSpeed() {
        return (this.isInWater() ? 4.0 : 8.0) / 20.0;
    }

    public void activateMinecart(int pX, int pY, int pZ, boolean pReceivingPower) {
    }

    protected void comeOffTrack() {
        double d0 = this.getMaxSpeed();
        Vec3 vec3 = this.getDeltaMovement();
        this.setDeltaMovement(Mth.clamp(vec3.x, -d0, d0), vec3.y, Mth.clamp(vec3.z, -d0, d0));
        if (this.onGround) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.onGround) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.95));
        }
    }

    protected void moveAlongTrack(BlockPos pPos, BlockState pState) {
        double d14;
        this.resetFallDistance();
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        Vec3 vec3 = this.getPos(d0, d1, d2);
        d1 = pPos.getY();
        boolean flag = false;
        boolean flag1 = false;
        if (pState.is(Blocks.POWERED_RAIL)) {
            flag = pState.getValue(PoweredRailBlock.POWERED);
            flag1 = !flag;
        }
        double d3 = 0.0078125;
        if (this.isInWater()) {
            d3 *= 0.2;
        }
        Vec3 vec31 = this.getDeltaMovement();
        RailShape railshape = pState.getValue(((BaseRailBlock)pState.getBlock()).getShapeProperty());
        switch (railshape) {
            case ASCENDING_EAST: {
                this.setDeltaMovement(vec31.add(-d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.setDeltaMovement(vec31.add(d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                this.setDeltaMovement(vec31.add(0.0, 0.0, d3));
                d1 += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.setDeltaMovement(vec31.add(0.0, 0.0, -d3));
                d1 += 1.0;
            }
        }
        vec31 = this.getDeltaMovement();
        Pair<Vec3i, Vec3i> pair = AbstractMinecart.exits(railshape);
        Vec3i vec3i = (Vec3i)pair.getFirst();
        Vec3i vec3i1 = (Vec3i)pair.getSecond();
        double d4 = vec3i1.getX() - vec3i.getX();
        double d5 = vec3i1.getZ() - vec3i.getZ();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = vec31.x * d4 + vec31.z * d5;
        if (d7 < 0.0) {
            d4 = -d4;
            d5 = -d5;
        }
        double d8 = Math.min(2.0, vec31.horizontalDistance());
        vec31 = new Vec3(d8 * d4 / d6, vec31.y, d8 * d5 / d6);
        this.setDeltaMovement(vec31);
        Entity entity = this.getFirstPassenger();
        if (entity instanceof Player) {
            Vec3 vec32 = entity.getDeltaMovement();
            double d9 = vec32.horizontalDistanceSqr();
            double d11 = this.getDeltaMovement().horizontalDistanceSqr();
            if (d9 > 1.0E-4 && d11 < 0.01) {
                this.setDeltaMovement(this.getDeltaMovement().add(vec32.x * 0.1, 0.0, vec32.z * 0.1));
                flag1 = false;
            }
        }
        if (flag1) {
            double d22 = this.getDeltaMovement().horizontalDistance();
            if (d22 < 0.03) {
                this.setDeltaMovement(Vec3.ZERO);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 0.0, 0.5));
            }
        }
        double d23 = (double)pPos.getX() + 0.5 + (double)vec3i.getX() * 0.5;
        double d10 = (double)pPos.getZ() + 0.5 + (double)vec3i.getZ() * 0.5;
        double d12 = (double)pPos.getX() + 0.5 + (double)vec3i1.getX() * 0.5;
        double d13 = (double)pPos.getZ() + 0.5 + (double)vec3i1.getZ() * 0.5;
        d4 = d12 - d23;
        d5 = d13 - d10;
        if (d4 == 0.0) {
            d14 = d2 - (double)pPos.getZ();
        } else if (d5 == 0.0) {
            d14 = d0 - (double)pPos.getX();
        } else {
            double d15 = d0 - d23;
            double d16 = d2 - d10;
            d14 = (d15 * d4 + d16 * d5) * 2.0;
        }
        d0 = d23 + d4 * d14;
        d2 = d10 + d5 * d14;
        this.setPos(d0, d1, d2);
        double d24 = this.isVehicle() ? 0.75 : 1.0;
        double d25 = this.getMaxSpeed();
        vec31 = this.getDeltaMovement();
        this.move(MoverType.SELF, new Vec3(Mth.clamp(d24 * vec31.x, -d25, d25), 0.0, Mth.clamp(d24 * vec31.z, -d25, d25)));
        if (vec3i.getY() != 0 && Mth.floor(this.getX()) - pPos.getX() == vec3i.getX() && Mth.floor(this.getZ()) - pPos.getZ() == vec3i.getZ()) {
            this.setPos(this.getX(), this.getY() + (double)vec3i.getY(), this.getZ());
        } else if (vec3i1.getY() != 0 && Mth.floor(this.getX()) - pPos.getX() == vec3i1.getX() && Mth.floor(this.getZ()) - pPos.getZ() == vec3i1.getZ()) {
            this.setPos(this.getX(), this.getY() + (double)vec3i1.getY(), this.getZ());
        }
        this.applyNaturalSlowdown();
        Vec3 vec33 = this.getPos(this.getX(), this.getY(), this.getZ());
        if (vec33 != null && vec3 != null) {
            double d17 = (vec3.y - vec33.y) * 0.05;
            Vec3 vec34 = this.getDeltaMovement();
            double d18 = vec34.horizontalDistance();
            if (d18 > 0.0) {
                this.setDeltaMovement(vec34.multiply((d18 + d17) / d18, 1.0, (d18 + d17) / d18));
            }
            this.setPos(this.getX(), vec33.y, this.getZ());
        }
        int j = Mth.floor(this.getX());
        int i = Mth.floor(this.getZ());
        if (j != pPos.getX() || i != pPos.getZ()) {
            Vec3 vec35 = this.getDeltaMovement();
            double d26 = vec35.horizontalDistance();
            this.setDeltaMovement(d26 * (double)(j - pPos.getX()), vec35.y, d26 * (double)(i - pPos.getZ()));
        }
        if (flag) {
            Vec3 vec36 = this.getDeltaMovement();
            double d27 = vec36.horizontalDistance();
            if (d27 > 0.01) {
                double d19 = 0.06;
                this.setDeltaMovement(vec36.add(vec36.x / d27 * 0.06, 0.0, vec36.z / d27 * 0.06));
            } else {
                Vec3 vec37 = this.getDeltaMovement();
                double d20 = vec37.x;
                double d21 = vec37.z;
                if (railshape == RailShape.EAST_WEST) {
                    if (this.isRedstoneConductor(pPos.west())) {
                        d20 = 0.02;
                    } else if (this.isRedstoneConductor(pPos.east())) {
                        d20 = -0.02;
                    }
                } else {
                    if (railshape != RailShape.NORTH_SOUTH) {
                        return;
                    }
                    if (this.isRedstoneConductor(pPos.north())) {
                        d21 = 0.02;
                    } else if (this.isRedstoneConductor(pPos.south())) {
                        d21 = -0.02;
                    }
                }
                this.setDeltaMovement(d20, vec37.y, d21);
            }
        }
    }

    private boolean isRedstoneConductor(BlockPos pPos) {
        return this.level.getBlockState(pPos).isRedstoneConductor(this.level, pPos);
    }

    protected void applyNaturalSlowdown() {
        double d0 = this.isVehicle() ? 0.997 : 0.96;
        Vec3 vec3 = this.getDeltaMovement();
        vec3 = vec3.multiply(d0, 0.0, d0);
        if (this.isInWater()) {
            vec3 = vec3.scale(0.95f);
        }
        this.setDeltaMovement(vec3);
    }

    @Nullable
    public Vec3 getPosOffs(double pX, double p_38098_, double pY, double p_38100_) {
        BlockState blockstate;
        int k;
        int j;
        int i = Mth.floor(pX);
        if (this.level.getBlockState(new BlockPos(i, (j = Mth.floor(p_38098_)) - 1, k = Mth.floor(pY))).is(BlockTags.RAILS)) {
            --j;
        }
        if (BaseRailBlock.isRail(blockstate = this.level.getBlockState(new BlockPos(i, j, k)))) {
            RailShape railshape = blockstate.getValue(((BaseRailBlock)blockstate.getBlock()).getShapeProperty());
            p_38098_ = j;
            if (railshape.isAscending()) {
                p_38098_ = j + 1;
            }
            Pair<Vec3i, Vec3i> pair = AbstractMinecart.exits(railshape);
            Vec3i vec3i = (Vec3i)pair.getFirst();
            Vec3i vec3i1 = (Vec3i)pair.getSecond();
            double d0 = vec3i1.getX() - vec3i.getX();
            double d1 = vec3i1.getZ() - vec3i.getZ();
            double d2 = Math.sqrt(d0 * d0 + d1 * d1);
            if (vec3i.getY() != 0 && Mth.floor(pX += (d0 /= d2) * p_38100_) - i == vec3i.getX() && Mth.floor(pY += (d1 /= d2) * p_38100_) - k == vec3i.getZ()) {
                p_38098_ += (double)vec3i.getY();
            } else if (vec3i1.getY() != 0 && Mth.floor(pX) - i == vec3i1.getX() && Mth.floor(pY) - k == vec3i1.getZ()) {
                p_38098_ += (double)vec3i1.getY();
            }
            return this.getPos(pX, p_38098_, pY);
        }
        return null;
    }

    @Nullable
    public Vec3 getPos(double pX, double p_38181_, double pY) {
        BlockState blockstate;
        int k;
        int j;
        int i = Mth.floor(pX);
        if (this.level.getBlockState(new BlockPos(i, (j = Mth.floor(p_38181_)) - 1, k = Mth.floor(pY))).is(BlockTags.RAILS)) {
            --j;
        }
        if (BaseRailBlock.isRail(blockstate = this.level.getBlockState(new BlockPos(i, j, k)))) {
            double d9;
            RailShape railshape = blockstate.getValue(((BaseRailBlock)blockstate.getBlock()).getShapeProperty());
            Pair<Vec3i, Vec3i> pair = AbstractMinecart.exits(railshape);
            Vec3i vec3i = (Vec3i)pair.getFirst();
            Vec3i vec3i1 = (Vec3i)pair.getSecond();
            double d0 = (double)i + 0.5 + (double)vec3i.getX() * 0.5;
            double d1 = (double)j + 0.0625 + (double)vec3i.getY() * 0.5;
            double d2 = (double)k + 0.5 + (double)vec3i.getZ() * 0.5;
            double d3 = (double)i + 0.5 + (double)vec3i1.getX() * 0.5;
            double d4 = (double)j + 0.0625 + (double)vec3i1.getY() * 0.5;
            double d5 = (double)k + 0.5 + (double)vec3i1.getZ() * 0.5;
            double d6 = d3 - d0;
            double d7 = (d4 - d1) * 2.0;
            double d8 = d5 - d2;
            if (d6 == 0.0) {
                d9 = pY - (double)k;
            } else if (d8 == 0.0) {
                d9 = pX - (double)i;
            } else {
                double d10 = pX - d0;
                double d11 = pY - d2;
                d9 = (d10 * d6 + d11 * d8) * 2.0;
            }
            pX = d0 + d6 * d9;
            p_38181_ = d1 + d7 * d9;
            pY = d2 + d8 * d9;
            if (d7 < 0.0) {
                p_38181_ += 1.0;
            } else if (d7 > 0.0) {
                p_38181_ += 0.5;
            }
            return new Vec3(pX, p_38181_, pY);
        }
        return null;
    }

    @Override
    public AABB getBoundingBoxForCulling() {
        AABB aabb = this.getBoundingBox();
        return this.hasCustomDisplay() ? aabb.inflate((double)Math.abs(this.getDisplayOffset()) / 16.0) : aabb;
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag pCompound) {
        if (pCompound.getBoolean("CustomDisplayTile")) {
            this.setDisplayBlockState(NbtUtils.readBlockState(pCompound.getCompound("DisplayState")));
            this.setDisplayOffset(pCompound.getInt("DisplayOffset"));
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag pCompound) {
        if (this.hasCustomDisplay()) {
            pCompound.putBoolean("CustomDisplayTile", true);
            pCompound.put("DisplayState", NbtUtils.writeBlockState(this.getDisplayBlockState()));
            pCompound.putInt("DisplayOffset", this.getDisplayOffset());
        }
    }

    @Override
    public void push(Entity pEntity) {
        double d1;
        double d0;
        double d2;
        if (!(this.level.isClientSide || pEntity.noPhysics || this.noPhysics || this.hasPassenger(pEntity) || !((d2 = (d0 = pEntity.getX() - this.getX()) * d0 + (d1 = pEntity.getZ() - this.getZ()) * d1) >= (double)1.0E-4f))) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.1f;
            d1 *= (double)0.1f;
            d0 *= 0.5;
            d1 *= 0.5;
            if (pEntity instanceof AbstractMinecart) {
                Vec3 vec31;
                double d5;
                double d4 = pEntity.getX() - this.getX();
                Vec3 vec3 = new Vec3(d4, 0.0, d5 = pEntity.getZ() - this.getZ()).normalize();
                double d6 = Math.abs(vec3.dot(vec31 = new Vec3(Mth.cos(this.getYRot() * ((float)Math.PI / 180)), 0.0, Mth.sin(this.getYRot() * ((float)Math.PI / 180))).normalize()));
                if (d6 < (double)0.8f) {
                    return;
                }
                Vec3 vec32 = this.getDeltaMovement();
                Vec3 vec33 = pEntity.getDeltaMovement();
                if (((AbstractMinecart)pEntity).getMinecartType() == Type.FURNACE && this.getMinecartType() != Type.FURNACE) {
                    this.setDeltaMovement(vec32.multiply(0.2, 1.0, 0.2));
                    this.push(vec33.x - d0, 0.0, vec33.z - d1);
                    pEntity.setDeltaMovement(vec33.multiply(0.95, 1.0, 0.95));
                } else if (((AbstractMinecart)pEntity).getMinecartType() != Type.FURNACE && this.getMinecartType() == Type.FURNACE) {
                    pEntity.setDeltaMovement(vec33.multiply(0.2, 1.0, 0.2));
                    pEntity.push(vec32.x + d0, 0.0, vec32.z + d1);
                    this.setDeltaMovement(vec32.multiply(0.95, 1.0, 0.95));
                } else {
                    double d7 = (vec33.x + vec32.x) / 2.0;
                    double d8 = (vec33.z + vec32.z) / 2.0;
                    this.setDeltaMovement(vec32.multiply(0.2, 1.0, 0.2));
                    this.push(d7 - d0, 0.0, d8 - d1);
                    pEntity.setDeltaMovement(vec33.multiply(0.2, 1.0, 0.2));
                    pEntity.push(d7 + d0, 0.0, d8 + d1);
                }
            } else {
                this.push(-d0, 0.0, -d1);
                pEntity.push(d0 / 4.0, 0.0, d1 / 4.0);
            }
        }
    }

    @Override
    public void lerpTo(double pX, double p_38103_, double pY, float p_38105_, float pZ, int p_38107_, boolean pYaw) {
        this.lx = pX;
        this.ly = p_38103_;
        this.lz = pY;
        this.lyr = p_38105_;
        this.lxr = pZ;
        this.lSteps = p_38107_ + 2;
        this.setDeltaMovement(this.lxd, this.lyd, this.lzd);
    }

    @Override
    public void lerpMotion(double pX, double p_38172_, double pY) {
        this.lxd = pX;
        this.lyd = p_38172_;
        this.lzd = pY;
        this.setDeltaMovement(this.lxd, this.lyd, this.lzd);
    }

    public void setDamage(float pDamage) {
        this.entityData.set(DATA_ID_DAMAGE, Float.valueOf(pDamage));
    }

    public float getDamage() {
        return this.entityData.get(DATA_ID_DAMAGE).floatValue();
    }

    public void setHurtTime(int pRollingAmplitude) {
        this.entityData.set(DATA_ID_HURT, pRollingAmplitude);
    }

    public int getHurtTime() {
        return this.entityData.get(DATA_ID_HURT);
    }

    public void setHurtDir(int pRollingDirection) {
        this.entityData.set(DATA_ID_HURTDIR, pRollingDirection);
    }

    public int getHurtDir() {
        return this.entityData.get(DATA_ID_HURTDIR);
    }

    public abstract Type getMinecartType();

    public BlockState getDisplayBlockState() {
        return !this.hasCustomDisplay() ? this.getDefaultDisplayBlockState() : Block.stateById(this.getEntityData().get(DATA_ID_DISPLAY_BLOCK));
    }

    public BlockState getDefaultDisplayBlockState() {
        return Blocks.AIR.defaultBlockState();
    }

    public int getDisplayOffset() {
        return !this.hasCustomDisplay() ? this.getDefaultDisplayOffset() : this.getEntityData().get(DATA_ID_DISPLAY_OFFSET).intValue();
    }

    public int getDefaultDisplayOffset() {
        return 6;
    }

    public void setDisplayBlockState(BlockState pDisplayTile) {
        this.getEntityData().set(DATA_ID_DISPLAY_BLOCK, Block.getId(pDisplayTile));
        this.setCustomDisplay(true);
    }

    public void setDisplayOffset(int pDisplayTileOffset) {
        this.getEntityData().set(DATA_ID_DISPLAY_OFFSET, pDisplayTileOffset);
        this.setCustomDisplay(true);
    }

    public boolean hasCustomDisplay() {
        return this.getEntityData().get(DATA_ID_CUSTOM_DISPLAY);
    }

    public void setCustomDisplay(boolean pShowBlock) {
        this.getEntityData().set(DATA_ID_CUSTOM_DISPLAY, pShowBlock);
    }

    @Override
    public Packet<?> getAddEntityPacket() {
        return new ClientboundAddEntityPacket(this);
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(switch (this.getMinecartType()) {
            case Type.FURNACE -> Items.FURNACE_MINECART;
            case Type.CHEST -> Items.CHEST_MINECART;
            case Type.TNT -> Items.TNT_MINECART;
            case Type.HOPPER -> Items.HOPPER_MINECART;
            case Type.COMMAND_BLOCK -> Items.COMMAND_BLOCK_MINECART;
            default -> Items.MINECART;
        });
    }

    public static enum Type {
        RIDEABLE,
        CHEST,
        FURNACE,
        TNT,
        SPAWNER,
        HOPPER,
        COMMAND_BLOCK;

    }
}

